// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST', 'jquery' ], function(REST) {
    "use strict";

    var STATUS_TIMEOUT = 3000;
    return {

        /**
         * Retrieve certificate information from the server.
         *
         * @param {Object}
         *            handlers The success and error handler methods.
         */
        getCertificate : function(handlers) {
            REST.getURI('/rest/certs/server', handlers);
        },

        /**
         * Create a self-signed certificate
         *
         * @param {Object}
         *            certificate object
         * @params {Object} handlers with error and success.
         */
        createSelfSignedCertficate : function(certObject, handlers) {
            REST.putObject('/rest/certs/server', certObject, null,
                    handlers);
        },

        /**
         * Create a CSR
         *
         * @param {Object}
         *            certificate object
         * @params {Object} handlers with error and success.
         */
        createCSR : function(certObject, handlers) {
            REST.postObject('/rest/certs/csr', certObject, handlers);
        },

        /**
         * Import a signed certificate
         *
         * @param {Object} Certificate data object
         * @params {Object} handlers with error and success.
         */
        importSignedCertficate : function(certDataObject, handlers) {
            REST.putObject('/rest/certs/csr', certDataObject, null,
                    handlers);
        },

        /**
         * Find out whether a host is reachable, by trying to read its controller-state.json file.
         *
         * @param {object}
         *            handlers Success and error handlers
         */
        checkReachable : function(hostname, ssl, handlers) {
            jQuery.support.cors = true;
            var destUrl;
            var defaultHost = window.location.href.split("/")[2];

            if ( ssl || $.browser.msie) {
                destUrl = 'https://' + (hostname ? hostname : defaultHost) + '/controller-state.json';
            } else {
                destUrl = 'http://' + (hostname ? hostname : defaultHost) + '/controller-state.json';
            }
            $.ajax({
                url : destUrl,
                type : 'GET',
                success : handlers.success,
                error : handlers.error,
                dataType : "json",
                cache: false,
                timeout: 3000
            });
        },

        /**
         * Get the status of a task tracker task.
         *
         * @param {string} hostname The appliance hostname to talk to (== null for current)
         * @param {string} uri The uri to use to get the task status
         * @param {{success:function(TaskResourceDTO):void, error:function(ErrorMessage):void}
         *     handlers Handler functions for success and error conditions.
         */
        getTaskStatus : function(hostname, uri, handlers) {
            var statusUri = hostname ? 'https://' + hostname + uri : uri;
            REST.getURI(statusUri, handlers, { timeout: STATUS_TIMEOUT });
        }
    };
});
