// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define([ 'hp/services/REST' ],
function(REST) {"use strict";

    var EulaService = (function() {

        function EulaService() {

            this.getServiceAccess = function(handlers) {
                var serviceAccessUri = '/rest/appliance/settings/serviceaccess';
                REST.getURI(serviceAccessUri, handlers);
            };

            this.postEulaData = function(isSupportEnabled, handlers) {
                var eulaSaveUri = '/rest/appliance/eula/save';
                var eulaStatus = {
                    supportAccess: isSupportEnabled ? 'yes' : 'no'
                };
                REST.postObject(eulaSaveUri, eulaStatus, handlers);
            };

            this.isEulaRequired = function(handlers) {
                var eulaUri = '/rest/appliance/eula/status';
                REST.getURI(eulaUri, handlers);
            };

            this.updateServiceAccess = function(serviceAccessState, handlers) {
                var updateServiceUri = '/security-base/rest/appliance/settings/enableServiceAccess';
                REST.putObject(updateServiceUri, serviceAccessState, null, handlers);
            };

        }

        return new EulaService();

    }());
    return EulaService;
});