// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['jquery'],
function() { "use strict";

    var GraphicsApplianceView = (function() {
      
        var CANVAS = '.hp-appliance-faces canvas';
        var UNDER = '.hp-appliance-nodes';
        var GRAPHIC_ASIDE = '.hp-graphic-aside';
      
        /**
         * Constructor
         */
        function GraphicsApplianceView() {
          
            function portLocation(node, port) {
                var node = $('#n' + node);
                var nodePosition = node.position();
                var port = $('li#p' + port, node);
                var portPosition = port.position();
                return {left: (25 + portPosition.left),
                    top: (nodePosition.top + portPosition.top - 5)};
            }
            
            function connect(context, node1, port1, node2, port2, color) {
                var position1 = portLocation(node1, port1);
                var position2 = portLocation(node2, port2);
                context.beginPath();
                context.lineWidth = 12;
                context.lineCap = 'round';
                context.strokeStyle = color;
                context.moveTo(position1.left, position1.top);
                context.quadraticCurveTo(position1.left,
                    position1.top + ((position2.top - position1.top) / 2),
                    position2.left, position2.top);
                context.stroke();
            }
            
            function draw() {
                var under = $(UNDER);
                var canvas = $(CANVAS)[0];
                $(CANVAS).attr('width', under.width()-2).attr('height', under.height()-2);
                if (canvas.getContext) {
                    var context = canvas.getContext('2d');
                    context.clearRect(0, 0, canvas.width, canvas.height);
                    connect(context, 1, 3, 2, 3, 'rgba(82, 134, 30, 0.5)');
                    connect(context, 1, 5, 2, 6, 'rgba(255, 153, 0, 0.5)');
                }
            }
          
            /**
             * @public
             */
            this.init = function() {
                
                draw();
                
                $(GRAPHIC_ASIDE).click(function () {
                    $(this).toggleClass('hp-thumbnail');
                });
                
                $(window).resize(function () {
                    draw();
                });
            };
            
            this.resume = function() {
            };
        }

        return new GraphicsApplianceView();
    }());
    
    return GraphicsApplianceView;
});
