// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeDeployView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/node/NodePresenter',
	'hp/core/Router',
	'hp/core/UrlFragment',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	 'hp/services/REST',
	'hp/core/Localizer',
	 'hp/model/Session',
	'text!hpPages/core/header_help.html',
    'jquery',
    'hpsum/view/node/jquery.hpsumInstallables',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo'],

function(presenter, router,urlFragment, notifications,helpMenu, DialogView, rest,localizer,session,headerHelpHtml) { "use strict";

    var NodeDeployView = (function() {
      
        var DEPLOY = '#hpsum-node-deploy-ok',
			ANALYSIS = '#hpsum-node-deploy-analysis',
			ASSOC_ANALYSIS = '#hpsum-assoc-node-deploy-analysis',
			ASSOC_CLOSE = '#hpsum-assoc-node-deploy-close',
            CANCEL = '#hpsum-nodes-deploy-close',
			PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
            FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            PANELS = '#hpsum-node-deploy-panels',						
			DESCR = '#hpsum-node-deploy-descr',
			REBOOTOPTION = '#hpsum-reboot-option',
			DELAYSEC= '#hpsum-node-delay-seconds',
			DELAYMSG= '#hpsum-node-reboot-message',
			TYPE = '#hpsum-node-deploy-type',
			//GROUP = '#hpsum-node-deploy-group',			
            ROUTE_PREFIX = '/node/deploy',
			NONECHECKBOX = '.nonecheckbox',
			USESNMPCHECKBOX ='.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX ='.useAgentlesscheckbox',
			USEWEBEMCHECKBOX ='.useWEBEMcheckbox',
			DOWNGRADECHKBOXCOMP ='.downgradechkbox',
			REWRITECHKBOXCOMP ='.rewritechkbox',
			FIRMWARECHKBOXCOMP ='.firmwarechkbox',
			SOFTWARECHKBOXCOMP ='.softwarechkbox',
			DEPLOYENCCHKBOXCOMP ='.enclosurechkbox',	
			COMPONENT_CONFIG_DIALOG = '#hpsum-component-config-dialog',
			COMMON_REBOOT = '#hpsum-common-reboot-options',
			REBOOT_ACTIVATE = '#hpsum-reboot-to-activate-options',
			ACTIVATE_SELECTION = '#hpsum-activate-selection',
			NO_REBOOT_REQ = '#hpsum-no-reboot-required',
    		FORM = '#hpsum-node-deploy-add-form',
			ASSOC_NODES = '#all-assocnodes',
			ASSOC_NODE_DIALOG = '#hpsum-assoc-node-dialog',
			ASSOC_NODE_COMP = '#hpsum-assoc-node-components',
			ASSOC_OPTIONS = '#assoc-options',
		    SPLASH_DIALOG = '#hpsum-splash-dialog',
        	SPLASH_SPINNER = '#hpsum-splash-spinner';					 			
        /**
         * Constructor
         */
        function NodeDeployView() {
          
          
            var nodeItem=null;
			var componentConfigDialogContents;
			var componentsList = { 
					hapi: {
							components: {
								component:[]
							}						
            		}
            }						
			
			var assocnodesList = [];
			var  rebootoptions  = {
									action:'If Needed',
									delay :'3600',
									message :'Earlier Reboot Message Reboot at user request after deploy '												
								  };
			/*var  osoptions  = {
							none:false,
							usesnmp:false,
							useagentless:false,
							usewebem:false							
						};*/		
			var  installationoptions  = {
							downgrade:false,
							rewrite:false												
						};	
			var  forceoptions  = {
							firmware :true,
							software :true												
						};
						
			var optiondetails = { 
					hapi: {
							reboot_options: {
									action:'Never',
									delay :'3600',
									message :'Earlier Reboot Message Reboot at user request after deploy '												
								  },
							activate_sfw: false,
							installation_option:{
							firmware :false,
							software :false,
							downgrade: false,
							rewrite:false,
							force:false							
							},
							deploy_enclosure: false,
							associated_nodes: {
								associated_node: []
							}
            		}
            }
            
            var displayBaselineError = false;
			var initialGetattr = null;
            
			  function onItemChange(item) {
            	nodeItem = item.hapi;            	
            	
                if (nodeItem) {
                	//for some reason, the getdata is called multiple times sometimes as undefined node
                	//hence adding this check to load attributes only in the begining
                	if(initialGetattr == null)
						loadAttributes();
                    //If the user has deleted the baseline then we cannot proceed to deploy
                    //so we display a message that there is no available baseline and exit
                    if(nodeItem.baselines.length == 0 && !displayBaselineError) {
                        displayBaselineError = true;
                        $("<div></div>").dialog( {
                            buttons: { "Ok": function () {
                                displayBaselineError = false;
                                $(this).dialog("close");
                                $(CANCEL).trigger('click');
                                }
                            },
                            close: function (event, ui) { $(this).remove(); },
                            resizable: false,
                            title: localizer.getString("hpsum.node.doDeploy"),
                            modal: true
                        }).text( localizer.getString("hpsum.node.noBaselineAvailable") );
                    }
                    $(DESCR).text(nodeItem.name);
                    $(TYPE).text(nodeItem.type);
                    
					//hide tpm warning by default
					$('#tpm-status-update').hide();
					//$(GROUP).text(nodeItem.group);
					if(nodeItem.type.match(/Windows|Linux/i)) {
					   $('#hpsum-osmanagement-options-collapsible').css("display","block");
					}
					else 
						$('#hpsum-osmanagement-options-collapsible').css("display","none");
					if(nodeItem.type.match(/integrityilo|virtual_connect|pdu/i)) {
					    $('#hpsum-installation-options-collapsible').css("display","none");
					    $('#hpsum-force-options-collapsible').css("display","none");
					}
					else {
						 $('#hpsum-installation-options-collapsible').css("display","block");
					  	 $('#hpsum-force-options-collapsible').css("display","block");
					}
					if(nodeItem.type.match(/virtual_connect/i)) {
						$('#hpsum-vc-options-collapsible').css("display","block");
					}
					else
					{
						$('#hpsum-vc-options-collapsible').css("display","none");
					}
					
					
					//Expand reboot options for hp-ux
					if(nodeItem.type.match(/hpux/i)) {
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
					}
					
					if(nodeItem.tpm_state == true) {
			   			$('#tpm-status-update').show();
			  		}
					var options = {
						command:'init',
						nodeItem:nodeItem,
						onSelectionChanged:onSelectionChanged
						
					};
						
                    if(nodeItem.hasOwnProperty('activate_sfw')){
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
						$(COMMON_REBOOT).hide();
						$(REBOOT_ACTIVATE).show();
						if(!nodeItem.is_powered_on) {
							$(ACTIVATE_SELECTION).closest("li").hide();
							$(NO_REBOOT_REQ).show();
						} else {
							$(ACTIVATE_SELECTION).closest("li").show();
							$(NO_REBOOT_REQ).hide();
						}
						if(nodeItem.activate_sfw) {
							$(ACTIVATE_SELECTION).val('YES');
						} else {
							$(ACTIVATE_SELECTION).val('NO');
						}
					} else {
						if(nodeItem.type.match(/windows|linux|hpux|vmware/i)){
						$(COMMON_REBOOT).show();
						$('#hpsum-reboot-options-collapsible').css("display","block");
						$(REBOOT_ACTIVATE).hide();
						}
						else{
							$('#hpsum-reboot-options-collapsible').css("display","none");
						}
					}     
					//initInstallReview();
					$('#all-baselines').hpsumInstallables(options);
            
												
					if(nodeItem.node_state === 'UAN') {
						//The problem is that getdata is called multiple time and there is a chance of changing Deploy and Analyze buttons attributes in the following
						//code. So adding conditions to check if the deploy/analyze button is enabled or not, based on this change the attribute
						if($(DEPLOY).attr("disabled") == "disabled")
						    $(DEPLOY).attr("disabled", true);	
						else
						    $(DEPLOY).attr("disabled", false);	
						
						if($(ANALYSIS).attr("disabled") == "disabled")       
						    $(ANALYSIS).attr("disabled", true);	
					    else
					        $(ANALYSIS).attr("disabled", false);	
					}
					else if (nodeItem.node_state === 'INSTALLDONE')
					{
						$(DEPLOY).attr("disabled", true);	
						$(ANALYSIS).attr("disabled", true);
					}	
					else
					{	
						$(ANALYSIS).attr("disabled", false);	
					}
					showInstallationOptions(nodeItem);
					showAssociatedNodes(nodeItem);
					
					//If any input that needs a setattribute call to be set is changed
					//enable the analysis button, and disable the deploy button
                    $('.require-analysis').on('click', function(){
                        $(ANALYSIS).removeAttr('disabled');
                        $(DEPLOY).attr('disabled','disabled');
                    });
                } else {
					//notifications.show("Please select correct node", 'error');
					notifications.show(localizer.getString('hpsum.node.pleaseSelectCorrectNode'), 'error');
                    $(DESCR).text("");
                    $(TYPE).text("");
					//$(GROUP).text("");
					$(DEPLOY).attr("disabled", true);	
					$(ANALYSIS).attr("disabled", true);	
					$(CANCEL).trigger('click');	
                }               
            }		
			
			function onSelectionChanged(id, value, componentList){
					if(value == true){
						$(ANALYSIS).attr("disabled", false);
						$(DEPLOY).attr("disabled", true);
					}
					else{
						$(ANALYSIS).attr("disabled", true);
						if(componentList.component.length > 0 && componentList.failed_dependency == 0) {
						  $(DEPLOY).attr("disabled", false);
						} else {
						  $(DEPLOY).attr("disabled", true);  
						}
					}
			}
			
            function showInstallationOptions(item){
            	//send getattributes for this node
            	presenter.otheroption(item, {success:function(data){
            						if(data && data.hasOwnProperty("hapi")){
				
				
				if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options){
						 
						$('#hpsum-reboot-option option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
		                  });
						if( -1 < data.hapi.reboot_options.delay){
							$(DELAYSEC).val(data.hapi.reboot_options.delay);				
						}
						else{
							$(DELAYSEC).val('3600');				
						}
						
						$(DELAYMSG).attr('value', data.hapi.reboot_options.message);				
					}
					/*if(data.hapi.hasOwnProperty("os_management_options") && data.hapi.os_management_options){
						$(USESNMPCHECKBOX).attr('checked', false);							
						$(USEAGENTLESSCHECKBOX).attr('checked', false);							
						$(USEWEBEMCHECKBOX).attr('checked', false);
						$(NONECHECKBOX).attr('checked', false);
						if( data.hapi.os_management_options.length > 0){
							if(data.hapi.os_management_options[0].match(/NONE/i))
								$(NONECHECKBOX).attr('checked', true);
							else{
								if (data.hapi.os_management_options[0].match(/AMS/i))
									$(USEAGENTLESSCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/SNMP/i))
									$(USESNMPCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/WBEM/i))
									$(USEWEBEMCHECKBOX).attr('checked', true);
									
							}
						}
					}*/
					if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
						$(DOWNGRADECHKBOXCOMP).attr('checked', data.hapi.installation_option.downgrade);							
						$(REWRITECHKBOXCOMP).attr('checked', data.hapi.installation_option.rewrite);
						$(FIRMWARECHKBOXCOMP).attr('checked', data.hapi.installation_option.forcefirmware);							
						$(SOFTWARECHKBOXCOMP).attr('checked', data.hapi.installation_option.forcesoftware);					
										
					}
					if(data.hapi.hasOwnProperty("vc_activation_options") && data.hapi.vc_activation_options){
						$('#hpsum-Enet-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.eth_activation_order))
		    		            $(this).attr('selected', true);
		                  });
		                 $('#hpsum-fc-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.fc_activation_order))
		    		            $(this).attr('selected', true);
		                  });
						$('#hpsum-Enet-delay').val(data.hapi.vc_activation_options.eth_activation_delay);
						$('#hpsum-FC-delay').val(data.hapi.vc_activation_options.fc_activation_delay);
					}
				}
				},
            	error:function(){
            		
            	}
            		
            	});
            	
            	
            }
			function showAnalysisSplash(){
				
				 $(SPLASH_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
			        dialogClass : 'hp-splash-dialog',
			        width : 400
			    });
			    
			    $(SPLASH_SPINNER).show();	
			}
			
			function closeAnalysisSplash(){
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			function btnAnalyzeClicked() {
				showAnalysisSplash();
				var inst = $('#all-baselines').data('plugin_hpsumInstallables');
				var componentsList = inst.getComponents();
				//populate the option details into the optiondetails object from UI
				setoptiondetails(nodeItem);
				
				//send the setattribute command to engine
				if(initialGetattr.hapi.installation_option.downgrade != optiondetails.hapi.installation_option.downgrade ||
					initialGetattr.hapi.installation_option.rewrite != optiondetails.hapi.installation_option.rewrite ||
					initialGetattr.hapi.installation_option.software != optiondetails.hapi.installation_option.software ||
					initialGetattr.hapi.installation_option.firmware != optiondetails.hapi.installation_option.firmware ||
					initialGetattr.hapi.reboot_options.action != optiondetails.hapi.reboot_options.action) {
					
					presenter.setattribute(nodeItem,optiondetails, {
						success : onsetattributeSuccess,
						error : onsetattributeerror
					});
				}else if(nodeItem.type.match(/OA|virtual_connect|sd2oa|integrityilo/i)){
					presenter.setattribute(nodeItem,optiondetails, {
						success : onsetattributeSuccess,
						error : onsetattributeerror
					});
	
					presenter.analysis(nodeItem, componentsList, {
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
					});
				}
				else
				{
					presenter.analysis(nodeItem, componentsList, {
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
					});
					
				}
				
				
		        
		        var progressTimer = setInterval(function () {
				var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.node_id;
		        rest.getURI(node_uri + "/getstatus", {
		                			
		                			success : function(data) {
		                				
		                				if(data.hapi.node_status.node_state === "ANALYSIS")
		                				{
		                					
		                				}
		                				else if(data.hapi.node_status.node_state === "UAN")
		                				{
		                					clearInterval(progressTimer);
	            			
	            			                //show install review for all the nodes
					                        //initInstallReview();
						    				$('#all-baselines').hpsumInstallables('recalculate');
					                        closeAnalysisSplash();
					        
                                            //disable analyze button
                                            $(ANALYSIS).attr("disabled", true);
					        
		                				}
		                				else if(data.hapi.node_status.node_state === "ERROR")
		                				{
		                					clearInterval(progressTimer);
		                					closeAnalysisSplash();
		            					}
		            				},
		                			error : function(errorInfo) {
		                    			
		                			}
		            			});
		          }, 3000);
			}	
		    function analyzeSuccess(data, nodeid) {
			
			}
			
			function analyzeError(error) {
				$(SPLASH_SPINNER).hide();
				$(SPLASH_DIALOG).dialog('destroy');
			}
			    	
			function  setoptiondetails(nodeItem){
			
				
				    if(!nodeItem.type.match(/integrityilo|virtual_connect|ipdu/i)){
                   		          optiondetails.hapi.installation_option ={};
                               	          optiondetails.hapi.installation_option.downgrade = $(DOWNGRADECHKBOXCOMP).is(':checked');	
				          optiondetails.hapi.installation_option.rewrite = $(REWRITECHKBOXCOMP).is(':checked');
				          optiondetails.hapi.installation_option.software =  $(SOFTWARECHKBOXCOMP).is(':checked');	
				          optiondetails.hapi.installation_option.firmware =  $(FIRMWARECHKBOXCOMP).is(':checked');	
					}
					/*if($(SOFTWARECHKBOXCOMP).is(':checked') || $(FIRMWARECHKBOXCOMP).is(':checked'))
					{
						editOptions.hapi.installation_option.force = true;
					}*/
					if((nodeItem.hasOwnProperty('activate_sfw')) || (nodeItem.type.match(/windows|linux|vmware|hpux/i))){
						optiondetails.hapi.reboot_options ={};	
						optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
						optiondetails.hapi.reboot_options.delay = $(DELAYSEC).val();				
						optiondetails.hapi.reboot_options.message = $(DELAYMSG).val();
					}
					/*if(nodeItem.type.match(/windows|linux|hpux/i)){
						optiondetails.hapi.os_management_options ='';
						if($(NONECHECKBOX).attr('checked'))
							optiondetails.hapi.os_management_options = "None";
						else {
							if($(USESNMPCHECKBOX).attr('checked'))
								optiondetails.hapi.os_management_options += "SNMP|";						
							if($(USEAGENTLESSCHECKBOX).attr('checked'))
								optiondetails.hapi.os_management_options += "AMS|";													
							if($(USEWEBEMCHECKBOX).attr('checked'))
								optiondetails.hapi.os_management_options += "WBEM|";
						}
					}*/
					
					if(nodeItem.type.match(/virtual_connect/i)) {
						optiondetails.hapi.vc_activation_options ={};			
			            		optiondetails.hapi.vc_activation_options.eth_activation_order = $('#hpsum-Enet-order').val();
		    		   		optiondetails.hapi.vc_activation_options.fc_activation_order = $('#hpsum-fc-order').val();     
						optiondetails.hapi.vc_activation_options.eth_activation_delay = $('#hpsum-Enet-delay').val();
						optiondetails.hapi.vc_activation_options.fc_activation_delay= $('#hpsum-FC-delay').val();	
					
					}
					var tmp = $(ACTIVATE_SELECTION).val();
					if( tmp == 'NO') {
						optiondetails.hapi.activate_sfw = false;
					} else {
						optiondetails.hapi.activate_sfw = true;
					}
				if($(DEPLOYENCCHKBOXCOMP).is(':checked'))
				{
					optiondetails.hapi.deploy_enclosure = true;
				}
				if(nodeItem.type.match(/OA/i)){
					var tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
					var currTable = $(tableid).dataTable();
					
					var selectedRows = $(tableid + ' tbody tr');
					
					for(var tmp=0; tmp < selectedRows.length; tmp++){
						var compData = currTable.fnGetData(selectedRows[tmp].rowIndex-1);
						
						if(compData) {
							var bselected = false, bforce = false;
							if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
								bselected = true;
							else
								bselected = false;
						
							var item = {
								node_id : compData.node_id,
								selected : bselected
							};
						
							optiondetails.hapi.associated_nodes.associated_node.push(item);
						} 
					}
				}
			}
			/**
             * @private
             * Call presenter's onAnalysis() to check for dependencies for a selected component/baseline to the node 
             */
        		
              		
			function onsetattributeSuccess(item) {               
				loadAttributes();
               //do nothing
            }
			
			function onsetattributeerror(errorMessage) {               
				
               onAnalysisError(errorMessage);
            }
			/**
             * @private
             */
				
               
            /**
             * @private
             */
            function onAnalysisError(errorMessage) {
                notifications.show(errorMessage, 'error');                          
				$(ANALYSIS).attr("disabled", false);	
				$(DEPLOY).attr("disabled", true);	
				$(CANCEL).trigger('click');	

            }			
			
			 
			
            /**
             * @private
             * Call presenter's deploy() to deploy  a selected component/baseline to the node 
             */
            function onDeploy() {            
        		
              if(nodeItem  && nodeItem.node_state === 'UAN') {
					if(nodeItem.tpm_state == true)
					{
						var tpm_bypass = { 
											hapi: {											 
											 tpm_bypass:'true',
											 node_id:nodeItem.node_id,
										  }
										}
							presenter.setattribute(nodeItem, tpm_bypass, {						   
						     success : function(){
						       presenter.deploy(nodeItem, {
							    success : onDeploySuccess,
							    error : onDeployError
						});  
						   },
						   error : function() {
						            onDeployError();
						   }
						});
						
					}
					else{
						presenter.deploy(nodeItem, {
							success : onDeploySuccess,
							error : onDeployError
						});  
					}                    
                }
    			
            }
			 /**
             * @private
             */
            function onDeploySuccess(item) {               
				
                $(CANCEL).trigger('click');
            }

            /**
             * @private
             */
            function onDeployError(errorMessage) {
                notifications.show(errorMessage, 'error');                        
				
				$(DEPLOY).attr("disabled", true);				
				$(CANCEL).trigger('click');
				
            }
			
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }					
			
			/**
             * @private
             */
            function onPopulateError(errorMessage) {
                notifications.show(errorMessage, 'error');                       
				$(ANALYSIS).attr("disabled", true);				
				$(DEPLOY).attr("disabled", true);				
				$(CANCEL).trigger('click');
				
            }
		
			//Initialize Associated Nodes table to show the list of associated nodes
            function initAssocTable(tableid) {
		    
				var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString('hpsum.node.noAssociatedNodes')
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
					bServerSide:false,
				    //aaData: data,
					aoColumns : [
						{mDataProp: 'node_ip'},
						{mDataProp: 'node_type'},
				        {mDataProp: 'link' ,
						fnRender: function (oObj) {
							if(oObj.aData.node_id){
								if(oObj.aData.state.match(/UAN/i))
									return '<a id = "componentLink" href="javascript:void(0);">' + localizer.getString('hpsum.node.applicableComponents') + '</a>';
								else
									return localizer.getString('hpsum.node.nodeNotReady');
							}
							else
							{
								return localizer.getString('hpsum.node.waitingForComp');
							}
						}},
						{mDataProp: 'status',
						fnRender: function (oObj) {
							if(oObj.aData.state.match(/UAN/i))
									return localizer.getString('hpsum.node.readyForDeploy');
								else
									return oObj.aData.status;
						}},
				      		{mDataProp: 'node_id', "bVisible": false, sWidth: 5},
						{mDataProp: 'state', "bVisible": false, sWidth: 5}
					],
				    aaSorting: [[ 0, "asc" ]],				    
					fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_id);
				        return nRow;
				    }
				    });//.rowReordering().addClass('hp-reorderable');			
			}

			function showAssociatedNodes(nodeItem) {
			
				$(ASSOC_OPTIONS).hide();
						   
				$(ASSOC_NODES).empty();
						  				   
				$(ASSOC_NODES).append('<table class="hp-selectable" id="hpsum-assoc-nodes-' + nodeItem.node_id + '-table"><thead><tr><td><b>' 
										+ localizer.getString('hpsum.node.ip') + '</b></td><td><b>' + localizer.getString('hpsum.node.type') + '</b></td><td><b>' 
										+ localizer.getString('hpsum.node.componentDetails') + '</b></td><td><b>' + localizer.getString('hpsum.common.statusStr') + '</b></td><td></td><td></td></tr></thead></table>');
						   
				var tableid = '#hpsum-assoc-nodes-' + nodeItem.node_id + '-table';
				initAssocTable(tableid);

				var assoc_table = $(tableid).dataTable();
				assoc_table.fnClearTable();	

				if(nodeItem.type.match(/OA/i)){
					if(nodeItem.associated_device == undefined) 
            			return;
            		if(nodeItem.associated_device.length == 0)
            			return;
					
					for(var i=0; i<nodeItem.associated_device.length; i++){
						if(nodeItem.associated_device[i].node_id){
						
							var node_data = [{
								'node_type': nodeItem.associated_device[i].type +' '+ nodeItem.associated_device[i].productName,
								'node_ip': nodeItem.associated_device[i].ip_or_dns,
								'link': "",
								'status': nodeItem.associated_device[i].node_status,
								'node_id': nodeItem.associated_device[i].node_id,
								'state': nodeItem.associated_device[i].node_state
							}];
							assoc_table.fnAddData(node_data);

							if(nodeItem.associated_device[i].node_state.match(/UAN/i)){
								if(nodeItem.associated_device[i].selected)
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								else
									$(tableid + ' tbody tr').last().removeClass('hp-selected');
							}
							else
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
						}
					}
							  							  
					for(var i=0; i<nodeItem.interconnect_device.length; i++){
						if(nodeItem.interconnect_device[i].node_id){
							
							var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.interconnect_device[i].node_id;
							var node_data = [{
								'node_type': nodeItem.interconnect_device[i].type +' '+ nodeItem.interconnect_device[i].productName,
								'node_ip': nodeItem.interconnect_device[i].ip_or_dns,
								'link': "",
								'status': nodeItem.interconnect_device[i].node_status,
								'node_id': nodeItem.interconnect_device[i].node_id,
								'state': nodeItem.interconnect_device[i].node_state
							}];
							if(nodeItem.interconnect_device[i].type.match(/VCDEV/i)) 
							{
							    if(nodeItem.interconnect_device[i].isConjoined != "0")
							    {					     
									assoc_table.fnAddData(node_data);
								}
							}
							else
							    assoc_table.fnAddData(node_data);

							if(nodeItem.interconnect_device[i].node_state.match(/UAN/i)){
								if(nodeItem.interconnect_device[i].selected)
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								else
									$(tableid + ' tbody tr').last().removeClass('hp-selected');
							}
							else
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
								
						}	
					}
				}
				
				if((nodeItem.type.match(/SAS_SWITCH/i)) || (nodeItem.type.match(/ilo/i)) || (nodeItem.type.match(/VIRTUAL_CONNECT/i))){

					if(nodeItem.hasOwnProperty('oa_ip_address') || nodeItem.hasOwnProperty('oa_address')){
						if(nodeItem.assoc_node_id){
						
							var node_uri = "/Session/" + session.getToken() + "/node/" + nodeItem.assoc_node_id;
							
							rest.getURI(node_uri +"/getdata",
							{
								nodeid : nodeItem.node_id,
								success : function(data) {
														
									var node_data = [{
										'node_type': localizer.getString('hpsum.node.onboardAdministrator'),
										'node_ip': nodeItem.oa_ip_address ? nodeItem.oa_ip_address:nodeItem.oa_address,
										'link': "",
										'status': data.hapi.node_status,
										'node_id': (nodeItem.assoc_node_id)?nodeItem.assoc_node_id:'',
										'state':data.hapi.node_state
									}];
								
									assoc_table.fnAddData(node_data);

									$(tableid + ' tbody tr').last().addClass('hp-disabled');
									$(tableid + " tbody tr").click( function( e ) {
										var srcElem, browsertype = 0;
										var data = $(tableid).dataTable().fnGetData( this );
										
										//Check if firefox or (chrome and IE)
										if(e.srcElement)
											srcElem = e.srcElement;//Chrome and IE
										else
										{
											srcElem = e.target;//Firefox
											browsertype = 1;
										}
										
										if(browsertype){
											populateComponents(data.node_id);
											//row is disabled, so only force option can be applied
											//no row selection/deselection supported
											if ( $(this).hasClass('hp-disabled') ) 
												return;	
											$(this).toggleClass('hp-selected');
										}
										else{
											if ( srcElem.innerText.match(/Applicable Components/i))			
												populateComponents(data.node_id);
											else{
												//row is disabled, so only force option can be applied
												//no row selection/deselection supported
												if ( $(this).hasClass('hp-disabled') ) 
													return;	
												$(this).toggleClass('hp-selected');
											}
										}
									});
								},
								error : function(errorInfo){ }
							});
						}
					}
					if(nodeItem.type.match(/SAS_SWITCH/i)){
						if(nodeItem.hasOwnProperty('partner_ip_address')){
							if(nodeItem.partner_node_id){
							
								var node_data = [{
									'node_type': localizer.getString('hpsum.switchUI.partnerSwitch'),
									'node_ip': nodeItem.partner_ip_address,
									'link': "",
									'status': "",
									'node_id': (nodeItem.partner_node_id)?nodeItem.partner_node_id:'',
									'state': ""
								}];

								assoc_table.fnAddData(node_data);
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
							}
						}
					}
				}
				
				if(nodeItem.type.match(/switch/i)){
					if(nodeItem.associated_device == undefined) 
            			return;
            		if(nodeItem.associated_device.length == 0)
            			return;
					
					for(var i=0; i<nodeItem.associated_device.length; i++){
						//if(nodeItem.associated_device[i].node_id){
						
							var node_data = [{
								'node_type': nodeItem.associated_device[i].type +' '+ nodeItem.associated_device[i].productName,
								'node_ip': nodeItem.associated_device[i].ip_or_dns,
								'link': "",
								'status': nodeItem.associated_device[i].node_status,
								'node_id': nodeItem.associated_device[i].node_id,
								'state': nodeItem.associated_device[i].node_state
							}];
							assoc_table.fnAddData(node_data);

							if(nodeItem.associated_device[i].node_state.match(/UAN/i)){
								if(nodeItem.associated_device[i].selected)
									$(tableid + ' tbody tr').last().addClass('hp-selected');
								else
									$(tableid + ' tbody tr').last().removeClass('hp-selected');
							}
							else
								$(tableid + ' tbody tr').last().addClass('hp-disabled');
						//}
					}
				}
								
				//to enable click event for a row
				$(tableid + " tbody tr").click( function( e ) {

					var srcElem, browsertype = 0;
					var data = $(tableid).dataTable().fnGetData( this );
					
					//Check if firefox or (chrome and IE)
					if(e.srcElement)
						srcElem = e.srcElement;//Chrome and IE
					else
					{
						srcElem = e.target;//Firefox
						browsertype = 1;
					}
					
					if(browsertype){
						populateComponents(data.node_id);
						//row is disabled, so only force option can be applied
						//no row selection/deselection supported
						if ( $(this).hasClass('hp-disabled') ) 
							return;	
						$(this).toggleClass('hp-selected');
						$(ANALYSIS).attr("disabled", false);
					}
					else{
						if ( srcElem.tagName == 'A' )			
							populateComponents(data.node_id);
						else{
							//row is disabled, so only force option can be applied
							//no row selection/deselection supported
							if ( $(this).hasClass('hp-disabled') ) 
								return;	
							$(this).toggleClass('hp-selected');
							$(ANALYSIS).attr("disabled", false);
						}
					}
				});
			}

			function showAssocDialog(nodeid){
				
				 $(ASSOC_NODE_DIALOG).dialog({
			        modal : true,
			        position : "center",
			        draggable : false,
			        resizable : false,
			        show : 'fade',
			        dialogClass : 'hp-dialog',
			        width : 800,
					title : "Applicable Components",
				});
				$('button', $(ASSOC_NODE_DIALOG)).on('click', function () {
                        $(this).dialog('destroy');
				});
				$(ASSOC_ANALYSIS).live('click', function(ev) {
                    btnAssocAnalyzeClicked.call(this,nodeid);
                    ev.preventDefault();
                });
				$(ASSOC_CLOSE).live('click',function(ev){
					$(ASSOC_NODE_DIALOG).dialog('destroy');
					//ev.preventDefault();
				});
				$(ASSOC_NODE_DIALOG).css({'max-width':'800px'});
				$(ASSOC_NODE_DIALOG).dialog('open');
			}
									
			function initComponentTable(tableid) {
            	
  				var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.node.noApplicableComponentsFound")
										},
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : true,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    //aaData: data,
				    aoColumns : [
						{mDataProp: 'name'},
				    	{mDataProp: 'status', sClass: '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>'},
				        {mDataProp: 'product_type'},
				        {mDataProp: 'product_sub_type'},
				        {mDataProp: 'installed_version'},
				        {mDataProp: 'active_version'},
				        {mDataProp: 'available_version'},
				        //{mDataProp: 'has_failed_dependencies'},
				        {mDataProp: 'force', sClass: '<input id="my-toggle" type="checkbox" />'},
						{mDataProp: 'file_name', "bVisible": false},
						{mDataProp: 'component_id', "bVisible": false},
						{mDataProp: 'failed_deps', "bVisible": false},
						{mDataProp: 'device_info', "bVisible": false}
					  ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
					}
				});
			}


			function populateComponents(node_id) {
				var node_uri = "/Session/" + session.getToken() + "/node/" + node_id;
				showAssocDialog(node_id);
				$(ASSOC_ANALYSIS).attr("disabled", true);
				$(ASSOC_NODE_COMP).empty();

				$(ASSOC_NODE_COMP).append('<table class="hp-selectable" id="hpsum-components-table"><thead><tr><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.packageStr") + '</b></td><td><b>' +
                            localizer.getString("hpsum.oneTouchUpdate.statusStr") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.reports.type") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.family") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.installedVersion") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.activeVersion") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.oneTouchUpdate.availableVersion") + '</b></td><td></td><td></td></tr></thead></table>');
				
				$("#assoc-footer").show();
				var comp_tableid = '#hpsum-components-table';
				initComponentTable(comp_tableid);

				rest.getURI( node_uri + "/getupdatelist", 
				{
					nodeid : node_id,
					success : function(data){

						//Populate component table
						var table = $(comp_tableid).dataTable();
						table.fnClearTable();
						var baselineslist = data.hapi.baselines; 
						if(table && baselineslist){
							for(var j=0; j < baselineslist.baseline.length; j++) {
								var currbaseline = baselineslist.baseline[j];
								if(currbaseline.hasOwnProperty("components")) {
								
									var comps_selected = $.grep(currbaseline.components.component, function(comp, index) {
										return (comp.selected);
									});
									
									var comps_notselected = $.grep(currbaseline.components.component, function(comp, index) {
										return (!comp.selected);
									});
									
									//first add all the selected components
									//for(var k=0; k < currbaseline.components.component.length; k++)
									for(var k=0; k < comps_selected.length; k++)	
									{
										var comp = comps_selected[k];
										var stat='', forcetoggle='', comp_id = comp.component_id;
										stat = '<div class="hp-status"><div class="hp-status-value hp-status-ok"><span class="hp-value">ok</span></div></div>';
										
										var failed_deps = '';
										if(currbaseline.components.component[k].has_failed_dependencies === true)
										{
											stat = '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
											failed_deps = currbaseline.components.component[k].failed_dependencies.failed_dependency;
										}
										
										var compItem = [{
											'name': comp.name,
											'status': stat,
											'product_type': comp.product_type,
											'product_sub_type': comp.product_sub_type,
											'installed_version': comp.installed_version,
											'active_version': comp.active_version,
											'available_version': comp.available_version,
											//'has_failed_dependencies': currbaseline.components.component[k].has_failed_dependencies,
											'force': forcetoggle,
											'file_name': comp.file_name,
											'component_id': comp.component_id,
											'failed_deps': failed_deps,
											'device_info': (comp.hasOwnProperty('device_info')) ? comp.device_info : ''
										}];
										
										table.fnAddData(compItem);
										
										$(comp_tableid + ' tbody tr').last().addClass('hp-selected');
									}
									
									for(var k=0; k < comps_notselected.length; k++)	
									{
										var comp = comps_notselected[k];
										var stat='', forcetoggle='', comp_id = comp.component_id;
										
										stat = '<div class="hp-status"><div class="hp-status-value hp-status-disabled"><span class="hp-value">disabled</span></div></div>';
										
										if(currbaseline.components.component[k].is_selectable === false)		
											forcetoggle = '<input id="toggle-' + comp_id + '" type="checkbox" />'; //'<div><label>Force</label><input id="toggle-"' + comp_id + ' type="checkbox" /></div>';
										else
											forcetoggle = '';
										
										var failed_deps = '';
										if(comp.has_failed_dependencies === true)
										{
											stat = '<div class="hp-status"><div class="hp-status-value hp-status-error"><span class="hp-value">error</span></div></div>';
											failed_deps = currbaseline.components.component[k].failed_dependencies.failed_dependency;
										}
										
										var compItem = [{
											'status': stat,
											'name': comp.name,
											'product_type': comp.product_type,
											'product_sub_type': comp.product_sub_type,
											'installed_version': comp.installed_version,
											'active_version': comp.active_version,
											'available_version': comp.available_version,
											//'has_failed_dependencies': currbaseline.components.component[k].has_failed_dependencies,
											'force': forcetoggle,
											'file_name': comp.file_name,
											'component_id': comp.component_id,
											'failed_deps': failed_deps,
											'device_info': (comp.hasOwnProperty('device_info')) ? comp.device_info : ''
										}];
										
										table.fnAddData(compItem);
										
										if(forcetoggle != "")
											$('#toggle-' + comp_id).hpToggle({checked: localizer.getString("hpsum.oneTouchUpdate.force"), unchecked: localizer.getString("hpsum.oneTouchUpdate.forced")});	
										
										
										$(comp_tableid + ' tbody tr').last().removeClass('hp-selected');
										
										if(currbaseline.components.component[k].is_selectable === false)
											$(comp_tableid + ' tbody tr').last().addClass('hp-disabled');
										  
									}
									
									//enable selection and deselection of row
									$(comp_tableid + " tbody tr").click( function( e ) {
									
										var srcElem;

										//Check if firefox or (chrome and IE)
										if(e.srcElement)
										{
											srcElem = e.srcElement;//Chrome and IE
										}
										else
										{
											srcElem = e.target;//Firefox
										}													
										
										var clickedCellIndex = srcElem.cellIndex;
										if(clickedCellIndex === undefined)
											$(ASSOC_ANALYSIS).attr("disabled", false);

										var data = table.fnGetData( this );
										
										//row is disabled, so only force option can be applied
										//no row selection/deselection supported
										if ( $(this).hasClass('hp-disabled') ) {
											return;	
										}
									
										//toggle row selection	
										$(this).toggleClass('hp-selected');
										
										$(ASSOC_ANALYSIS).attr("disabled", false);
									   
										
									});
								}
							}
						}
					},
					error: function(errorInfo){}
				});
			}
           
			function btnAssocAnalyzeClicked(nodeid) {
			
				showAnalysisSplash();

				//this.analysis = function (item,complist,handlers){
				//var uri = '/Session/'+session.getToken()+'/node/'+item.node_id +'/analysis';
				var tableid = '#hpsum-components-table';
				var currTable = $(tableid).dataTable();
				
				var selectedRows = $(tableid + ' tbody tr');
				var selectedComps = [];
				var componentsList = { 
						hapi: {
								components: {
									component:[]
								}						
						}
					};
					
				for(var tmp=0; tmp < selectedRows.length; tmp++){
					var compData = currTable.fnGetData(selectedRows[tmp].rowIndex-1);
					var bselected = false, bforce = false;
					
					if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
						bselected = true;
					else
						bselected = false;
					
					var filename = compData.component_id;
					if($('#toggle-' + filename)[0]) {
						if($('#toggle-' + filename)[0].checked)
							bforce = true;
						else
							bforce = false;
					}
							
					var item = {
						component_name: compData.file_name,
						selected: bselected,
						force: bforce
					};
					
					componentsList.hapi.components.component.push(item); 
				}
				
				var uri = '/Session/'+session.getToken()+'/node/'+nodeid +'/analysis';			 
				rest.postObject(uri, componentsList,"",{
						node_id: nodeItem.node_id,
						success : function(data) {
							analyzeSuccess(data, this.node_id);
						},
						error : function(errorInfo) {
							analyzeError(errorInfo);
						}
				});
					
		        var progressTimer = setInterval(function () {
					var node_uri = "/Session/" + session.getToken() + "/node/" + nodeid;
					rest.getURI(node_uri + "/getstatus", {
										
						success : function(data) {
							
							if(data.hapi.node_status.node_state === "ANALYSIS")
							{
								
							}
							else if(data.hapi.node_status.node_state === "UAN")
							{
								clearInterval(progressTimer);
				
								//show install review for all the nodes
								populateComponents(data.hapi.node_status.node_id);
				
								closeAnalysisSplash();
				
								//disable analyze button
								$(ASSOC_ANALYSIS).attr("disabled", true);	
							}
							else if(data.hapi.node_status.node_state === "ERROR")
							{
								clearInterval(progressTimer);
								closeAnalysisSplash();
							}
						},
						error : function(errorInfo) {
							
						}
					});
				}, 3000);
			}	
			function getSrcElem(browserType, e){
				var srcElem;
				if(browserType==1){
				srcElem = e.target;//Firefox
				}
				else{
				srcElem = e.srcElement;//Chrome and IE
				}
				return srcElem;
			}
			
			function onComponentDataError(errorInfo){
			}
			
			/**
             * @private
             */

            function reset() {
                $(DESCR).text(localizer.getString('core.loading'));
                $(TYPE).text("");
                $(NONECHECKBOX).attr('checked', false);
                $(USESNMPCHECKBOX).attr('checked', false);
                $(USEAGENTLESSCHECKBOX).attr('checked', false);
                $(USEWEBEMCHECKBOX).attr('checked', false);
                $(DOWNGRADECHKBOXCOMP).attr('checked', false);
                $(REWRITECHKBOXCOMP).attr('checked', false);
                $(FIRMWARECHKBOXCOMP).attr('checked', false);
                $(SOFTWARECHKBOXCOMP).attr('checked', false);
                $(REBOOTOPTION).selectBox('value', 'Never');
                $(DELAYSEC).prop("disabled", true);
				$(DELAYMSG).prop("disabled", true);
				$(REBOOTOPTION).live('change',function(e){
				if($(REBOOTOPTION).val().toLowerCase() == "never"){
					$(DELAYSEC).prop("disabled", true);
					$(DELAYMSG).prop("disabled", true);
					}
					else{
					$(DELAYSEC).prop("disabled", false);
					$(DELAYMSG).prop("disabled", false);
					}
				});
				$(DELAYSEC).val('3600');
                $(DELAYMSG).attr('value', 'Earlier Reboot Message Reboot at user request after deploy ');
                $("#hpsum-osmanagement-options-collapsible").css("display", "none");
            }
			function loadAttributes() {
				
				initialGetattr = null;
				
				var handler = {
						success : function(data) {
						//	populateOtherOptions(data);
						        showInstallationOptions(data)
							initialGetattr = data;
						},
						error : function(errorInfo) {
						}
					};
					
				presenter.otheroption(nodeItem, handler);
			}
			
            /**
             * @public
             */
            this.resume = function () {
            	reset();
				presenter.on("itemChange", onItemChange);
				$(PANELS).hpStackedPanels('resume');
				
            };
            
            this.pause = function () {
				presenter.off("itemChange", onItemChange);
				$('.hpsumInstallables').hpsumInstallables('destroy');
				$(PANELS).hpStackedPanels('pause');
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
                
		// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }
				$(CANCEL).click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });

                $(DEPLOY).live('click', function(ev) {
                    onDeploy.call(this);
                    ev.preventDefault();
                });
				 $(ANALYSIS).live('click', function(ev) {
                    btnAnalyzeClicked.call(this);
                    ev.preventDefault();
                });
				$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });		
				$(ASSOC_NODE_COMP).empty();
				$("#assoc-footer").hide();
				$(".hp-collapsible").hpCollapsible();
				$("#hpsum-assocnodes-collapsible").removeClass('hp-collapsed');
				$("#hpsum-baseline-collapsible").removeClass('hp-collapsed');
				$(DEPLOY).attr("disabled", true);	
				
				router.watch('Node Deploy section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
			
								
                this.resume();
            };
        }

        return NodeDeployView;
    }());
    
    return new NodeDeployView();
});
