// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Notifications',
    'hp/view/FormStateView',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpCollapsible',
    'lib/jquery.selectBox'],
function(presenter,  router, urlFragment, notifications, FormStateView) { "use strict";

    var NodeEditView = (function() {
      
        var OK = '#hpsum-node-edit-ok';
        var PANEL_SELECTOR = '#hpsum-node-edit-panel-selector';
        var PANELS = '#hpsum-node-edit-panels';
        var FORM = '#hpsum-node-edit-form';
        var TITLE = '#hpsum-node-details-title';
        var TYPE ='#hpsum-node-type';
        var NAME = '#hpsum-node-name',
        	CANCEL ='#hpsum-node-edit-close',
        	DESCRIPTION = '#hpsum-node-description',
        	USERNAME = '#hpsum-node-credential-username',
           	PASSWORD = '#hpsum-node-credential-password',
			CURRENT_BASELINE = '#hpsum-node-baseline',
            CURRENT_HOTFIX = '#hpsum-node-addpackage',
			LINUXUSERNAME = '#hpsum-linux-node-credential-username',
			LINUXPASSWORD = '#hpsum-linux-node-credential-password',
			LINUX_ENTER_CRED = '#hpsum-linux-node-cred-details',
			LINUX_CRED_PANEL = '#hpsum-linux-node-edit-credentials',
        	BASELINES = '#hpsum-node-baselines-search',
        	NONECHECKBOX = '.nonecheckbox',
        	USESNMPCHECKBOX ='.useSNMPcheckbox',
			USEAGENTLESSCHECKBOX ='.useAgentlesscheckbox',
			USEWEBEMCHECKBOX ='.useWEBEMcheckbox',
			DOWNGRADECHKBOXCOMP ='.downgradechkbox',
			REWRITECHKBOXCOMP ='.rewritechkbox',
			FIRMWARECHKBOXCOMP ='.firmwarechkbox',
			SOFTWARECHKBOXCOMP ='.softwarechkbox',
			REBOOTOPTION = '#hpsum-reboot-option',
			DELAYSEC= '#hpsum-node-delay-seconds',
			DELAYMSG= '#hpsum-node-reboot-message',
			REBOOT_ACTIVATE = '#hpsum-reboot-to-activate-options',
			COMMON_REBOOT = '#hpsum-common-reboot-options',
			ACTIVATE_SELECTION = '#hpsum-activate-selection',
			NO_REBOOT_REQ = '#hpsum-no-reboot-required',
            HOTFIX = '#hpsum-node-hotfix-search',
        	PARTNER_TYPE ='#hpsum-node-add-partner',
           	PARTNER_CRED_PANEL ='#hpsum-node-add-partner-credentials',
            PARTNER_IP_LABEL = '#hpsum-node-partner-ip',
            PARTNER_IP_VALUE ='#hpsum-node-partner-ip-value',
            PARTNER_ENTER_CRED = '#hpsum-node-partner-cred-details',
            PARTNER_USERNAME = '#hpsum-node-partner-credential-username',
           	PARTNER_PASSWORD = '#hpsum-node-partner-credential-password',
			ADD_ASSOC_NODES = '#hpsum-node-addassocnodes';
        var ROUTE_PREFIX = '/node/edit';
        
        /**
         * Constructor
         */
        function NodeEditView() {
          
            var formStateView = new FormStateView();
            var updateInProgress = false;
			var useSudoCredentials = false;
            var searchResults = [];
            var nodeItem = null;
	    var checkedVal = '';
            var currentbaseline = "";
            var currenthotfixbaseline = "";
            var baselines = "";
            var hotfixes = "";
            var newbaseline = null;
            var newhotfix = null;
            var partnerUsername ='';
            var partnerPassword ='';
            var partnerType ='';
            function onItemChange(item) {
            	item = item.hapi;
                if (item) {
                	nodeItem =item;
                    $(TITLE).text(item.name);
                    $(NAME).text(item.name);
                    $(DESCRIPTION).val(item.description);

					
                    if(nodeItem.hasOwnProperty('activate_sfw')){
					    $('#hpsum-reboot-options-collapsible').removeClass('hp-collapsed');
						$(COMMON_REBOOT).hide();
						$(REBOOT_ACTIVATE).show();
						if(!nodeItem.is_powered_on) {
							$(ACTIVATE_SELECTION).closest("li").hide();
							$(NO_REBOOT_REQ).show();
						} else {
							$(ACTIVATE_SELECTION).closest("li").show();
							$(NO_REBOOT_REQ).hide();
						}
						if(nodeItem.activate_sfw) {
							$(ACTIVATE_SELECTION).val('YES');
						} else {
							$(ACTIVATE_SELECTION).val('NO');
						}
					} else {
						if(nodeItem.type.match(/windows|linux|hpux|vmware/i)){
						$(COMMON_REBOOT).show();
						$('#hpsum-reboot-options-collapsible').css("display","block");
						$(REBOOT_ACTIVATE).hide();
						}
						else{
							$('#hpsum-reboot-options-collapsible').css("display","none");
						}
					}    
                    showInstallationOptions(item);
					if(nodeItem.type.match(/Windows|Linux/i)) {
					   $('#hpsum-osmanagement-options-collapsible').css("display","block");
					   $('#hpsum-node-deploy-osmanagement-Options').css("display","block");
					}
					else {
						$('#hpsum-osmanagement-options-collapsible').css("display","none");
						$('#hpsum-node-deploy-osmanagement-Options').css("display","none");
					}
					if(nodeItem.type.match(/integrityilo|pdu|virtual_connect/i)) {
					    $('#hpsum-installation-options-collapsible').css("display","none");
					    $("#hpsum-force-options-collapsible").css("display","none");

					}
					else
					{	
						$('#hpsum-force-options-collapsible').css("display","block");
						$('#hpsum-installation-options-collapsible').css("display","block");
					}
					if(nodeItem.type.match(/pdu|virtual_connect/i))
					    {
					    	$('#hpsum-node-reboot-options').css("display","none");
					    }
					    else{
					    	$('#hpsum-node-reboot-options').css("display","block");
					    }
					if(nodeItem.type.match(/virtual_connect/i)) {
						$('#hpsum-vc-options-collapsible').css("display","block");
						$('#hpsum-node-deploy-vc-Options').css("display","block");	
						$('#hpsum-vc-options-collapsible').hpCollapsible('expand');					
					}
					else
					{
						$('#hpsum-vc-options-collapsible').css("display","none");
						$('#hpsum-node-deploy-vc-Options').css("display","none");
					}
					
		            $('select option').filter(function() {
			             if(new RegExp(this.value, 'ig').test(item.type.toLowerCase()))
		    		            $(this).attr('selected', true);
		    		            showPartnerOptions();
		                  });
                    if(item.baselines){
                        for (var i=0; i<item.baselines.length; i++ ){
                            var baseline = presenter.getBaselineDetailsforId(item.baselines[i]);
                            if(baseline){
                                if(baseline.name.match(/^Additional/i)){
                                    currenthotfixbaseline = baseline; 
                                    $(CURRENT_HOTFIX).text(baseline.name);
                                    $(HOTFIX).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
                                }else{
                                    currentbaseline = baseline;
                                    $(CURRENT_BASELINE).text(baseline.name);
                                    $(BASELINES).hpSearchCombo('set', {id: baseline.id, name: baseline.name});
                                }
                            }
                        }
                     } else {
                         $(CURRENT_BASELINE).text('');
                         $(CURRENT_HOTFIX).text('');
                     }
                } else {
                    $(TITLE).text('');
                }

                formStateView.reset();
            }
            
            function onItemError(errorMessage) {
                formStateView.noItem(errorMessage);
            }
            
            function showInstallationOptions(item){
            	//send getattributes for this node
            	presenter.otheroption(item, {success:function(data){
            						if(data && data.hasOwnProperty("hapi")){
				
				
				if(data.hapi.hasOwnProperty("reboot_options") && data.hapi.reboot_options){
						 
						$('#hpsum-reboot-option option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.reboot_options.action))
		    		            $(this).attr('selected', true);
		                  });
						if( -1 < data.hapi.reboot_options.delay){
							$(DELAYSEC).val(data.hapi.reboot_options.delay);				
						}
						else{
							$(DELAYSEC).val('3600');				
						}
						
						$(DELAYMSG).attr('value', data.hapi.reboot_options.message);				
					}
					if(data.hapi.hasOwnProperty("os_management_options") && data.hapi.os_management_options){
						$(USESNMPCHECKBOX).attr('checked', false);							
						$(USEAGENTLESSCHECKBOX).attr('checked', false);							
						$(USEWEBEMCHECKBOX).attr('checked', false);
						$(NONECHECKBOX).attr('checked', false);
						if( data.hapi.os_management_options.length > 0){
							if(data.hapi.os_management_options[0].match(/NONE/i))
								$(NONECHECKBOX).attr('checked', true);
							else{
								if (data.hapi.os_management_options[0].match(/AMS/i))
									$(USEAGENTLESSCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/SNMP/i))
									$(USESNMPCHECKBOX).attr('checked', true);
								if (data.hapi.os_management_options[0].match(/WBEM/i))
									$(USEWEBEMCHECKBOX).attr('checked', true);
									
							}
						}
					}
					if(data.hapi.hasOwnProperty("installation_option") && data.hapi.installation_option){
						$(DOWNGRADECHKBOXCOMP).attr('checked', data.hapi.installation_option.downgrade);							
						$(REWRITECHKBOXCOMP).attr('checked', data.hapi.installation_option.rewrite);
						$(FIRMWARECHKBOXCOMP).attr('checked', data.hapi.installation_option.forcefirmware);							
						$(SOFTWARECHKBOXCOMP).attr('checked', data.hapi.installation_option.forcesoftware);					
										
					}
					if(data.hapi.hasOwnProperty("vc_activation_options") && data.hapi.vc_activation_options){
						$('#hpsum-Enet-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.eth_activation_order))
		    		            $(this).attr('selected', true);
		                  });
		                 $('#hpsum-fc-order option').filter(function() {
			             if(new RegExp(this.value, 'ig').test( data.hapi.vc_activation_options.fc_activation_order))
		    		            $(this).attr('selected', true);
		                  });
						$('#hpsum-Enet-delay').val(data.hapi.vc_activation_options.eth_activation_delay);
						$('#hpsum-FC-delay').val(data.hapi.vc_activation_options.fc_activation_delay);
					}
					if(data.hapi.hasOwnProperty("auto_add_assoc_nodes") && data.hapi.auto_add_assoc_nodes)
						$(ADD_ASSOC_NODES).attr('checked', true);
					else
						$(ADD_ASSOC_NODES).attr('checked', false);				
					if(data.hapi.hasOwnProperty("node_skip"))
						if(data.hapi.node_skip)
							$("input[name='hpsum-node-edit-active']")[0].checked = true;
					else
							$("input[name='hpsum-node-edit-active']")[1].checked = true;
				}
				},
            	error:function(){
            		
            	}
            		
            	});
            	
            	
            }

            function onItemUpdateSuccess(item) {
                updateInProgress = false;
                formStateView.reset();
                $(CANCEL).trigger('click');
            }
            function showPartnerOptions() {
				if ($(TYPE).val().toLowerCase().match(/Windows/i) ||
					$(TYPE).val().toLowerCase().match(/Linux/i) ||
					$(TYPE).val().toLowerCase().match(/HPUX/i))
					$('#hpsum-node-edit-alreadyExist').show();
				else
					$('#hpsum-node-edit-alreadyExist').hide();
				if($(TYPE).val().toLowerCase().match(/Linux/i)){
					$(LINUX_CRED_PANEL).css({"display":""});
					$(LINUX_ENTER_CRED).hide();
					//$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
					//linuxCredentialOptions("two");
				}
				else
					$(LINUX_CRED_PANEL).css({"display":"none"});
					
				if($(TYPE).val().toLowerCase().match(/sas_switch/i) || 
            		$(TYPE).val().toLowerCase().match(/virtual_connect/i) ||
            		$(TYPE).val().toLowerCase().match(/ipdu/i)) {
            			if($(TYPE).val().toLowerCase().match(/ipdu/i)){
            				$(PARTNER_TYPE).html("Partner iPDU Credentials");
            				$(PARTNER_IP_LABEL).html("Partner iPDU IP/DNS");
            				partnerType = 'ipdu';
            				
            			}
            			else{
            				$(PARTNER_TYPE).html("Associated Onboard Administrator Credentials");
            				$(PARTNER_IP_LABEL).html("Associated Onboard Administrator IP/DNS");
            				partnerType = 'oa';
            			}
            				
            			$(PARTNER_CRED_PANEL).css({"display":""});;
            			$('input[name="hpsum-node-partner-credential"]').click(partnerCredentialsOptions);
            			partnerCredentialsOptions("two");
            			
            		
            		}
            	else{
            		$(PARTNER_CRED_PANEL).css({"display":"none"});
            		partnerType ='';
            	}
				
				if($(TYPE).val().toLowerCase().match(/virtual_connect/i) ||
            			$(TYPE).val().toLowerCase().match(/sas_switch/i) ||
            			$(TYPE).val().toLowerCase().match(/oa/i) ||
						$(TYPE).val().toLowerCase().match(/fc_switch/i) ||
						$(TYPE).val().toLowerCase().match(/ilo/i)) {
            				$(ADD_ASSOC_NODES).show();
							$('#hpsum-node-addassoc-description').show();
				}
            	else {	
            			$(ADD_ASSOC_NODES).hide();
						$('#hpsum-node-addassoc-description').hide();
				}
           }
		   function linuxCredentialOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
				if(checkedVal === value)
				{
					checkedVal = '';
					useSudoCredentials =false;
					if(value ==="one")
						$('#hpsum-linux-node-sudo').attr('checked',false);
					if(value == "two"){
						$(LINUX_ENTER_CRED).hide();
						$('#hpsum-linux-node-root').attr('checked',false);
					}
				}
				else{
					checkedVal = $('input[name="hpsum-linux-node-credential"]:checked').val();
					if(value == "one"){
						$(LINUX_ENTER_CRED).hide();
						useSudoCredentials =true;
					}
					if(value == "two"){
						$(LINUX_ENTER_CRED).show();
						useSudoCredentials = false;
					}
				}
           }
		   
           function partnerCredentialsOptions(value)
           {
           	    if(value.target)
            		value = value.target.value;
            	if(value == "one"){
            		$(PARTNER_ENTER_CRED).hide();
            		partnerUsername= $(USERNAME).val();
            		partnerPassword= $(PASSWORD).val();
            		//useCurrentCredentials =true;
            	}
            	if(value == "two"){
            		$(PARTNER_ENTER_CRED).show();
            	}
           	
           }
           

            /**
             * @private
             */
            function onItemUpdateError(errorMessage) {
                notifications.show(errorMessage);
                updateInProgress = false;
            }
            
            function onUpdateItem() {
                if (! updateInProgress) {
                    updateInProgress = true;
				var auto_add_assoc_nodes;
				var nodeType = $(TYPE).val().toLowerCase();
				if(nodeType.match(/virtual_connect|sas_switch|oa|fc_switch|ilo/i)){
					if($(ADD_ASSOC_NODES).is(':checked'))
						auto_add_assoc_nodes = true;
					else
						auto_add_assoc_nodes = false;
				}
				var node_skip = $("input[name='hpsum-node-edit-active']:checked").val();
				if (node_skip == "one")
					node_skip = true;
				else
					node_skip = false;
                    var editOptions =  {
                    	hapi: {
                    	username : $(USERNAME).val(),
                    	password : $(PASSWORD).val(),
						su_username : $(LINUXUSERNAME).val(),
						su_password : $(LINUXPASSWORD).val(),
						use_sudo : useSudoCredentials,
						auto_add_assoc_nodes : auto_add_assoc_nodes,
						node_skip : node_skip
                    	}
                    };

                    if( newbaseline || newhotfix )  //something got changed
                    {
                        var baselinestosend = [];
                        if(newbaseline){
                            if(newbaseline.id != 'none') {
                                baselinestosend.push(newbaseline.id);
                            }
                        } else {
                                baselinestosend.push(currentbaseline.id); // This was not set so we will go back to the old baseline
                        }
                        if(newhotfix) { 
                            if(newhotfix.id != 'none') {
                                baselinestosend.push(newhotfix.id);
                            }
                        }
                        else{
                            baselinestosend.push(currenthotfixbaseline.id); // This was not set so we will go back to the old hotfix baseline
                        }
                        if(baselinestosend.length > 0 ){
                            editOptions.hapi.baselines = {remove_existing_baselines:'true'};
                            editOptions.hapi.baselines.baseline = baselinestosend;
                        } else {
                            if(!nodeItem.node_state.match(/idle/i)) {
                                //If the node is not idle we need to have a valid baseline
                                $("<div></div>").dialog( {
                                buttons: { "Ok": function () {
                                    $(this).dialog("close");
                                    }
                                },
                                close: function (event, ui) { $(this).remove(); },
                                resizable: false,
                                title: "Edit",
                                modal: true
                                }).text("Please select a Baseline or Additional Package");
                                updateInProgress = false;
                                return;
                            }
                        }
                    } 
                    
                    if(nodeItem.type.match(/virtual_connect|ipdu|sas_switch/i)){
                    	editOptions.hapi.associated_node ={};
                    	editOptions.hapi.associated_node.ip = $(PARTNER_IP_VALUE).val();
            			editOptions.hapi.associated_node.type = partnerType;
            			if(partnerUsername == '' ){
            				partnerUsername= $(PARTNER_USERNAME).val();
            				partnerPassword= $(PARTNER_PASSWORD).val();
            			}
            			editOptions.hapi.associated_node.username = partnerUsername;            		
            			editOptions.hapi.associated_node.password = partnerPassword;
                    	
                    }
                    
                    if(!nodeItem.type.match(/integrityilo|virtual_connect|ipdu/i)){
                   		editOptions.hapi.installation_option ={};
                    	editOptions.hapi.installation_option.downgrade = $(DOWNGRADECHKBOXCOMP).is(':checked');	
						editOptions.hapi.installation_option.rewrite = $(REWRITECHKBOXCOMP).is(':checked');	
						editOptions.hapi.installation_option.forcefirmware = $(FIRMWARECHKBOXCOMP).is(':checked');
						editOptions.hapi.installation_option.forcesoftware = $(SOFTWARECHKBOXCOMP).is(':checked');
					}
					/*if($(SOFTWARECHKBOXCOMP).is(':checked') || $(FIRMWARECHKBOXCOMP).is(':checked'))
					{
						editOptions.hapi.installation_option.force = true;
					}*/
					if((nodeItem.hasOwnProperty('activate_sfw')) || (nodeItem.type.match(/windows|linux|vmware|hpux/i))){
						editOptions.hapi.reboot_options ={};	
						editOptions.hapi.reboot_options.action = $(REBOOTOPTION).val();
						editOptions.hapi.reboot_options.delay = $(DELAYSEC).val();				
						editOptions.hapi.reboot_options.message = $(DELAYMSG).val();
					}
					if(nodeItem.type.match(/windows|linux|hpux/i)){
						editOptions.hapi.os_management_options='';
						if($(NONECHECKBOX).attr('checked'))
							editOptions.hapi.os_management_options = "None";
						else {
							if($(USESNMPCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "SNMP|";						
							if($(USEAGENTLESSCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "AMS|";													
							if($(USEWEBEMCHECKBOX).attr('checked'))
								editOptions.hapi.os_management_options += "WBEM|";
						}
					}
					if(nodeItem.type.match(/virtual_connect/i)) {
						editOptions.hapi.vc_activation_options ={};			
			            editOptions.hapi.vc_activation_options.eth_activation_order = $('#hpsum-Enet-order').val();
		    		    editOptions.hapi.vc_activation_options.fc_activation_order = $('#hpsum-fc-order').val();     
						editOptions.hapi.vc_activation_options.eth_activation_delay = $('#hpsum-Enet-delay').val();
						editOptions.hapi.vc_activation_options.fc_activation_delay= $('#hpsum-FC-delay').val();	
					
					}
					var tmp = $(ACTIVATE_SELECTION).val();
					if( tmp == 'NO') {
						editOptions.hapi.activate_sfw = false;
					} else {
						editOptions.hapi.activate_sfw = true;
					}
				
            
                    presenter.setattribute(nodeItem, editOptions, {
                        success : onItemUpdateSuccess,
                        error : onItemUpdateError
                    });
                }
            }
            
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
            
            this.resume = function () {
            	presenter.on('itemChange', onItemChange);
				$(USERNAME).val('');
				$(PASSWORD).val('');
            	$(TYPE).bind('change', showPartnerOptions);
               // presenter.on('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('resume');
                presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
            };
            
            this.pause = function () {
            	presenter.off('itemChange', onItemChange);
                $(BASELINES).hpSearchCombo('set', {id:'', name: ''});
                $(HOTFIX).hpSearchCombo('set', {id:'', name: ''});
              	//presenter.off('searchSuggestionChange', baselinesAvailable);
                $(PANELS).hpStackedPanels('pause');
            };
          
          	function baselinesAvailable(data){
    			//data = {count: data.count, members: data};
            	//$(BASELINES).hpSearchCombo({getResults: presenter.getResults});
            }

            function getBaseline(string, handlers){
                var results=[];
                    if (string && string.length > 0) {
                         results =
                            $.grep(baselines, function(option, index) {
                                return (option.name.match(
                                         new RegExp(string, 'i')));
                          });   
                     }
                    handlers.success({count: results.length, members: results});
            }
            function getHotfixes(string, handlers){
                    var results=[];
                    if (string && string.length > 0) {
                         results =
                            $.grep(hotfixes, function(option, index) {
                                return (option.name.match(
                                         new RegExp(string, 'i')));
                          });   
                     }
                    handlers.success({count: results.length, members: results});
            }

            function getBaselinesSuccess(searchResults)
            {
                    baselines = $.grep(searchResults, function (option, index ) {
                        return !(option.name.match(new RegExp('^Additional', 'i')));
                    });
                    hotfixes = $.grep(searchResults, function (option, index) {
                        return (option.name.match(new RegExp('^Additional', 'i')));
                    });
                
            }
            
            function getBaselinesError(msg)
            {
                
            }
          
          
            /**
             * @public
             */
            this.init = function () {
              
				var resource = router.location().split('/');
                	resource = resource[1];
              	$('a[data-panel-id]').each(function(index) {
                		var currentLink = $(this).attr('href');
                		if(currentLink  == undefined)
                			return;
                		var current = currentLink.split('/');
                		current[1] = resource;
                		currentLink =current.join('/');
                		$(this).attr('href',currentLink);
  					});
  					ROUTE_PREFIX = '/'+ resource +'/edit';
               		$('#hpsum-node-edit-close').click(function () {
                    router.go(urlFragment.replaceView(router.location(), 'show'));
                });
                
                   $(PANELS).hpStackedPanels({
                    	panelSelector : PANEL_SELECTOR
                	});
                
                formStateView.init({form: FORM,
                    routePattern: ROUTE_PREFIX + '.*',
                    autoTrack: true});

                $(BASELINES).hpSearchCombo({getResults: getBaseline});

                $(HOTFIX).hpSearchCombo({getResults: getHotfixes});

                $(BASELINES).change(function (ev, value) {
                    var item = presenter.getBaselineDetailsforId(value);
                    if(item){
                        newbaseline = item;
                        $(CURRENT_BASELINE).text(newbaseline.name);
                    } else {
                        newbaseline = {id:'none'};
                        $(CURRENT_BASELINE).text('');
                    }
                });

                $(HOTFIX).change(function (ev, value) {
                    var item = presenter.getBaselineDetailsforId(value);
                    if(item){
                        newhotfix = item;
                        $(CURRENT_HOTFIX).text(newhotfix.name);
                    } else {
                        newhotfix = {id:'none'};
                        $(CURRENT_HOTFIX).text('');
                    }
                });

              	presenter.getAllBaselines({
           					success:getBaselinesSuccess,
           					error: getBaselinesError
           			});
                
                $(OK).on('click', function(ev) {
                    onUpdateItem();
                    ev.preventDefault();
                });
                $('.hp-collapsible').hpCollapsible();
				$('input[name="hpsum-linux-node-credential"]').click(linuxCredentialOptions);
                router.watch('node edit section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                
                this.resume();
            };
        }

        return new NodeEditView();
    }());
    
    return NodeEditView;
});
