// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
        'hp/core/UrlFragment', 
        'hp/core/Router', 
        'hp/core/Localizer', 
        'hp/core/LinkTargetBuilder', 
        'text!hpsumpages/graphics/enclosure.html', 
        'text!hpPages/core/no_details.html', 
        'jquery', 
        'hp/lib/jquery.hpGridPanels', 
        'hp/lib/jquery.hpEllipsis', 
        'hp/lib/jquery.hpStatus', 
        'hp/lib/jquery.hpCollapsible', 
        'hp/lib/jquery.hpUtilizationMeter'], 
function(presenter, urlFragment, router, localizer, linkTargetBuilder, enclosureGraphicHtml, noneHtml) {"use strict";

        var SD2ShowOverviewView = ( function() {

            var ROOT = '#hpsum-sd2-show-overview',
            PANELS = '.hp-grid-panels',
            BASELINE = '#hpsum-sd2-bundle', 
            FIRMWARE_VERSION = '#hpsum-sd2-fwversion', 
            CPLX_NAME = '#hpsum-sd2-cplx-name', 
            DEVICES = '#hpsum-sd2-devices', 
            SERIAL_NO = '#hpsum-sd2-serialno', 
            DESCRIPTION = '#hpsum-sd2-description',
            MODEL = '#hpsum-sd2-model',
            COMPLEX_FW = 0,
            PARTITION_FW = 2,
            INSTALLED_FW = 4,           
            FW_MISMATCH = 1,
            INSTALL_LOGS = '#hpsum-sd2-install-log';

            /**
             * Constructor
             */
            function SD2ShowOverviewView() {

                var noItem;

                function onItemChange(item) {
                    item = item.hapi;
                    noItem.remove();
                    item.type = item.type.toLowerCase();
                    if (!router.location().match(item.type))
                        router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
                        
                    $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                    $(INSTALL_LOGS).hide();
                    
                    if (item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)) {
                        $('.hp-grid-panels').css({
                            "display" : "none"
                        });
                    } else {
                        $('.hp-grid-panels').css({
                            "display" : ""
                        });
                        $('.hp-grid-panels').hpGridPanels('reset');
                        $(DESCRIPTION).text(item.description);
                        if(item.hasOwnProperty('is_dh_oa')){
                        	if(item.is_dh_oa){
                        		$(MODEL).text('HP Integrity DragonHawk OA');
                        	} else {
                        		$(MODEL).text('HP Integrity Superdome 2');
                        	}
                        } else {
                        	$(MODEL).text('HP Integrity SD2/ DH OA');
                        }

                        if (item.hasOwnProperty('firmware_version')) {
                            if (item.firmware_version == "*") {
                                $(FIRMWARE_VERSION).html('<div title=\"'+ localizer.getString('hpsum.sd2oa.mismatch') +'\" class=\"hp-status hp-status-warning\"></div>' + localizer.getString('hpsum.sd2oa.mismatch'));
                            } else if (item.firmware_mismatch) {
                                $(FIRMWARE_VERSION).html('<div title=\"'+ localizer.getString('hpsum.sd2oa.mismatch') +'\" class=\"hp-status hp-status-warning\"></div>' + item.firmware_version);
                            } else {
                                $(FIRMWARE_VERSION).text(item.firmware_version);
                            }
                            $(CPLX_NAME).text(item.complex_name);
                            $(SERIAL_NO).text(item.serial_number);

                            var partitionSection;
                            if (item.npar_list.length > 0) {
                                partitionSection = $('<div></div>').addClass('hp-collapsible sd2-section-title').html('<label>'+ localizer.getString('hpsum.sd2oa.partitions') +'</label>');
                                var partitionDiv = $('<div></div>');

                                var device_table = $('<table></table>');
                                var hdr_row = $('<thead></thead>');
                                hdr_row.append('<tr><td><div class=\"hp-status"></div></td><td>'+localizer.getString('hpsum.sd2oa.number')+
                                '</td><td>'+localizer.getString('hpsum.common.name')+'</td><td>'+localizer.getString('hpsum.common.state')+
                                '</td><td>'+localizer.getString('hpsum.common.model')+'</td><td>'+localizer.getString('hpsum.sd2oa.installedFW')+
                                '</td><td>'+localizer.getString('hpsum.common.server')+'</td></tr>');
                                device_table.append(hdr_row);

                                for (var i = 0; i < item.npar_list.length; i++) {
                                    var device = item.npar_list[i];
                                    var parState, installedFW;
                                    if (device.Status === 0) {
                                        parState = 'Active';
                                    } else {
                                        parState = 'Inactive';
                                    }

                                    var hasMismatch = false;
                                    for (var j = 0; j < device.FWVersionEx.length; j++) {
                                        var fw = device.FWVersionEx[j];
                                        if (fw.FWVersionType == INSTALLED_FW) {
                                            installedFW = fw.FWVersion;
                                        }
                                        if (fw.FWMismatch == FW_MISMATCH) {
                                            hasMismatch = true;
                                        }
                                    }

                                    var parstatus = '';
                                    if (hasMismatch) {
                                        parstatus = '<div title=\"Mismatch\" class=\"hp-status hp-status-warning\"></div>';
                                    } else {
                                        parstatus = '<div class=\"hp-status hp-status-ok\"></div>';
                                    }

                                    var dev_row = $('<tr></tr>').html('<td>' + parstatus + '</td><td>' + device.Number + '</td><td>' + device.Name + '</td><td>' + parState + '</td><td>' + device.BladeName + '</td><td>' + installedFW + '</td>');
                                    device_table.append(dev_row);

                                    var hasDetails = false;
                                    var details_row = $('<tr></tr>').addClass('hp-row-details-row');
                                    var details_cell = $('<td colspan=\"7\"></td>').addClass('hp-row-details-cell');

                                    if (device.VParArray.VPar.length > 0 || device.Blades.Blade.length > 0) {
                                        hasDetails = true;
                                        //Add the details row for the partition
                                        if (device.VParArray.VPar.length > 0) {
                                            var vparSection = $('<div></div>').addClass('hp-collapsible').html('<label>'+localizer.getString('hpsum.sd2oa.vpars')+'</label>');
                                            var vparDiv = $('<div></div>');
                                            var vparTable = $('<table></table>');
                                            var vpar_hdr = $('<thead></thead>');
                                            vpar_hdr.append('<tr><td>'+localizer.getString('hpsum.sd2oa.number')+'</td><td>'+localizer.getString('hpsum.common.name')+'</td><td>'+localizer.getString('hpsum.common.server')+'</td></tr>');
                                            vparTable.append(vpar_hdr);

                                            for (var j = 0; j < device.VParArray.VPar.length; j++) {
                                                var vPar = device.VParArray.VPar[j];
                                                var vparRow = $('<tr></tr>').html('<td>' + vPar.Number + '</td><td>' + vPar.Name + '</td>');
                                                vparTable.append(vparRow);
                                            }

                                            vparDiv.append(vparTable);
                                            vparSection.append(vparDiv);
                                            details_cell.append(vparSection);
                                        }

                                        if (device.Blades.Blade.length > 0) {
                                            var bladeSection = $('<div></div>').addClass('hp-collapsible').html('<label>'+localizer.getString('hpsum.sd2oa.blades')+'</label>');
                                            var bladeDiv = $('<div></div>');
                                            var bladeTable = $('<table></table>');
                                            var blade_hdr = $('<thead></thead>');
                                            blade_hdr.append('<tr><td><div class=\"hp-status"></div></td><td>'+localizer.getString('hpsum.common.enclosure')+
                                            				'</td><td>'+localizer.getString('hpsum.sd2oa.bay')+'</td><td>'+localizer.getString('hpsum.common.model')+'</td><td>'+
                                            				localizer.getString('hpsum.sd2oa.cplxFW')+'</td><td>'+localizer.getString('hpsum.sd2oa.parFW')+'</td></tr>');
                                            bladeTable.append(blade_hdr);

                                            for (var j = 0; j < device.Blades.Blade.length; j++) {
                                                var blade = device.Blades.Blade[j];
                                                var complexFw, partitionFW;

                                                var hasMismatch = false;
                                                for (var k = 0; k < blade.FWVersionEx.length; k++) {
                                                    var fw = blade.FWVersionEx[k];

                                                    if (fw.FWVersionType == COMPLEX_FW) {
                                                        complexFw = fw.FWVersion;
                                                    } else if (fw.FWVersionType == PARTITION_FW) {
                                                        partitionFW = fw.FWVersion;
                                                    }

                                                    if (fw.FWMismatch == FW_MISMATCH) {
                                                        hasMismatch = true;
                                                    }
                                                }

                                                var bladeStatus = '';
                                                if (hasMismatch) {
                                                    bladeStatus = '<div title=\"Mismatch\" class=\"hp-status hp-status-warning\"></div>';
                                                } else {
                                                    bladeStatus = '<div class=\"hp-status hp-status-ok\"></div>';
                                                }

                                                var bladeRow = $('<tr></tr>').html('<td>' + bladeStatus + '</td><td>' + blade.Enclosure + '</td><td>' + blade.Bay + '</td><td>' + blade.Name + '</td><td>' + complexFw + '</td><td>' + partitionFW + '</td>');
                                                bladeTable.append(bladeRow);
                                            }

                                            bladeDiv.append(bladeTable);
                                            bladeSection.append(bladeDiv);
                                            details_cell.append(bladeSection);
                                        }
                                    }

                                    details_row.append(details_cell);
                                    device_table.append(details_row);
                                }

                                partitionDiv.append(device_table);
                                partitionSection.append(partitionDiv);
                            }

                            var ubSection;
                            if (item.unassigned_blade_list.length > 0) {

                                ubSection = $('<div></div>').addClass('hp-collapsible sd2-section-title').html('<label>Unassigned Blades</label>');
                                var ubDiv = $('<div></div>');
                                var ubTable = $('<table></table>');
                                var hdr = $('<thead></thead>');
                                hdr.append('<tr><td><div class=\"hp-status"></div></td><td>'+localizer.getString('hpsum.common.enclosure')+
                                            '</td><td>'+localizer.getString('hpsum.sd2oa.bay')+'</td><td>'+localizer.getString('hpsum.common.model')+'</td><td>'+
                                            localizer.getString('hpsum.sd2oa.cplxFW')+'</td><td>'+localizer.getString('hpsum.sd2oa.parFW')+'</td></tr>');
                                ubTable.append(hdr);

                                for (var i = 0; i < item.unassigned_blade_list.length; i++) {
                                    var device = item.unassigned_blade_list[i];
                                    var complexFw, partitionFW;

                                    var hasMismatch = false;
                                    for (var k = 0; k < device.FWVersionEx.length; k++) {
                                        var fw = device.FWVersionEx[k];

                                        if (fw.FWVersionType == COMPLEX_FW) {
                                            complexFw = fw.FWVersion;
                                        } else if (fw.FWVersionType == PARTITION_FW) {
                                            partitionFW = fw.FWVersion;
                                        }

                                        if (fw.FWMismatch == FW_MISMATCH) {
                                            hasMismatch = true;
                                        }
                                    }

                                    if (hasMismatch) {
                                        bladeStatus = '<div title=\"Mismatch\" class=\"hp-status hp-status-warning\"></div>';
                                    } else {
                                        bladeStatus = '<div class=\"hp-status hp-status-ok\"></div>';
                                    }

                                    var dev_row = $('<tr></tr>').html('<td>' + bladeStatus + '</td><td>' + device.Enclosure + '</td><td>' + device.Bay + '</td><td>' + device.Name + '</td><td>' + complexFw + '</td><td>' + partitionFW + '</td>');
                                    ubTable.append(dev_row);
                                }

                                ubDiv.append(ubTable);
                                ubSection.append(ubDiv);
                            }

                            $(DEVICES).html('');
                            if (item.npar_list.length > 0) {
                                $(DEVICES).append(partitionSection);
                            }
                            if (item.unassigned_blade_list.length > 0) {
                                $(DEVICES).append(ubSection);
                            }
                            $(DEVICES + ' .hp-collapsible').hpCollapsible();
                            $(DEVICES + ' .sd2-section-title').removeClass('hp-collapsed');
                        } else {
                            $(FIRMWARE_VERSION).text('');
                            $(CPLX_NAME).text('');
                            $(SERIAL_NO).text('');
                            $(DEVICES).html('');
                        }

                        var fwBaseline = presenter.getFWBaseline(item.baselines)
                        if (fwBaseline) {
                            var baseline_url = '#/baseline/show/r' + fwBaseline.uri + '/getBaselineData';
                            name = fwBaseline.name;
                            $(BASELINE).html('<a href="' + baseline_url + '">' + name + '</a>');
                        } else
                            $(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));
                            
                        if(item.node_state.match(/installdone/i)) {
                            $(INSTALL_LOGS).show();
                        }
                    }
                    $(PANELS).hpGridPanels('reset');
                    $(ROOT).removeClass('hp-show-changing');
                    $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
                }

                function onItemError(error) {
                    $(ROOT).append(noItem);
                }

                function onAssociationsError(error) {
                    //console.log(error);
                }

                function onSelectionChange(selection) {
                    urlFragment.replaceHrefUris(ROOT, selection.uris);
                    if ($(ROOT).hasClass('hp-show-init')) {
                        $(ROOT).removeClass('hp-show-init');
                    } else {
                        $(ROOT).addClass('hp-show-changing');
                        $('#tour-server-bundle-item').addClass('hp-show-changing');
                    }
                }

                /**
                 * @public
                 */
                this.resume = function() {
                    $(PANELS).hpGridPanels('reset');
                    presenter.on("selectionChange", onSelectionChange);
                    presenter.on("itemError", onItemError);
                    presenter.on("itemChange", onItemChange);
                };

                this.pause = function() {
                    presenter.off("selectionChange", onSelectionChange);
                    presenter.off("itemChange", onItemChange);
                    presenter.off("itemError", onItemError);
                };

                this.init = function() {
                    if (!presenter.initDone)
                        presenter.init();

                    noItem = $(noneHtml);
                    $(PANELS).hpGridPanels();
                    $(DESCRIPTION).hpEllipsis();
                    this.resume();
                };
            }

            return new SD2ShowOverviewView();
        }());

    return SD2ShowOverviewView;
});
