// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/EventDispatcher',
        'hp/core/Localizer',
        'fs/services/settings/ApplianceUpdateService',
        'fs/model/settings/ApplianceUpgradeResource'],
function(EventDispatcher, localizer, service, resource) {"use strict";

    var ApplianceUpdatePresenter = ( function() {
        function ApplianceUpdatePresenter() {
            var dispatcher = new EventDispatcher();

            var estimatedTimeFlag = true;
            //Time interval to refresh the upgrade estimated time
            var estimatedTimeInterval = 60000;
            var estimatedTimeValue = 0;

            this.getFileName = function(){
                return resource.getFileName();
              };

            this.setFileName = function(data){
                resource.setFileName(data);
              };

            this.getEstimatedUpgradeTime = function(){
                  return resource.getEstimatedUpgradeTime();
            };

            this.setEstimatedUpgradeTime = function(data){
                  resource.setEstimatedUpgradeTime(data);
            };

            this.currentStatus = function() {
                service.currentStatus({
                    success : function(data) {
                        dispatcher.fire('upgradeStatusSuccess', data);
                    },
                    error : function(errorInfo) {
                        dispatcher.fire('upgradeStatusError', errorInfo);
                    }
                });
            };

            this.estTimeFlag = function() {
                estimatedTimeFlag = true;
            };

            this.estimatedTime = function() {
                // At first call, it will get the value from resource
                // This value is stored in resource at the end of preupgrade validation
                if(estimatedTimeFlag)
                {
                    estimatedTimeFlag = false;
                    var value = resource.getEstimatedUpgradeTime();
                    estimatedTimeValue = (value)*estimatedTimeInterval;
                    dispatcher.fire('estimatedTime', value);
                }
                else
                {
                    //For all subsequent calls, it will just decrease one minute and show to UI
                    estimatedTimeValue = estimatedTimeValue - estimatedTimeInterval;
                    if(estimatedTimeValue >= estimatedTimeInterval)
                    {
                      dispatcher.fire('estimatedTime', estimatedTimeValue/estimatedTimeInterval);
                    }
                }
            };

            this.apply = function(fileName){
                service.apply(fileName, {
                    success : function(data){
                        // The controller does not return data
                        // It might return a TaskResource in the future.
                        dispatcher.fire('applySuccess', data);
                    },
                    error : function(errorInfo){
                        dispatcher.fire('applyError', errorInfo);
                    }
                });
            };

            this.releaseNotes = function(fileName, docType, handlers) {
                service.releaseNotes(fileName, docType, handlers);
            };

            this.removeFile = function() {
                service.removeFile({
                    success : function() {
                        resource.clear();
                        dispatcher.fire('deleteSuccess');
                    },
                    error : function(errorInfo) {
                        dispatcher.fire('deleteError', errorInfo);
                    }
                });
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            this.clear = function() {
                resource.clear();
            };

            this.setRebootRequired = function(value) {
                resource.setRebootRequired(value);
            };

            this.getRebootRequired = function() {
                return resource.getRebootRequired();
            };

            this.init = function() {
                resource.clear();
                resource.on("usersLoggedInSuccess", function(data) {
                    dispatcher.fire("usersLoggedInSuccess", data);
                  });
                resource.on("usersLoggedInError", function(errorInfo) {
                    dispatcher.fire("usersLoggedInError", errorInfo);
                  });
            };

            this.usersLoggedIn = function() {
                resource.usersLoggedIn();
            };

            this.getOtherUsersLoggedInList = function() {
                return resource.getOtherUsersLoggedInList();
            };

            this.setUpdateState = function(state) {
              resource.setUpdateState(state);
            };

            this.getUpdateState = function() {
              return resource.getUpdateState();
            };
        }

        return new ApplianceUpdatePresenter();

    }());

    return ApplianceUpdatePresenter;
});
