// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineAddView)
 * This is a view class for Baseline Add menu option.
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/core/Notifications',
    'hp/view/DialogView',
    'hp/model/Session',
    'hp/core/Localizer',
    'hp/core/Router',
    'text!hpPages/core/header_help.html',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery-ui-timepicker-addon',
    'lib/jquery.dateFormat',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.cookie',
    'lib/jquery.jstree'],
function(presenter, notifications, DialogView, session, localizer, router, headerHelpHtml) { "use strict";

    var BaselineAddView = (function() {
      
        var ADD = '#hpsum-baselines-add',
            CANCEL = '#hpsum-baselines-add-close',
            RESET = "#hpsum-baselines-reset",
            NAME = '#hpsum-baselines-name',
	    PATH_DETAILS = '#hpsum-path-details',
            PATH = '#hpsum-location-path',
            LOCATION_TYPE = '#hpsum-baseline-location-type',
            URI_PATH = '#hpsum-baseline-uri-path',
            USER_NAME = '#hpsum-baseline-add-username',
            PASSWORD = '#hpsum-baseline-add-password',
	    BROWSE_LOCATION_ERROR = '#hpsum-invalid-location-error',
            BROWSE_BUTTON = '#hpsum-browse-location',
            BROWSE_TREE = '#browse',
            BROWSE_DIALOG = '#hpsum-browse-dialog',
            INFO_DIALOG = '#hpsum-info-dialog',
            ROUTE_PREFIX = '/baseline/add',
            PANEL_SELECTOR = "#hpsum-baseline-add-panel-selector",
            PANELS = '#hpsum-baseline-add-panels',
            URI_DETAILS = '#hpsum-uri-details',
            BASELINE_LABEL = '#hpsum-baseline-location-lable-path',
            PROXY_SETTINGS = '#hpsum-baseline-proxy-settings',
	    SCHEDULE_DETAILS = '#hpsum-baseline-schedule-information',
	    FORM = '#hpsum-baselines-add-form',
	    BROWSE_OK='#hp-baseline-add-ok',
            PROXY_USE_HP = '#hpsum-baseline-proxy-hp',
            SPLASH_DIALOG = '#hpsum-add-wait-dialog',
			SPLASH_SPINNER = '#hpsum-add-spinner';
            
        /**
         * Constructor
         */
        function BaselineAddView() {
          
            var addInProgress = false;
            var browseDialogContents;
            var infoDialog;
            var whichProxySettings,
                addWaitDialog,
                timer;
          
           	function onPathEdit() {
				$(BROWSE_LOCATION_ERROR).hide();
				$(PATH).removeClass("hp-error");
				$(PATH).unbind('keyup', onPathEdit);
			}

			function handleInvalidPath(hapi) {
				if (hapi.hcode == 5) {
					$(BROWSE_LOCATION_ERROR).text(localizer.getString('hpsum.baseline.add.inValidLocation'));
					$(PATH).addClass("hp-error");
					$(BROWSE_LOCATION_ERROR).show();
					$(PATH).keyup(onPathEdit);
					$('#browse-dialog-cancel').trigger('click');
				    	$(ADD).attr("disabled", true);
				} else {
				    $(BROWSE_LOCATION_ERROR).hide();
				    $(PATH).removeClass("hp-error");
				    $(PATH).unbind('keyup', onPathEdit);
				}
			}

            function reset() {
                $(NAME).val("");
                $(NAME).focus();
                $(PATH).val("");
                var firstOption = $('#hpsum-baseline-location-type option:first');
				firstOption.attr('selected', true);
		$(PATH_DETAILS).show();
                $(URI_DETAILS).hide();
                $(PROXY_SETTINGS).hide();
                addInProgress = false;
                $(ADD).attr("disabled", true);
                $('#hpsum-baseline-proxy-hp').val("");
                $('#hpsum-baseline-proxy-url').val("");
                $('#hpsum-baseline-proxy-port').val("");
                $('#hpsum-baseline-proxy-username').val("");
                $('#hpsum-baseline-proxy-password').val("");
                $('#hpsum-baseline-proxy-username').val("");
                $('#hpsum-baseline-proxy-password').val("");
                $('#hpsum-baseline-proxy-hp').checked=false;
                $('#hpsum-baseline-proxy-scriptopt').checked=false;
            }
            
            function resetCancel() {
                reset();
            }
            
         
			function onItemAddSuccess(item) {
					resetCancel();
					addInProgress = false;
					closeAddWait();
					$(CANCEL).trigger('click');
					$(CANCEL).on('click', function() {
						if (item.hasOwnProperty("baseline_uri")) {
							var uri = '/baseline/show/r' + item.baseline_uri;
							router.go(uri);
						}
					})
			}

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.show(errorMessage, 'error');
                addInProgress = false;
                resetCancel();
                closeAddWait();
                $(CANCEL).trigger('click');
            }


				function showAddWait() {

					if (!addWaitDialog) {
						addWaitDialog = $(SPLASH_DIALOG);
						addWaitDialog.dialog({
							modal : true,
							dialogClass : 'hp-simple-dialog',
							position : "center",
							draggable : false,
							resizable : false,
							width : 260,
							height : 180
						});
					}
					$(SPLASH_SPINNER).show();
					addWaitDialog.dialog('open');
				}

				function closeAddWait() {
					$(SPLASH_SPINNER).hide();
					if (addWaitDialog) {
						addWaitDialog.dialog('close');
					}
				}
			

				
            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onAddItem() {
            	
            	showAddWait();
            	
                if(! addInProgress) {
                    addInProgress = true;                    
                    presenter.addItem({
                    	category: 'baseline',
                    	name: 'Service Pack for Proliant ' + (new Date()).getTime(), //adds a dummy baseline name for now
                        locationType: $(LOCATION_TYPE).val(),
						location: $(PATH).val(),
                        uripath: $(URI_PATH).val(),
                        username : $(USER_NAME).val(),
                        password : $(PASSWORD).val(),
                        proxySettingsType : whichProxySettings, 
                        pusername : $('#hpsum-baseline-proxy-username').val(),
                        ppassword : $('#hpsum-baseline-proxy-password').val(),
                        port : $('#hpsum-baseline-proxy-port').val(),
                        proxyurl : $('#hpsum-baseline-proxy-url').val(),
                        proxyscript : $('#hpsum-baseline-proxy-script').val(),
                        uri: '/baseline/item-' + (new Date()).getTime(), 
                        status: 'ok',
                        attributes: {version:'2012.10.31', size:'1.5 GB'}}, {
                        success : onItemAddSuccess,
                        error : onItemAddError
                    });
                    
                    //$(CANCEL).trigger('click');
                }

                //return false;
            }
            
            /**
             * * Show information dialog to user such as selecting a valid baseline before proceed.
             */
            function showInfoDialog()
            {
            	if (!infoDialog) {
                    infoDialog =  $(INFO_DIALOG);
                    infoDialog.dialog({
                        modal : true,
                        dialogClass: 'hp-simple-dialog',
                        position : "center",
                        draggable : false,
                        resizable : false
                    });
                    $('button', infoDialog).on('click', function () {
                        infoDialog.dialog('close');
                    });
                }
                infoDialog.dialog('open');
            }
            
            /**
             * * Initialize and display browse dialog.
             * * User can navigate to any folder and choose a valid baseline location 
             */
            function initBrowseDialog(){
            	new DialogView({contents: browseDialogContents,
                	position : "center",
                    ok: function (elem) {
                    	
                    	var node = $(BROWSE_TREE).jstree('get_selected');
                    	if(node[0] == null || (node[0] && node[0].attributes["rel"].value != "package"))
                    	{
                    		var loc_type = $(LOCATION_TYPE).val();
                    		if(loc_type == 'local')
                    		{
                    		//alert("Please select a valid folder!");
	                    		showInfoDialog();
	                    		return false;
                    		}
                    	}
                    	$(PATH).val(node[0].id);
                    	$(ADD).attr("disabled", false);
                    },
                    cancel: function () {
                    	$(PATH).val('');
                    }
                });
            }
            
            /**
             * * Create a JsTree inside the browse dialog.
             * * This includes operations such as JSON data load through AJAX call, configuration of tree etc.
             */
            function createTree(){
            	
            	var uri = "Session/" + session.getToken()  + "/Baseline/browse";
				var initial_folder = $(PATH).val();
				
				$(BROWSE_TREE).empty();
                $(BROWSE_TREE).jstree({
                        "json_data" : {
                        		   "ajax" : {
						           		"url" : function (node) {
	                                        var url;
	                                        if (node == -1) {
	                                            url = "Session/" + session.getToken()  + "/Baseline/browse";
	                                        } else {
	                                            url = null;
	                                        }
	                                        return url;
	                                    },
										"type" : "POST",
					                    "dataType" : "json",
					                    "data" : function (n) { 
												var object = {
														"hapi": {
    														"uri": $(PATH).val().length > 0 ? $(PATH).val() : ".."
														}
													}; 
												
												return JSON.stringify(object); 
										},
										"success" : function (output) {
											
											var data = [], children = [], index, node, bAddParent = false;
											
											//This will handle if user has given an invalid location to browse.
											handleInvalidPath(output.hapi);
											
											//hcode has string value in the response payload. This need to be changed later when it is 
											//changed to integer value
											if(output.hapi.hcode != "0")
											{
												//add a node to navigate to parent directory 
												node = {
											        		"data" : "..",
											        		"attr" : { "id" : "..", "rel" : "parent"},
											                "state" : "open",
											               }
											               
											    data.push( node );
												return data;
											}
											
											//iterate through folders and create child nodes
											for(var i=0; i < output.hapi.folders.folder.length; i++ ){
												var folder = output.hapi.folders.folder[i];
												var child, rel;
												
												if(i === 0) 
												{
													var str = $(PATH).val();
													if(str === '/')
													{
														bAddParent = false;
													}
													else if(i == 0) // && (str.length > 0 && str.indexOf('/') === -1)) 
													{
														bAddParent = true;
														continue;
													}
												}	
												
												//if it is root folder and drive, add the first item as a sibling node instead of parent node
												//change icon if folder is a valid package
												if(folder.possible_package)
													rel = "package";
												else
													rel = "folder";
												
												//take only last folder name from complete path
												//var str = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
												var strfolder, idfolder;
												if(str === '/') {
													strfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/')-1);//folder.folder_name;
													idfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/'));
												}
												else {
													strfolder = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
													idfolder = folder.folder_name;
												}
												
												//create children nodes
									        	child = {
									        		"data" : strfolder,
									        		 "attr" : {"id" : idfolder, "rel" : rel}
									        		}
										        children.push( child );
										    }
											
											//add a node to navigate to parent directory 
											node = {
										        		"data" : "..",
										        		"attr" : { "id" : "..", "rel" : "parent"},
										                "state" : "open",
										               }
										               
										    data.push( node );
										    
										    if(bAddParent) {
										    	var rel, val;
										    	if(output.hapi.folders.folder[0].possible_package)
													rel = "package";
												else
													rel = "folder";
													
												if($(PATH).val() === '')
													val = output.hapi.folders.folder[0].folder_name
												else
													val = $(PATH).val();
											    //add parent folder to folder list
												node = {
											        		"data" : val,//output.hapi.folders.folder[0].folder_name,
											        		"attr" : { "id" : val, "rel" : rel}, //{ "id" : output.hapi.folders.folder[0].folder_name, "rel" : rel},
											                "metadata" :  output.hapi.folders.folder[0],
											                "state" : "open",
											                "children" : children
											               }
											               
											    data.push( node );
											}
											else
											{
												data.push(children);
											}
											
										                
											return data;
										}
						           }
						},
                        "themes" : {
                                "theme" : "default",
                                "url" : "/css/style.css",
                                "dots" : true,
                                "icons" : true
                        },
                        "plugins" : [ "themes", "json_data", "ui" , "crrm", "types" ],
                        "types" : {
                                "max_depth" : -2,
                                "max_children" : -2,
                                "valid_children" : [ "drive" ],
                                "types" : {
                                        "default" : {
                                                "valid_children" : "none",
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "folder" : {
                                                "valid_children" : [ "default", "folder", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "package" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/status-ok.png"
                                                }
                                        },
                                        "drive" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/down-arrow.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        },
                                        "parent" : {
                                                "valid_children" : [ "default", "folder", "drive", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/grid-collapse.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        }
                                        
                                }
                        }
                })
                .bind("dblclick.jstree", function (event, data) {
                		var node = $(BROWSE_TREE).jstree('get_selected');
                		if(node[0].id === "..")
                		{
                			if(node[0].nextSibling)
                			{
                				var str = $(PATH).val(); 
                				if(str === '')
                				{
                					$(PATH).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
                				}
                				else if(str === '/')
                				{
                					
                				}
                				else
                				{
	                				if(str.indexOf('/') != -1)
	                					$(PATH).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
	                				else
	                					$(PATH).val("/");
	                			}
                			}
                			else
                			{
                				$(PATH).val("/");
                			}
                		}
                		else 
                		{	
                    		$(PATH).val(node[0].id);
                    	}
                		
                		$(BROWSE_TREE).jstree("refresh");
                })
                .bind("select_node.jstree", function (event, data) { 
                    var node = $(BROWSE_TREE).jstree('get_selected');
                    var loc_type = $(LOCATION_TYPE).val();
                    if (loc_type != 'FTP'){
                        if(node[0] && node[0].attributes["rel"].value != "package")
                            $(BROWSE_OK).attr("disabled","disabled");
                        else
                            $(BROWSE_OK).removeAttr("disabled");
                        }
                    else
                        $(BROWSE_OK).removeAttr("disabled");
                        });
                }
            
            function onProxyOptionChange()
            {
            	if($(this).length <= 0)
            		return
            	
            	if($(this)[0].id === "hpsum-baseline-proxy-hp" && $(this)[0].checked === true) {
            		$('#hpsum-proxy-usehp-item').show();
            		$('#hpsum-proxy-usescript-item').hide();
            		whichProxySettings="generalProxy";
                }
            	else if($(this)[0].id === "hpsum-baseline-proxy-scriptopt" && $(this)[0].checked === true) {
            		$('#hpsum-proxy-usehp-item').hide();
            		$('#hpsum-proxy-usescript-item').show();
            		whichProxySettings="scriptedProxy";
                }
            }
            
            /**
	         * @public
	         */
            this.resume = function () {
            	reset();
            };
            
            this.pause = function () {
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {

	  	reset();

                $(PANELS).hpStackedPanels({
                        panelSelector : PANEL_SELECTOR
                    });
	    
	       var listItem = $('.hp-details-header-controls', $(FORM).parent());

		// put help in header
                if ($('.hp-details-header-controls', $(FORM).parent()).length === 0) {
                    var headerHelp = $(headerHelpHtml);
                    localizer.localizeDom(headerHelp);
                    $('.hp-details-header', $(FORM).parent()).append(headerHelp);
                }

                $(ADD).live('click', function(ev) {
                    onAddItem.call(this);
                    ev.preventDefault();
                });
                $(RESET).live('click', function() {
                    reset.call();
                });
                
                browseDialogContents = $(BROWSE_DIALOG).detach().show();
                
                $(BROWSE_BUTTON).on('click', function () {
                  
                  	initBrowseDialog();
                  	
                    $(BROWSE_OK).attr("disabled","disabled");
                    createTree();
	            });

                $(LOCATION_TYPE).change(function() {
                    var value = $(this).val();
                    if(value == 'local')
                    {
                    	$(BASELINE_LABEL).html(localizer.getString('hpsum.baseline.add.enterDirectory'));
			$(PATH_DETAILS).show();
                        $(URI_DETAILS).hide();
                        $(PROXY_SETTINGS).hide();
			$(ADD).attr("disabled", true);
                    }
                    else if (value == 'UNC') 
                    {
			$(PATH_DETAILS).hide();
                        $(URI_DETAILS).show();
                        $(PROXY_SETTINGS).hide();
                    	$(ADD).attr("disabled", false);
                    }
                    else
                    {
                    	$(BASELINE_LABEL).html(localizer.getString('hpsum.baseline.add.enterWorkingDirectory'));
			$(PATH_DETAILS).show();
                        $(URI_DETAILS).hide();
                        $(PROXY_SETTINGS).show();
			$(ADD).attr("disabled", true);
                    }
                });
                
                $('#hpsum-proxy-usehp-item').hide();
            	$('#hpsum-proxy-usescript-item').hide();
                
                $('input:radio[name=hpsum-baseline-proxy-opt]').click(onProxyOptionChange);
	            
                this.resume();
			};
        }

        return BaselineAddView;
    }());
    
    return new BaselineAddView();
});
