// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupDeployView)
 * This is a view class for Group Deploy View.
 */
define(['hpsum/presenter/group/GroupPresenter',
	'hp/core/Router',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
	'hp/view/DialogView',
	'hp/core/Localizer',
    'jquery',	
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'lib/jquery.dataTables.rowReordering',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',	
	'hp/lib/jquery.hpSearchCombo'
	],

function(presenter, router, notifications, helpMenu, DialogView, localizer) {"use strict";

	var GroupDeployView = ( function() {

			//Consts can go here
			var DEPLOY = '#hpsum-group-deploy-ok',
			    RESET = '#hpsum-group-reset',
			    CANCEL = '#hpsum-group-deploy-close',
			    PANEL_SELECTOR = '#hpsum-deploy-panel-selector',
			    FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
			    PANELS = '#hpsum-group-deploy-panels',
			    NAME = '#hpsum-group-deploy-name',
			    REBOOTOPTION = '#hpsum-deploy-reboot-option',
			    DELAYSEC = '#hpsum-group-deploy-delay-seconds',
			    MESSAGE = '#hpsum-group-deploy-reboot-message',
			    ROUTE_PREFIX = '/group/deploy',
			    NONECHECKBOX = '.nonecheckbox',
			    USESNMPCHECKBOX = '.useSNMPcheckbox',
			    USEAGENTLESSCHECKBOX = '.useAgentlesscheckbox',
			    USEWEBEMCHECKBOX = '.useWEBEMcheckbox',
			    DOWNGRADECHKBOXCOMP = '.downgradechkbox',
			    REWRITECHKBOXCOMP = '.rewritechkbox',
			    FIRMWARECHKBOXCOMP = '.firmwarechkbox',
			    SOFTWARECHKBOXCOMP = '.softwarechkbox';

			/**
			 * Constructor
			 */
			function GroupDeployView() {

				var groupItem = null, setAttributesOnGroup = false, 
				defaultOptiondetails = {
					hapi : {
						os_management_options : {
							none : false,
							usesnmp : false,
							useagentless : false,
							usewebem : false
						},

						installation_option : {
							downgrade : false,
							rewrite : false,
							force : false
						},

						reboot_options : {
							action : 'No',
							delay : '3600',
							message : 'Reboot at user request after deploy'
						}
					}
				},
				optiondetails = defaultOptiondetails;

				function onItemChange(item) {
					groupItem = item.hapi;

					if (groupItem) {
						$(NAME).text(groupItem.group_name);
						$(DEPLOY).attr("disabled", false);
					} else {
						$(CANCEL).trigger('click');
					}
				}

				function setoptiondetails() {
					var optionSelected = false,
					    atleastOneOptionSelected = false;
					
					optionSelected = $(NONECHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.none = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USESNMPCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.usesnmp = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USEAGENTLESSCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.useagentless = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(USEWEBEMCHECKBOX).is(':checked');
					optiondetails.hapi.os_management_options.usewebem = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}

					if (!atleastOneOptionSelected) {
						optiondetails.hapi.os_management_options = {};
					}else {
						setAttributesOnGroup = true;
					}
					atleastOneOptionSelected = false;

					optionSelected = $(DOWNGRADECHKBOXCOMP).is(':checked');
					optiondetails.hapi.installation_option.downgrade = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					optionSelected = $(REWRITECHKBOXCOMP).is(':checked');
					optiondetails.hapi.installation_option.rewrite = optionSelected;
					if (!atleastOneOptionSelected) {
						atleastOneOptionSelected = optionSelected;
					}
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.installation_option = {force : false};
					}
					
					if ($(SOFTWARECHKBOXCOMP).is(':checked') || $(FIRMWARECHKBOXCOMP).is(':checked')) {
						optiondetails.hapi.installation_option.force = true;
						if (!atleastOneOptionSelected) {
							atleastOneOptionSelected = true;
						}
					}
					
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.installation_option = {};
					} else {
						setAttributesOnGroup = true;
					} 
					atleastOneOptionSelected = false;

					if (($(REBOOTOPTION).val() == "If needed") || ($(REBOOTOPTION).val() == "Always")) {
						atleastOneOptionSelected = true;
					}
					optiondetails.hapi.reboot_options.action = $(REBOOTOPTION).val();
					
					if ($(DELAYSEC).val() != '') {
						optiondetails.hapi.reboot_options.delay = $(DELAYSEC).val();
					}
					
					if ($(MESSAGE).val() != '') {
						optiondetails.hapi.reboot_options.message = $(MESSAGE).val();
					}
					
					if (!atleastOneOptionSelected) {
						optiondetails.hapi.reboot_options = {};
					} else {
						setAttributesOnGroup = true;
					}
					atleastOneOptionSelected = false;
				}

				function onSetattributeSuccess(item) {

				}

				function onSetattributeError(errorMessage) {
					notifications.show(errorMessage, 'error');
					$(DEPLOY).attr("disabled", true);
					$(CANCEL).trigger('click');
				}

				function onDeploy() {

					setoptiondetails();
					
					if (setAttributesOnGroup) {
						presenter.setAttributes(groupItem, optiondetails, {
							success : onSetattributeSuccess,
							error : onSetattributeError
						});

						setAttributesOnGroup = false;
					}

					presenter.deploy(groupItem, {
						success : onDeploySuccess,
						error : onDeployError
					});
				}

				function onDeploySuccess(item) {
					notifications.show(groupItem.group_name + ' Group ' + localizer.getString("hpsum.group.deployStarted"), 'ok');
					$(CANCEL).trigger('click');
				}

				function onDeployError(errorMessage) {
					notifications.show(errorMessage, 'error');

					$(DEPLOY).attr("disabled", true);
					$(CANCEL).trigger('click');
				}

				function changeLocation(location) {
					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function populateOptions() {
					optiondetails = defaultOptiondetails;
					$(NONECHECKBOX).attr('checked', false);
					$(USESNMPCHECKBOX).attr('checked', false);
					$(USEAGENTLESSCHECKBOX).attr('checked', false);
					$(USEWEBEMCHECKBOX).attr('checked', false);

					$(DOWNGRADECHKBOXCOMP).attr('checked', false);
					$(REWRITECHKBOXCOMP).attr('checked', false);

					$(FIRMWARECHKBOXCOMP).attr('checked', false);
					$(SOFTWARECHKBOXCOMP).attr('checked', false);

					$(REBOOTOPTION).selectBox('value', 'No');
					$(DELAYSEC).val('3600');
					$('textarea' + MESSAGE).attr('value', 'Reboot at user request after deploy');
				}

				function reset() {
					populateOptions();
				}

				/**
				 * @public
				 * Initialize Group Deploy View
				 */
				this.init = function() {

					$(DEPLOY).live('click', function(ev) {
						onDeploy.call(this);
						ev.preventDefault();
					});

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(".hp-collapsible").hpCollapsible();

					$(DEPLOY).attr("disabled", false);

					$(RESET).live('click', function() {
						reset.call();
					});

					router.watch('Group Deploy section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});
					
					this.resume();
				};

				/**
				 * @public
				 * Resume Group Deploy View
				 */
				this.resume = function() {
					presenter.on("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('resume');
					reset();
				};

				/**
				 * @public
				 * Pause Group Deploy View
				 */
				this.pause = function() {
					presenter.off("itemChange", onItemChange);
					$(PANELS).hpStackedPanels('pause');
				};
			}

			return GroupDeployView;
		}());

	return new GroupDeployView();
});
