// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router','hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var LicenseRoutes = ( function() {

        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view';
        var AUTH_CATEGORY = 'appliance';
        var CHANGE_CONTAINER = '#hp-change-page-container';

        function LicenseRoutes() {
            var registered = false;
            this.register = function () {
                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings show license *',
                    '/settings/show/license/general' + urlFragment.viewPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/more.html',
                            'fs/view/settings/license/LicenseMoreView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings show eulapage *',
                    '/settings/show/license/eulapage' + urlFragment.viewPatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/eulapage.html',
                            'fs/view/settings/license/LicenseEulaView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings show writtenoffer *',
                    '/settings/show/license/writtenoffer' + urlFragment.viewPatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/writtenoffer.html',
                            'fs/view/settings/license/LicenseWrittenofferView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new LicenseRoutes();

    }());

    return LicenseRoutes;

});