// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['fs/view/settings/network/TimeAndPlaceView',
    'fs/presenter/settings/NetworkSetupPresenter',
    'fs/view/settings/network/NetworkEditViewBase',
    'hp/core/Router', 
    'hp/core/UrlFragment',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',    
    'jqueryUI',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo'],
function(TimeAndPlaceView, presenter, NetworkEditViewBase, router, urlFragment) {"use strict";

    return ( function() {

        var OK = '#cic-settings-edit-ok',
            CANCEL = '#cic-settings-edit-cancel',
            SPINNER = '#cic-settings-edit-spinner',
            NOTIFY_BOX = '#cic-settings-details-notify',
            ROUTE_PREFIX = '/settings/edit/network',
            PANELS = '#cic-appliance-network-panel',
            PANEL_SELECTOR = '#cic-setting-network-panel-selector',
            FORM = '#cic-settings-network-form';


        /**
         * @class View script for the Network Settings panel of the Edit Settings page.
         */
        function NetworkEditView() {

            var base = new NetworkEditViewBase();
            var timeAndPlace = new TimeAndPlaceView();
            
           
            function setControlsDisabled(disabledFlag) {       
                 $(CANCEL).toggleClass('hp-disabled', disabledFlag);
                 $(OK).toggleClass('hp-disabled', disabledFlag); 
            }            
 
            /**
             * @private Set the active panel
             *
             */
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }

           function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(PANEL_SELECTOR, selection.uris);
                urlFragment.replaceHrefUris(CANCEL, selection.uris);                          
                $(PANELS).hpStackedPanels('setPanelByLocation',
                    '#' + router.location());
           }
            /**
             * @public On successful backend update redirect if needed or return
             *         to settings overview page
             */
            function onApplySuccess(redirect) {

                base.resetForm();
                setControlsDisabled(false);
                if (!redirect) {
                    $(CANCEL).trigger('click');
                }
            }
            /**
             * @public In case of backend error , remain on the current page
             */

            function onApplyError() {
                setControlsDisabled(false);
            }


            function onApplyRedirect(redirect) {
                if (redirect) {
                    if (presenter.shouldReloadWindow() ) {
                      // wait for 15 seconds before redirecting
                        setTimeout( function() {
                             redirect();
                             base.dismissDialog();
                             onApplySuccess(true);
                            },15000);
                    } else {
                       base.dismissDialog();
                       redirect();
                       onApplySuccess(true);
                    }

                } else {
                  //wait for 10 seconds for cert to relaod
                    if (presenter.shouldReloadWindow() ) {
                          setTimeout( function() {
                             base.dismissDialog();
                             window.location.reload();
                             onApplySuccess(false);
                          }, 10000 );
                    } else {
                           // wait extra 15 seconds to make sure fts is done
                          setTimeout( function() {
                             base.dismissDialog();
                             onApplySuccess(false);
                            }, 15000 );

                    }
                }
            }
            /**
             * @public Handle a click of the OK button by sending a REST request
             *         to set the new configuration
             */
            function apply() {

                if(!$(FORM).valid()) {
                    base.displayParameterError();
                    return;
                }
                setControlsDisabled(true);

                if(presenter.hasTaskWarnings() && 
                    (!base.isFieldValueChanged())){ // no values changes -so no need to validate ,just set it
                    base.applyNetworkWithWarnings({
                       success: onApplyRedirect,
                           error: onApplyError

            });
              }else
                {
                base.apply({ // Normal Flow
                      success: onApplyRedirect,
                          error: onApplyError
                  });
                }
            }
            function  resetChange(){
              base.resetForm();
            }
            function registerTimeAndPlaceEvents(){
                timeAndPlace.on("fieldUpdated",resetChange);
            }
            function removeTimeAndPlaceEvents(){
               timeAndPlace.off("fieldUpdated",resetChange);
            }

            /**
             * @public Initialization method
             */
            this.init = function() {
                registerTimeAndPlaceEvents();
                base.setFirstTime(false);
                presenter.on("selectionChange", onSelectionChange);                   
                base.init(ROUTE_PREFIX, FORM);
                timeAndPlace.init();
                // pass the form state view to Time and place 
                timeAndPlace.setFormStateViewInstance(base.getFormStateViewInstance());
                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                
                var validatorOptions = {};
                base.addValidatorOptions(validatorOptions);
                timeAndPlace.addValidatorOptions(validatorOptions);
                var validator =  $(FORM).validate(validatorOptions);
                base.setValidator(validator);
                timeAndPlace.setValidator(validator);
                // base.setValidator($(FORM).validate(base.addValidatorOptions({})));
                base.setNotifyElement($(NOTIFY_BOX));

                router.watch('appliance network section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});


                presenter.getNetworkConfiguration({
                    success: function(config) {
                        base.setFormLayout(config);
                        base.fillFields(config);
                    },
                    error: base.onError
                });
                // Handlers for the buttons.
                $(OK).on('click', function(ev) {
                    if ( $(OK).hasClass('hp-disabled') ){  
                        return false;
                    } else {
                        timeAndPlace.setTimeAndPlace({
                            success: function() {
                              // if time and place success call apply networking settings
                                  apply(true);
                            },
                            error: function (errorInfo){
                              // if time and place error call dismissDialog
                              base.dismissDialog();
                         }});
                        ev.preventDefault();
                    }
                });
                 
                $(CANCEL).on('click', function(ev) {
                    if ( $(CANCEL).hasClass('hp-disabled') ){                 
                        return false;
                    } else {
                        base.resetForm();
                        return true;                   
                    }
                   
                });
                // Don't show the spinner.
                $(SPINNER).hide();

                $(NOTIFY_BOX).fadeOut();
               
            };

            this.pause = function() {
                 presenter.off("selectionChange", onSelectionChange);
                 $(PANELS).hpStackedPanels('pause');
                 removeTimeAndPlaceEvents();
            };
            /**
             * @public IWhen re-enter the page make sure to reset the form
             * and re-obtain the data
            */
            this.resume = function() {
                registerTimeAndPlaceEvents();
                base.resetForm(FORM);
                presenter.on("selectionChange", onSelectionChange);
                presenter.getNetworkConfiguration({
                    success: function(config) {
                        base.setFormLayout(config);
                        base.fillFields(config);
                    },
                    error: base.onError 
               });
               timeAndPlace.resume();
               $(PANELS).hpStackedPanels('resume');                  
            };

            this.addValidatorOptions = base.addValidatorOptions;
        }

        return new NetworkEditView();
    }());
});
