// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
        'fs/presenter/status/StatusPresenter'],

function(Localizer, statusPresenter) {"use strict";

    var StatusWaitingView = ( function() {

    var NOTIFY_MSG = "#cic-appliance-restart-msg-id";


        /**
         * @class View script for the /status/waiting page
         */
        function StatusWaitingView() {

            this.init = function() {

                if ( statusPresenter.isRebootRequested() ) {
                    $(NOTIFY_MSG).html(Localizer.getString('fs.status.waiting.rebootingMessage'));

                } else {
                   $(NOTIFY_MSG).html(Localizer.getString('fs.status.waiting.waitingMessage'));
                }
                $(NOTIFY_MSG).show();
            };

            this.pause = function() {
                // nothing
            };

            this.resume = this.init;
        }

        return new StatusWaitingView();

    }());

    return StatusWaitingView;

});
