// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {Performance}
 */
define(['jquery'],
function () { "use strict";

   var Performance = (function () {
     
        var startFrom = null;
        var lastFrom = {};
        var outstandingNavigations = [];
        var outstandingOperations = [];

        function Performance() {
          
            function duration(startTime) {
                var endTime = new Date();
                return (endTime.getTime() - startTime.getTime()) + "ms";
            }
          
            function updateIfDone() {
                var elapsed;
                if (outstandingNavigations.length === 0 &&
                    outstandingOperations.length === 0 &&
                    startFrom) {
                    elapsed = duration(startFrom.timestamp);
                    //console.log("!!! PERF OVERALL " + startFrom.location +
                    //    " took " + elapsed);
                    lastFrom = startFrom;
                    lastFrom.duration = elapsed;
                    startFrom = null;
                }
            }
            
            this.getLast = function () {
                return lastFrom;
            };
          
            this.beginNavigation = function (location) {
                //console.log("!!! PERF NAV begin " + location);
                var from = {timestamp: new Date(),
                  location: location};
                outstandingNavigations.push(from);
                if (! startFrom) {
                    //console.log("!!! PERF OVERALL start " + location);
                    startFrom = from;
                }
            };
            
            this.endNavigation = function (location) {
                //console.log("!!! PERF NAV end " + location);
                var beginFrom = null;
                outstandingNavigations =
                    $.grep(outstandingNavigations, function (from, index) {
                        if (! beginFrom && from.location === location) {
                            beginFrom = from;
                            return false;
                        }
                        return true;
                    });
                if (beginFrom) {
                    //console.log("!!! PERF NAV " + location + " took " +
                    //    duration(beginFrom.timestamp));
                    updateIfDone();
                }
            };
            
            this.beginOperation = function (uri) {
                //console.log("!!! PERF OP begin " + uri);
                var from = {timestamp: new Date(),
                  uri: uri};
                outstandingOperations.push(from);
            };
            
            this.endOperation = function (uri) {
                //console.log("!!! PERF OP end " + uri);
                var beginFrom = null;
                outstandingOperations =
                    $.grep(outstandingOperations, function (from, index) {
                        if (! beginFrom && from.uri === uri) {
                            beginFrom = from;
                            return false;
                        }
                        return true;
                    });
                if (beginFrom) {
                    //console.log("!!! PERF OP " + uri + " took " +
                    //    duration(beginFrom.timestamp));
                    updateIfDone();
                }
            };
        }

        return new Performance();
    }());

    return Performance;
});
