// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {VcShowRoutes}
 * This is used to provide route map for each Vc action.
 * This also provides default redirector and shows default error page if no matching URI identified.
 */

define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { 
	"use strict";
	// Constructor
	var VcShowRoutes = ( function() {
		var CONTAINER = '#hpsum-vc-page .hp-details-show-view';
		var CHANGE_CONTAINER = '#hp-change-page-container';
		function VcShowRoutes(){
			
			var registered = false;
			this.register = function() {
				if(registered) return;
				registered =true;
				 
			router.map('vc show overview', '/vc/show/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/vc/vcOverview.html',
						'hpsum/view/vc/VcOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}
				});
				

			router.map('vc show overview multi',
                   '/vc/show/overview' +
                    urlFragment.viewMultiPatternTerminal, {
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpsumpages/node/overview_multi.html',
                            'hpsum/view/node/NodeShowOverviewMultiView'],
                        function (page, view) {
                            result.load(page, view);
                        });
						}
					});

				router.map('node vc overview', '/node/show/virtual_connect/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/vc/vcOverview.html',
						'hpsum/view/vc/VcOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				
				router.map('node switch overview', '/node/show/(switch|fc_switch|sas_switch)/overview' +
				urlFragment.viewSinglePatternTerminal, {
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpsumpages/switch/overview.html',
						'hpsum/view/switch/SwitchOverviewView'],
						function (page,view){
							result.load(page,view);
						});
					}				
					
				});
				

				
				router.filter ('vc show default redirector',
					'/vc/show' + urlFragment.viewPatternTerminal, {
					 check: function (location, result) {
					 	result.replaceWith(urlFragment.replaceView(location, 'show/overview'));
					 }
				});	

				router.map('vc show no route', '/vc/show/.+',
				{
					container: CONTAINER,
					enter: function(location, result) {
						require(['text!hpPages/core/no_details.html'],
						function (page){
							result.load(page);
						});
					}
					
				});
			}
		}
		
		return new VcShowRoutes();
		
	}());
	
	return VcShowRoutes;

});