// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {GroupShowOverviewView}
 * Provides functions to show overview/details pane for a group
 */

define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/UrlFragment',
    'hp/core/Router',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpGridPanels',
    'hp/lib/jquery.hpEllipsis',
    'lib/jquery.ThreeDots',
    'lib/jquery.columnizer',
    'lib/jquery.dateFormat',
    'hp/lib/date'],

function(groupPresenter, urlFragment, router, noneHtml, localizer) {"use strict";

	var GroupShowOverviewView = ( function() {

			//Consts can go here
			var ROOT = '#hpsum-group-show-overview',
			    SPINNER = '#hpsum-group-add-spinner',
			    NAME = '#hpsum-over-group-name',
			    DESCRIPTION = '#hpsum-over-group-description',
			    NODES_TABLE = '#hpsum-group-nodes-table';

			function GroupShowOverviewView() {

				var noItem,
				groupItem;

				function onSelectionChange(selection) {
					urlFragment.replaceHrefUris(ROOT, selection.uris);
				}

				function populateNodesTable(groupNodes) {
					groupPresenter.getAllNodes({
						success : function(results) {
							var tableNodes = [], groupCurrentNodes = groupNodes, nodes = groupPresenter.getNodeArray();
							for (var idx = 0; idx < nodes.length; ++idx) {
								if ($.inArray(nodes[idx].id, groupCurrentNodes) != -1) {
									tableNodes.push({
										name : nodes[idx].name,
										type : nodes[idx].type,
										node_status : nodes[idx].node_status,
										uri : nodes[idx].uri,
										id : nodes[idx].id
									});
								}
							}
							$(NODES_TABLE).dataTable().fnClearTable();
							$(NODES_TABLE).dataTable().fnAddData(tableNodes);
						},
						error : function(data) {
						}
					});
				}

				function onItemChange(item) {
					noItem.remove();
					groupItem = item.hapi;

					$(SPINNER).hide();
					$(NAME).text(groupItem.group_name);
					$(DESCRIPTION).text(groupItem.group_description);

					populateNodesTable(groupItem.group_nodes.group_node);

					router.go((urlFragment.replaceView(router.location(), 'show/overview')));
				}

				function onItemError(error) {
					$(ROOT).append(noItem);
				}

				function getItemUrl(oObj) {
					return '<a href="#/node' + '/show/r' + oObj.aData.uri + '">' + oObj.aData.name + '</a>';
				}

				/*
				 *  Public Functions
				 */

				this.init = function() {
					noItem = $(noneHtml);
					$(DESCRIPTION).ThreeDots({
						max_rows : 3,
						alt_text_t : true
					});

					var dummyNodeData = [];
					$(NODES_TABLE).dataTable({
						oLanguage : {
							sEmptyTable : localizer.getString("hpsum.group.noNodesInGroup")
						},
						bPaginate : false,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aaData : dummyNodeData,
						aoColumns : [{
							fnRender : getItemUrl,
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});

					this.resume();
				};

				this.resume = function() {
					groupPresenter.on("selectionChange", onSelectionChange);
					groupPresenter.on("itemError", onItemError);
					groupPresenter.on("itemChange", onItemChange);
				};

				this.pause = function() {
					groupPresenter.off("selectionChange", onSelectionChange);
					groupPresenter.off("itemChange", onItemChange);
					groupPresenter.off("itemError", onItemError);
				};

			}

			return new GroupShowOverviewView();
		}());

	return GroupShowOverviewView;
});
