// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/node/NodePresenter', 
    'hp/core/UrlFragment',
    'hp/core/Router',
    'hp/core/LinkTargetBuilder',
    'text!hpPages/core/no_details.html',
    'hp/core/Localizer',
	'hp/model/Session',
    'jquery',
    'hp/lib/jquery.hpGridPanels'],
function(presenter, urlFragment,router, linkTargetBuilder, noneHtml, localizer, session) { "use strict";

    var IloOverviewView = (function() {
      
        var ROOT = '#hpsum-ilo-show-overview';
        var PANELS = '.hp-grid-panels',
        	DESCRIPTION = '#hpsum-ilo-description',
        	TYPE ='#hpsum-ilo-type',
        	BASELINE='#hpsum-ilo-bundle',
        	LOCATION='#hpsum-ilo-location',
        	OA = '#hpsum-ilo-oa',			
			ASSOC_DEVICES = '#hpsum-iLO-assocdevices',
			NO_ASSOC_DEVICES = '#hpsum-iLO-no-devices',
        	INSTALLEDROM ='#hpsum-ilo-installed-rom',
        	ACTIVEROM = '#hpsum-ilo-active-rom',
        	MATRIXENABLED = '#hpsum-ilo-matrix-enabled',
        	MATRIXVERSION = '#hpsum-ilo-matrix-version',
        	SPINNER = '#hpsum-node-add-spinner',
            INSTALL_LOGS = '#hpsum-ilo-install-log';
      
        /**
         * Constructor
         */
        function IloOverviewView() {
          
            var noItem;
            var timer= null;
            var thisNode=null;
            
            function onItemChange(item) {
            	item = item.hapi;
            	thisNode =item;
                noItem.remove();
				$(ASSOC_DEVICES).html('');
 		        $(NO_ASSOC_DEVICES).show();
        		item.type = item.type.toLowerCase();
        		if(!router.location().match(item.type))
        			router.go((urlFragment.replaceView(router.location(), 'show/' + item.type + '/overview')));
               
                $('a.hp-button' , $(INSTALL_LOGS)).attr('href', '#/' + urlFragment.getPage(router.location()) + '/deploy-results');
                $(INSTALL_LOGS).hide();
        		if(item.node_state.match(/idle/i) && item.node_phase.match(/initialize/i)){
        			$('.hp-grid-panels').css({"display":"none"});
        			 $(SPINNER).show();
        		//	 getNodeStatus(item);
        		}
        		else {
        			$(SPINNER).hide();
        			//$(NO_ASSOC_DEVICES).hide();
					//$(ASSOC_DEVICES).hide();
					$('.hp-grid-panels').css({"display":""});
        			$('.hp-grid-panels').hpGridPanels('reset');     			
        			$(DESCRIPTION).text(item.description);
        			if(item.hasOwnProperty('serial_number'))
        				$(LOCATION).text(item.serial_number);
        			else 
        				$(LOCATION).text('');
        			if(item.hasOwnProperty('version')){
						//$(NO_ASSOC_DEVICES).hide();
						//$(ASSOC_DEVICES).show();
        				$(INSTALLEDROM).text(item.version);
        				$(ACTIVEROM).text(item.active_version);
						showAssociatedDevices(item);						
        			}
        			else{
        				$(INSTALLEDROM).text('');
        				$(ACTIVEROM).text('');
        				//$(NO_ASSOC_DEVICES).show();
						//$(ASSOC_DEVICES).hide();
        			}
        			
        			if(item.product_id == undefined)
        				$(TYPE).text(item.type);
        			else
        				$(TYPE).text(item.product_id);
        			$(MATRIXENABLED).text(item.matrix_enabled);
        			if(item.matrix_enabled === undefined){
        				$(MATRIXVERSION).text("");
        				$(MATRIXENABLED).text('');
        			}
        			else {
        			if(item.matrix_enabled.match(/no/i))
        				$(MATRIXVERSION).text("");
        			else
        				$(MATRIXVERSION).text(item.matrix_major_version+ '.' + item.matrix_minor_version + ' update '
        							+ item.matrix_update_version + '.' + item.matrix_subupdate_version);
        			}
        			var fwBaseline =presenter.getFWBaseline(item.baselines)
        			if(fwBaseline){
        					var baseline_url = '#/baseline/show/r'+fwBaseline.uri +'/getBaselineData';
        					name = fwBaseline.name;
        					$(BASELINE).html('<a href="'+ baseline_url +'">'+name+ '</a>');
        				}
        			else
        				$(BASELINE).text(localizer.getString('hpsum.node.noBaselineDefined'));  

                    if(item.node_state.match(/installdone/i))
                        $(INSTALL_LOGS).show();

        		}
                $(PANELS).hpGridPanels('reset');
                $(ROOT).removeClass('hp-show-changing');
                $('.hp-dynamic', ROOT).removeClass('hp-unavailable');
            }
            
			function showAssociatedDevices(item){
				if(item.associated_device === undefined) 
            		return;
            	if(item.associated_device.length == 0)
            		return;
            	$(NO_ASSOC_DEVICES).hide();
            	var tablecontents = "<table><tr> <td> <u>" + localizer.getString('hpsum.enclosure.deviceType') + "</u> </td> <td> <u>" + localizer.getString('hpsum.common.ipDns') + "</u> </td></tr>";            	
				for(var i=0; i<item.associated_device.length; i++){
					if(item.associated_device[i].node_id){
						var assoc_node_url = '#/node/show/r/session/' + session.getToken() +'/node/'+ item.associated_device[i].node_id+'/getData';
		        		tablecontents += "<tr><td>" + item.associated_device[i].type +'</td><td>' + '<a href= "' + assoc_node_url + '">' +item.associated_device[i].ip_or_dns+'</a>' + '</td></tr>';
					}
					else{
						tablecontents += "<tr><td>" + item.associated_device[i].type +'</td><td>' + item.associated_device[i].ip_or_dns + '</td></tr>';
					}
            	}
				tablecontents += "</table>";
				$(ASSOC_DEVICES).html(tablecontents);			   	
            }
			
            function getNodeStatus(item){
            	  var ilotimer = setInterval(function () {
            		
            		presenter.getNodeStatus(item, {
                				success : function(data) {
                    				onIloStatusSuccess(data,ilotimer);
                    		 	},
                    			error : function(errorInfo) {
                        			onNodeStatusError(errorInfo,ilotimer);
                    			}
                			});
                			
                }, 3000);
            }
            
            function onIloStatusSuccess(data,ilotimer){
            	if(thisNode.node_id == data.hapi.node_status.node_id) {
            		if(!data.hapi.node_status.node_phase.match(/initialize/i)){
        				clearInterval(ilotimer);
        				ilotimer = 0;
        				presenter.refreshIndexResults();
        			}
        		}
            }   
            function onNodeStatusError(){
            	
            }      
            
            function onItemError(error) {
                $(ROOT).append(noItem);
            }
            
            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(ROOT, selection.uris);
                if ($(ROOT).hasClass('hp-show-init')) {
                    $(ROOT).removeClass('hp-show-init');
                } else {
                    $(ROOT).addClass('hp-show-changing');
                    $('#tour-server-bundle-item').addClass('hp-show-changing');
                }
            }
          
            /**
             * @public
             */
            this.resume = function() {
                $(PANELS).hpGridPanels('reset');
                presenter.on("selectionChange", onSelectionChange);
                presenter.on("itemError", onItemError);
                presenter.on("itemChange", onItemChange);
                
            };
            
            this.pause = function() {
                presenter.off("selectionChange", onSelectionChange);
                presenter.off("itemChange", onItemChange);
                presenter.off("itemError", onItemError);
                
            };
             
            this.init = function() {
            	if(!presenter.initDone)
            		presenter.init();
                noItem = $(noneHtml);
                $(PANELS).hpGridPanels();
                this.resume();
            };
        }

        return new IloOverviewView();
    }());
    
    return IloOverviewView;
});
