// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (OneTouchUpdateReports)
 * This is a view class for One Touch Update Reports menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpPanels',
    'lib/jquery.selectBox'],
function(presenter, router, FormStateView, helpMenu, localizer) { "use strict";
    	
    	var OneTouchUpdateReportsShowView = (function() {
    		var	FORM = '#hpsum-otu-reports-form',
    			PANEL_SELECTOR = '#hpsum-otu-reports-panel-selector',
            	FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',            	
            	PANELS = '#hpsum-otu-reports-panels',
    			RESET = '#hpsum-nodes-reset',
    			CANCEL ='#hpsum-nodes-reports-close',
    			GENERATE ='#hpsum-nodes-reports-generate',
    			TYPE = '#hpsum-node-reports-type',
            	ROUTE_PREFIX = '/node/reports';
           		
    		function OneTouchUpdateReportsShowView(){
          
            function reset() {

            }
            
            function resetCancel() {
                reset();
            }
            
            function generateReports(){
            	$(CANCEL).trigger('click');
            }
            
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
    			
    		this.init = function() {
    			
    			$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
    			               
                $(RESET).live('click', function() {
                    reset.call();
                });
                
                $(GENERATE).live('click', function(ev) {
                    generateReports.call(this);
                    ev.preventDefault();
                });
                
                router.watch('one-touch-update reports section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
                    
                this.resume();
            };
            
            this.resume = function () {
            };
            
            this.pause = function () {
            };
    		
    	}	
    	return OneTouchUpdateReportsShowView;
    }());
    	
    return new OneTouchUpdateReportsShowView();	
    		
    });

