// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {ActivityRoutes}
 */
define(['hp/core/Router', 'hp/core/UrlFragment', 'hp/core/Localizer'],
function (router, urlFragment, localizer) { "use strict";

    var ActivityRoutes = ( function() {

        var CONTAINER = '#hp-page-container';

        function ActivityRoutes() {

            var registered = false;

            this.register = function (menuSection) {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('activity', '^/activity' +
                    urlFragment.pagePatternTerminal, {
                    menu: {
                        section: menuSection,
                        label: localizer.getString('core.menu.activity'),
                        location: '/activity',
                        indexCategory: ['alerts', 'tasks']
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/activity/index.html',
                            'fs/view/activity/ActivityView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });
            };
        }

        return new ActivityRoutes();
    }());

    return ActivityRoutes;
});
