// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {WelcomeRoutes}
 */
define(['hp/core/Router', 
'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var WelcomePageRoutes = ( function() {
 
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var AUTH_CATEGORY = 'appliance';

        function WelcomePageRoutes() {

            var registered = false;
            var firstTime = true;
            var networkConfigRetrieved = false;
            var intitalNetworkConfigDone = false;

            function welcomePageFilter(session, settings, result) {
 
                if (!firstTime) {  
                    result.proceed();
                } else {
                    firstTime= false;

                    if (networkConfigRetrieved) {
                        if (intitalNetworkConfigDone) {
                            result.proceed();
                        } else {
                            result.redirectTo('/welcome');
                        }
                    } else {
                        settings.getSetting('setup-network-configured', {
                            success : function(initialNetworkConfigSetting) {
                                intitalNetworkConfigDone =
                                    (initialNetworkConfigSetting.value &&
                                    initialNetworkConfigSetting.value != 'false');
                                networkConfigRetrieved = true;
                                if (intitalNetworkConfigDone) {
                                    result.proceed();
                                } else {                                    
                              result.redirectTo('/welcome');                               
                                }
                            },
                            error : function(errorInfo) {
                                // it is possible a user does not have authorization to retrieve the setting
                                if (! session.canManageCategory(AUTH_CATEGORY)) {
                               // user  doesn't have admin privileges 
                               // such a restricted user could have only been created after the appliance  FTS
                               // hence no need to display Welcome Page
                                   result.proceed();
                                }
                                else {
                                    // Assume the welcome page  has not been visited.
                                    intitalNetworkConfigDone = false;
                                    networkConfigRetrieved = true;
                                    result.redirectTo('/welcome');
                                }
                            }
                        });
                    }
                }
            }

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('welcome page', '^/welcome' + urlFragment.pagePatternTerminal, {
                    menu: {
                        label: 'Setup',
                        location: '/welcome',
                        simpleBanner: false
                    },
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/welcome/index.html',
                            'fs/view/welcome/WelcomeView'], 
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                            // so we will re-load next time through the filter
                            networkConfigRetrieved = false;
                            intitalNetworkConfigDone = false;
                        });
                    }
                });

                router.filter('welcome page filter', '^.*', {
                    check: function (location, result) {
                        require(['hp/model/Session',
                            'fs/services/settings/SettingsService'],
                        function (session, settings) {
                            welcomePageFilter(session, settings, result);
                        });
                    }
                });
            };
        }

        return new WelcomePageRoutes();
    }());

    return WelcomePageRoutes;
});
