// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hp/model/Session',
        'hp/core/Router',
        'jquery'],
function(session, router) {"use strict";

    var StatusRestoreErrorView = ( function() {

        var RESTORE_FAILURE_CLOSE_BUTTON = '#hp-restore-failure-close-button';
            
        /**
         * @class View management for the Login page (singleton).
         * @type {LoginView}
         */
        function StatusRestoreErrorView() {
            
            /**
             * Handler for a click on the restore failure close button.
             */
            function onRestoreFailureCloseButtonClick() {
                router.go('/login', 'login');
                return false;
            }

            /**
             * Initialize the view.
             */
            this.init = function () {
                $(RESTORE_FAILURE_CLOSE_BUTTON).bind('click', function(ev) {
                        onRestoreFailureCloseButtonClick.call(this);
                        ev.preventDefault();
                    });
                $(RESTORE_FAILURE_CLOSE_BUTTON).focus();
            };

            /**
             * Returning to this page after being away.
             */
            this.resume = function() {
                $(RESTORE_FAILURE_CLOSE_BUTTON).focus();
            };

            this.pause = function() {
            };

        }

        return new StatusRestoreErrorView();
    }());
    return StatusRestoreErrorView;
});
