// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(
    [ 'fs/presenter/users/UsersPresenter',
      'hp/view/FormStateView',
      'hp/core/Localizer',
      'hp/core/UrlFragment',
      'hp/model/Session',
      'hp/core/Notifications',
      'jquery',
      'hp/view/ModalDialogView',
      'hp/lib/jquery.hpToggle',
      'jquery',
      'lib/jquery.validate'],

function(presenter, FormStateView, Localizer, urlFragment, session, Notifications) { "use strict";

      var UsersEditView = (function() {

          var FORM = '#cic-user-edit-form',
              EDIT = '#cic-user-edit',
              CANCEL = "#cic-user-edit-cancel",
              ERROR = '#hp-error-text',
              NAME = '#cic-user-loginname',
              FULLNAME = '#cic-user-fullname',
              CURRENT_PASSWD = '#fs-usersettings-currentpasswd',
              NEW_PASSWD = '#cic-user-newpasswd',
              CONFIRM_PASSWD = '#cic-user-confirmpasswd',
              EMAIL = '#cic-user-email',
              OFFICE_PHONE = '#cic-user-officephone',
              MOBILE_PHONE = '#cic-user-mobilephone',
              ROLE_VALIDATOR = '#cic-user-role-validator',
              ROLES_LIST = '#cic-user-roles-list',
              ROLES = ROLES_LIST + ' input[type="checkbox"]',
              HEADER = '#cic-user-edit-header',
              MIN_PASSWORD_LENGTH = 8,
              MAX_NAME_LENGTH = 39,
              INIT_PASSWD_OPTIONAL_HINT = '#fs-user-initpasswd-optional',
              CONFIRM_PASSWD_OPTIONAL = '#fs-user-confirmpasswd-optional',
              NUMBER_OF_ROLES = 2, //For Pulsar
              ROLE_LIST ='#cic-edit-user-roles',
              ROLES_LIST_SELF = '#fs-usersettings-roles-list',
              ROLE_SWITCH = '#cic-edit-user-role-switch',
              ROLE_SELECT_NAME = 'cic-edit-user-role-name',
              ROLE_SWITCH_RADIO = 'input[name=cic-edit-user-role-name]:checked',
              ROLE_SPECIALIZED_CHECKBOXES = "input[type='checkbox'][id^='cic-user-role']",
              SPECIALIZED_VALUE = 'specialized',
              FULL_VALUE = 'full',
              READONLY_VALUE = 'readonly',
              FULL_BUTTONSET = '#cic-edit-user-role-name-full',
              READONLY_BUTTONSET = '#cic-edit-user-role-name-readonly',
              SPECIALIZED_BUTTONSET ='#cic-edit-user-role-name-specialized',
              CURRENT_PWD_DIV= '#fs-currentpasswd-id',
              NEWORINITIALPWD_LABEL='#cic-user-neworinitialpwd';



        /**
         * Constructor
         */
        function UsersEditView() {

            var validator;
            // prevent double click
            var isSubmitted;
            var formStateView = new FormStateView();
            var firstRoleTemplate = null, roleTemplate = null;
            var canModifyAnyUser = false;
            var isSpecialized;
            var userLoggedIn = '' ;
            var twoRoles = false;
            var taskName ;
            var numberOfClicks = 0;
            var isSelf = false;

            /**
             * @private
             */
            function checkRoles() {
                var result = false;
                if(isSelf){
                  result = true;
                }else{
                    if (isSpecialized ) {
                        $(ROLES).each(function(index, role) {
                            if ($(role).is(':checked')) {
                                result = true;
                            }
                        });
                    }else {
                        result = true;
                    }
                }
                return result;
            }

            /**
             * @private
             */
            function onSpecializedUserClick() {
                isSpecialized = true;
                $(SPECIALIZED_BUTTONSET).attr("checked", true);
                $(ROLES_LIST).show();
            }

            /**
             * @private
             */
            function onFullOrReadonlyUserClick() {
                isSpecialized = false;
                $(ROLES_LIST).hide();
            }

            /**
             * set the roles retrieved from database
             * @param retrievedRoles
             */
            function userRoleChangedSelf(retrievedRoles) {

                var retrievedRolesList = (retrievedRoles.hasOwnProperty('members') ?
                        retrievedRoles.members : retrievedRoles);
                var rolesList = $(ROLES_LIST_SELF);
                rolesList.empty();
                $.each(retrievedRolesList, function(index, role) {
                    var correctCaseRole = '';
                    var splitRole = (role.roleName ? role.roleName.replace(/_/, ' ') : 'noname').split(' ');
                    $.each(splitRole, function(idx, word) {
                        if(idx !=0){
                            correctCaseRole = correctCaseRole +' '+ word.toLowerCase();
                        }else{
                            correctCaseRole = correctCaseRole + word;
                        }
                    });
                    var label = $('<label/>');
                    label.text(correctCaseRole);
                    rolesList.append(label);
                    if (index !== retrievedRolesList.length - 1){
                        $('<br/>').appendTo(rolesList);
                    }
                });
            }


            /**
             * @private Function that retrieves the roles currently displayed user
             * in master pane and details page, and updates the values in edit page html.
             */
            function userRoleChanged(theRolesList) {
                var roleList = presenter.getRetrievedRoles()? presenter.getRetrievedRoles() : theRolesList;
                if (isSelf){
                    userRoleChangedSelf(roleList);
                }else{
                    var roles = (roleList.hasOwnProperty('members') ? roleList.members : roleList);

                    $.each(roles, function(index, theRole) {
                        var userRole = theRole.roleName ? theRole.roleName.replace(/_/, ' ') : 'noname';
                        if (twoRoles){
                            $('#'+userRole.replace(' ','-')).attr("checked", true); //the id is the orole name as in DB - spaces repalced by hyphen
                        }else if (userRole === Localizer.getString('fs.users.common.infrastructure_administrator')){
                            onFullOrReadonlyUserClick();
                            $(FULL_BUTTONSET).attr("checked", true);
                        }else if (userRole === Localizer.getString('fs.users.common.read_only')){
                            onFullOrReadonlyUserClick();
                            $(READONLY_BUTTONSET).attr("checked", true);
                        }
                        else{
                            onSpecializedUserClick();
                            $(SPECIALIZED_BUTTONSET).attr("checked", true);
                            $(ROLES).each(function(index, role) {
                                if ($(role).val().toLowerCase() === userRole.toLowerCase()) {
                                    $(role).attr("checked", true);
                                }
                            });
                        }
                    });
                }
            }

            /**
             * @private To construct the roles section in the page,
             * based on what roles are available in the appliance
             */
            function updateRoles() {
                if(isSelf)
                {
                    $(ROLE_SWITCH).hide();
                    $(ROLE_LIST).hide();
                    $(ROLES_LIST_SELF).show();
                }
                else{
                    var roles = presenter.getRoles(),
                        rolesList = $(ROLES_LIST);

                    $(rolesList).empty();

                    $(ROLE_SWITCH).show();
                    $(ROLE_LIST).show();
                    $(ROLES_LIST_SELF).hide();

                    if (roles.length == NUMBER_OF_ROLES){
                        twoRoles = true;
                        isSpecialized = true;
                        $(ROLE_SWITCH).empty();
                    }
                    var counter = 0;//counter as in else case case we need to know the right order

                    $.each(roles, function(index, role) {//iterating through all available roles
                        var theRoleName =  role.roleName ? role.roleName.replace(/_/, ' ') : 'noname';
                        var correctCaseRole = '';
                        var splitRole = role.roleName.replace(/_/, ' ').split(' ');
                        $.each(splitRole, function(key, word) {
                            if(key !=0){
                                correctCaseRole = correctCaseRole +' '+ word.toLowerCase();
                            }else{
                                correctCaseRole = correctCaseRole + word;
                            }
                        });
                        if(twoRoles){//Pulsar has only 2 roles
                            var radio = $("<input type='radio'>");
                            var id = theRoleName.replace(' ','-');//id is the role as in DB, space replaced by hyphen
                            radio.attr("name", ROLE_SELECT_NAME)
                                 .attr("id", id)
                                 .attr("value", theRoleName);
                            var label = $('<label/>');
                            label.attr("for", id);
                            label.text(correctCaseRole);
                            $(ROLE_SWITCH).append(radio);
                            $(ROLE_SWITCH).append(label);
                            if (index !== roles.length - 1){
                               $(ROLE_SWITCH).append($('<br/>'));
                            }
                        }else {
                              //because full and read only are in the toggle
                              if (role.roleName !== 'No_Privileges' &&
                                  role.roleName !== Localizer.getString('fs.users.common.infrastructure_administrator') &&
                                  role.roleName !== Localizer.getString('fs.users.common.read_only')) {

                                  var item = (counter === 0) ? firstRoleTemplate.clone() : roleTemplate.clone();
                                  var idChkbox = 'cic-user-role-' + counter;
                                  var labelChkbox = correctCaseRole;
                                  item.attr('id', '');
                                  item.show();
                                  $('input[type="checkbox"]', item).attr('id', idChkbox)
                                      .val(role.roleName)
                                      .attr('name', role.roleName);
                                  $('label:eq(1)', item).text(labelChkbox)
                                      .attr('for', idChkbox);
                                  rolesList.append(item);

                                  if (counter === 0) {
                                      $(ROLE_SPECIALIZED_CHECKBOXES).change(function(){
                                          if(checkRoles()){
                                              $(ROLE_VALIDATOR).next().hide();//the auto generated error label
                                          }
                                      });
                                      $(ROLE_VALIDATOR).rules("add", { userRoleValidation : ROLE_VALIDATOR });
                                  }
                                  counter = counter + 1;
                              }
                          }
                      });
                      if (twoRoles){
                          $(ROLE_LIST).empty(); //dont show the list of checkboxes
                      }
                  }
                  if(presenter.getRetrievedRoles()){//set the roles if available in resource
                      userRoleChanged();
                  }
                  formStateView.reset();
            }

            /**
             * @private
             */
            function reset() {
                $(NAME).val("");
                $(FULLNAME).val("");
                $(NEW_PASSWD).val("");
                $(CONFIRM_PASSWD).val("");
                if (isSelf){
                    $(CURRENT_PASSWD).val("");
                }
                $(EMAIL).val("");
                $(OFFICE_PHONE).val("");
                $(MOBILE_PHONE).val("");
                $(ROLES).prop("checked", false);
                validator.resetForm();
                formStateView.reset();
                numberOfClicks = 0;
                isSubmitted = false;
                isSelf = false;
                updateRoles();
            }

            /**
             * Get all other users logged in
             */

            function otherUserLoggedIn(){
                var list = presenter.getOtherUsersLoggedInList();
                var count = list.length;
                var reterivedUser = presenter.getRetrievedUser().userName;
                var status = false;

                for ( var i = 0; i < count; i++) {
                    if(list[i] == reterivedUser){
                        status =true;
                        userLoggedIn = reterivedUser;
                    }
                }
                return status;
            }

            function onUserModifiedSuccess(user) {
                var username, alertMsg;
                username = user.userName;
                alertMsg = Localizer.getString('fs.users.edit.success', [ username ]);
                formStateView.setMessage({summary:alertMsg, status:'ok', changing : false});
                reset();
                //window.location = '#/user/show';
                presenter.getUser(user.userName);
                //because after notification message is shown, the show page
                //does not refresh to show new data

                if(presenter.getOtherUsersLoggedInList().length > 0 && otherUserLoggedIn()){
                    alertMsg += Localizer.getString('fs.users.common.loggedIn');
                    userLoggedIn = '';
                }

                var userEditComplete = {
                    summary : alertMsg,
                    uri : taskName,
                    changing : true,
                    status : "ok"
                };
                Notifications.add(userEditComplete, true);
                $(CANCEL).trigger('click');

            }

            /**
             * @private
             */
            function onUserModifiedError(errorMessage) {
                var modifyMsg = Localizer.getString('fs.users.edit.error', [$(NAME).val()]);
                var errorMsg = Localizer.formatRestError(modifyMsg,
                        errorMessage);
                formStateView.setMessage({summary: modifyMsg, status: 'error',
                    errorMessage: errorMessage});
                var userEditError = {
                    summary : modifyMsg,
                    uri : taskName,
                    changing : false,
                    status : "error",
                    details : errorMsg
                };
                Notifications.add(userEditError, true);
                isSubmitted = false;
            }

            /**
             * @private
             */
            function onEditUserClick() {

                if ($(FORM).valid() && isSubmitted == false) {
                  numberOfClicks = numberOfClicks + 1 ;
                    isSubmitted = true;
                    var alertMsg = Localizer.getString('fs.users.edit.editMsg', [ $(NAME).val() ]);
                    formStateView.setMessage({summary:alertMsg, status:'info', changing : true});
                    if(numberOfClicks == 1){
                        taskName = $(NAME).val() +'-editUserTask-' + (new Date()).getTime();
                    }
                    var userEditProgress = {
                        summary : alertMsg,
                        uri : taskName,
                        changing : true,
                        status : "info"
                    };
                    Notifications.add(userEditProgress, false);
                    var roles = [];
                    var replace = false;
                    var caller ;
                    var currentPassword = null;
                    if(isSelf){
                        currentPassword = $(CURRENT_PASSWD).val();
                        caller = "self";
                    }else{
                        if (twoRoles){
                            roles.push($(ROLE_SWITCH_RADIO).val());
                        }
                        else if(isSpecialized)
                        {
                            $(ROLES).each(function(index, role) {
                                if ($(role).is(':checked')) {
                                    roles.push($(role).val());
                                }
                            });
                        }
                        else if($(ROLE_SWITCH_RADIO).val() === FULL_VALUE){
                            roles.push(Localizer.getString('fs.users.common.infrastructure_administrator'));
                        }else if ($(ROLE_SWITCH_RADIO).val() === READONLY_VALUE){
                            roles.push(Localizer.getString('fs.users.common.read_only'));
                        }

                         replace = presenter.isReplace(roles);
                         caller = "other";
                    }
                    //current password is null
                    presenter.modifyUser($(NAME).val(), $(FULLNAME).val(), currentPassword,
                            $(NEW_PASSWD).val(), roles, $(EMAIL).val(), $(
                            OFFICE_PHONE).val(), $(MOBILE_PHONE).val(), replace, caller);

                }

                return false;
            }


            /**
             * @private
             */
            function userRolesError(errorMessage) {
                var roleMsg = Localizer.getString('fs.users.show.roleserror');
                formStateView.setMessage({summary: roleMsg, status: 'error',
                    errorMessage: errorMessage});
            }

            /**
             * called when selected user in masterpane changes
             * @param user
             */
            function userChanged(userObj) {
                isSpecialized = true;
                presenter.usersLoggedIn();
                var user = presenter.getRetrievedUser()?presenter.getRetrievedUser() : userObj;

                if(user.userName.toLowerCase() === session.getUser().toLowerCase()){
                    isSelf = true;
                    $(CURRENT_PWD_DIV).show();
                    $(NEW_PASSWD).val("");
                    $(CONFIRM_PASSWD).val("");
                    $(NEWORINITIALPWD_LABEL).text(Localizer.getString("fs.users.edit.newpasswd"));
                    $(CONFIRM_PASSWD_OPTIONAL).hide();
                    $(INIT_PASSWD_OPTIONAL_HINT).hide();
                }else{
                    isSelf = false;
                    $(CURRENT_PWD_DIV).hide();
                    $(NEW_PASSWD).val("********");
                    $(CONFIRM_PASSWD).val("********");
                    $(NEWORINITIALPWD_LABEL).text(Localizer.getString("fs.users.add.initialpasswd"));
                    $(INIT_PASSWD_OPTIONAL_HINT).removeAttr("style");//unhiding, not forcing a show()
                    $(CONFIRM_PASSWD_OPTIONAL).show();
                }
                $(HEADER).html(Localizer.getString('fs.users.edit.link')+' '+user.userName);
                $(ERROR).hide();
                $(NAME).val(user.userName);
                $(FULLNAME).val(user.fullName);
                $(NAME).prop("disabled", "true");
                $(EMAIL).val(user.emailAddress);
                $(OFFICE_PHONE).val(user.officePhone);
                $(MOBILE_PHONE).val(user.mobilePhone);
                $(FORM).show();
            }


            /**
             * @private
             * called when own profile must be edited- event is caught
            */
            function myUserChangedSuccess(user) {
                userChanged(user);
                updateRoles();
            }

            /**
             * @private
             */
            function myUserChangedError(errorMessage) {
                var userMsg = Localizer.getString('fs.users.show.error');
                formStateView.setMessage({summary: userMsg, status: 'error',
                    errorMessage: errorMessage});
            }

            function initForm() {

                isSubmitted = false;
                var validRoleValidation = Localizer.getString('fs.users.validations.roleValidation');
                var validMatchPasswd = Localizer.getString('fs.users.edit.matchpasswd');
                var validPasswdLength = Localizer.getString('fs.users.validations.checkLength');
                var validPhoneNum = Localizer.getString('fs.users.validations.phonenumValidation');
                var validPassword = Localizer.getString('fs.users.validations.passwordValidation');
                var validFullname = Localizer.getString('fs.users.validations.fullnameValidation');
                var validCurrentPasswd = Localizer.getString('fs.users.validations.matchcurrpasswd');
                var fieldRequired = Localizer.getString('fs.users.validations.fieldRequired');

                validator = $(FORM).validate({
                    rules : {
                        fullname : {
                            cicUserEditFullNameCheck : FULLNAME,
                            maxlength : MAX_NAME_LENGTH
                        },
                        email : {
                            email : EMAIL
                        },
                        currentpasswd : {
                            cicUserSelfEditCheckPasswdString : CURRENT_PASSWD,
                            cicUserSelfEditCheckCurrPass : CURRENT_PASSWD
                        },
                        newpasswd : {
                            cicUsersEditCheckPasswdString : NEW_PASSWD,
                            cicUsersEditCheckPwdLength : MIN_PASSWORD_LENGTH,
                            cicUserSettingsEditCheckReqd : NEW_PASSWD
                        },
                        confirmpasswd : {
                            cicUsersEditMatchPasswd : NEW_PASSWD
                        },
                        officephone : {
                            cicUsersEditPhoneNumCheck : OFFICE_PHONE
                        },
                        mobilephone : {
                            cicUsersEditPhoneNumCheck : MOBILE_PHONE
                        }
                    }
                });

                $.validator.addMethod("userRoleValidation", function(value, element, param) {
                    return checkRoles();
                }, validRoleValidation);

                //No special characters allowed <>;,"'&\/|+.:
                $.validator.addMethod("cicUserSelfEditCheckPasswdString",
                    function(value, element, param) {
                        var result = true;
                        if(isSelf){
                            var isValidPwd = /^[^<>;,"'&\\\/|+:= ]+$/.test(value);
                            result = (value.length == 0 || isValidPwd);
                            if(!result){
                                $(CONFIRM_PASSWD_OPTIONAL).hide();
                            }
                        }
                        return result;
                    },
                validPassword);

                //check current password
                $.validator.addMethod("cicUserSelfEditCheckCurrPass",
                    function(value, element, param) {
                        var result = true;
                        if (isSelf && value.length == 0 &&
                            ((($(NEW_PASSWD).val() && $(NEW_PASSWD).val().length > 0)) ||
                                ($(CONFIRM_PASSWD).val() && ($(CONFIRM_PASSWD).val().length >0)))){
                            result = false;
                            $(CONFIRM_PASSWD_OPTIONAL).hide();
                        }
                        return result;
                    },
                validCurrentPasswd);

                $.validator.addMethod("cicUserSettingsEditCheckReqd",
                    function(value, element, param) {
                        var result = true;
                        if (isSelf){
                            if (value.length == 0 &&
                                ((($(CURRENT_PASSWD).val() && $(CURRENT_PASSWD).val().length > 0)) &&
                                    ($(CONFIRM_PASSWD).val() && ($(CONFIRM_PASSWD).val().length >0)))){
                                result = false;
                            }
                        }
                        return result;
                    },
                    fieldRequired);

                // check for fullname contain letters ' . - and space
                $.validator.addMethod("cicUserEditFullNameCheck",
                    function(value, element, param) {
                        var isValidFullname = /^[a-zA-Z0-9 ._'\-]+$/.test(value);
                        return (isValidFullname || value.length == 0);
                    },
                validFullname);

                jQuery.validator.addMethod("cicUsersEditMatchPasswd", function(value, element, param) {
                    // bind to the blur event of the target in order to revalidate whenever the target field is updated
                    var target = $(param).unbind(".validate-equalTo")
                        .bind("blur.validate-equalTo", function() {
                            $(element).valid();
                        });
                    var result = (value == target.val());
                    if(!result){
                      $(CONFIRM_PASSWD_OPTIONAL).hide();
                    }
                    return result;
                    },
                validMatchPasswd);

                //function to check length of password. Since it is optional field,
                //user can leave the dummy value there and modify other details.
                //If he removes the dummy characters somehow, it will still not prompt for pwd
                jQuery.validator.addMethod("cicUsersEditCheckPwdLength", function(
                        value, element, param) {
                    return ((value.length >= 8) || (value.length == 0));
                    },
                validPasswdLength);

                // check for  special characters
                jQuery.validator.addMethod("cicUsersEditPhoneNumCheck", function(value,
                    element, param) {
                    var isValidPh = /^[^"'&=<>]+$/
                        .test(value);
                    return (value.length == 0 || isValidPh);
                    },
                validPhoneNum);

                //No special characters allowed <>;,"'&\/|+.:
                jQuery.validator.addMethod("cicUsersEditCheckPasswdString", function(
                    value, element, param) {
                    var isValidPwd = (/^[^<>;,"'&\\\/|+:= ]+$/.test(value));
                    if(isSelf){
                        return (value.length == 0 || isValidPwd);
                    }else{
                        return isValidPwd;
                    }
                },
                validPassword);
            }

            function displayRoles() {
                if ($(ROLE_SWITCH_RADIO).val() === SPECIALIZED_VALUE){
                    onSpecializedUserClick();
                }
                else{
                    onFullOrReadonlyUserClick();
                }
            }

            function registerEvents() {
                //presenter.on("rolesChanged", updateRoles);
                presenter.on("userChangedSuccess", myUserChangedSuccess);
                presenter.on("userChangedError", myUserChangedError);
                presenter.on("userRoleChanged", userRoleChanged);
                presenter.on("userRolesError", userRolesError);
                presenter.on("userModifiedSuccess", onUserModifiedSuccess);
                presenter.on("userModifiedError", onUserModifiedError);
                presenter.on("userSelfModifiedSuccess", onUserModifiedSuccess);
                presenter.on("userSelfModifiedError", onUserModifiedError);


            }

            function removeEvents() {
                //presenter.off("rolesChanged", updateRoles);
                presenter.off("userChangedSuccess", myUserChangedSuccess);
                presenter.off("userChangedError", myUserChangedError);
                presenter.off("userRoleChanged", userRoleChanged);
                presenter.off("userRolesError", userRolesError);
                presenter.off("userModifiedSuccess", onUserModifiedSuccess);
                presenter.off("userModifiedError", onUserModifiedError);
                presenter.off("userSelfModifiedSuccess", onUserModifiedSuccess);
                presenter.off("userSelfModifiedError", onUserModifiedError);
            }

            /**
             * @public
             */

            this.init = function() {
                // Remove the template for a role from the DOM (used for
                // cloning later)
                firstRoleTemplate = $('#cic-user-first-role-template')
                .detach();
                roleTemplate = $('#cic-user-role-template').detach();
                initForm();

                formStateView.init({
                    form : FORM,
                    autoTrack : true
                });
                isSpecialized = true;
                $(ROLES_LIST).show();

                //check if session user can perform this action
                canModifyAnyUser = session.canPerformAction("users", "Update");

                $(EDIT).on('click', function(ev) {
                    onEditUserClick();
                    ev.preventDefault();
                });

                $(ROLE_SWITCH).buttonset();
                $(ROLES_LIST).show();
                onSpecializedUserClick();

                $(ROLE_SWITCH).change(function() {
                   displayRoles();
                   if(checkRoles()){
                       $(ROLE_VALIDATOR).next().hide();//the auto generated error label
                   }
                });

                $(CANCEL).on('click', function(ev) {
                    isSubmitted = true;
                });

                presenter.selectionChange();
                registerEvents();
            };


            /**
             * @public
             */
            this.resume = function() {
                reset();
                onSpecializedUserClick();
                presenter.selectionChange();
                registerEvents();
            };

            this.pause = function() {
                removeEvents();
                formStateView.reset();
            };

          }

          return new UsersEditView();
      }());

    return UsersEditView;
});
