// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['jquery'], function() {
    (function($) {
        // jQuery plugin definition
        $.fn.hpProgressBar = function(options) {
          
            function hpProgressBar(elem) {
              
                var container;
                var done;
                
                function update(percentDone) {
                    if (percentDone > 100) {
                        percentDone = 100;
                    } else if (percentDone < 0) {
                        percentDone = 0;
                    }
                    done.css('width', percentDone + '%');
                }
                
                function build() {
                    container.addClass('hp-progress');
                    done = $('.hp-progress-done', container);
                    if (done.length === 0) {
                        container.append($('<div class="hp-progress-done"></div>'));
                        done = $('.hp-progress-done', container).css('width', '0px');
                    }
                }

                function initialize() {
                    container = $(elem);
                    build();
                    if (options && 'number' === typeof(options)) {
                        update(options);
                    } else if (container.attr('data-percent')) {
                        update(container.attr('data-percent'));
                    }
                }
                
                initialize();
            }
            
            // pluginify
            var ret;
            var instance = null;
            this.each(function() {
                var $elem = $(this);
                instance = new hpProgressBar($elem[0]);
                ret = ret ? ret.add($elem) : $elem;
            });
            return ret;
        };
    }(jQuery));
});
