// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type {ModalDialogView}
 */
define(['hp/core/UrlFragment',
        'hp/core/Notifications',
        'hp/core/Localizer',
        'text!hpPages/core/modal-dialog.html',
        'jquery',
        'hp/lib/jquery.hpCollapsible'],
function(urlFragment, notifications, Localizer, dialogHtml) {"use strict";

    var ModalDialogView = (function () {

        var 
        SPINNER = '#hp-modal-dialog-spinner',
        NOTIFY_BOX = '#hp-modal-dialog-details-notify',
        NOTIFY_MSG = '#hp-modal-dialog-details-notify-message',
        NOTIFY_CLASS='hp-details-notify',
        DIALOG_MESSAGE = '#hp-modal-dialog-message';

        var container,
            confirmFunction,
            cancelFunction;

        function ModalDialogView() {
            /**
             * update the notification bar
             */
            function updateNotify(msgText, type) {
                if (msgText) {
                    $(NOTIFY_BOX).attr('class', NOTIFY_CLASS + ' ' + NOTIFY_CLASS + '-' + type);
                    $(NOTIFY_MSG).html(msgText);
                    $(NOTIFY_BOX).slideDown('slow');
                    $(NOTIFY_BOX).show();
                }
                else {
                    $(NOTIFY_BOX).slideUp('fast');
                    $(NOTIFY_BOX).hide();
                }
            }


            /**
             * @public
             *
             * This causes the dialog box to be displayed on the screen. It takes a number of
             * possible arguments that adjust the text being used within the dialog including
             * warning information, informational text and button data.
             */
            this.showDialog = function(args) {

                updateNotify(args.notification, "warning");
                $(DIALOG_MESSAGE).html(args.message);
                confirmFunction = args.confirmFunction;
                cancelFunction = args.cancelFunction;


                $(SPINNER).hide();
                $(container).dialog({
                    modal:true,
                    position : "center",
                    draggable : false,
                    resizable : false,
                    dialogClass: 'hp-simple-dialog',
                    buttons: [{
                        text: args.confirmButton,
                        click: function(){
                            $(container).dialog("close");
                            if (confirmFunction){
                                confirmFunction(args.confirmFunctionParameters);
                            }
                        }}, {
                        text: args.cancelButton,
                        click: function(){
                            $(container).dialog("close");
                            if (cancelFunction) {
                                cancelFunction(args.cancelFunctionParameters);
                            }
                        }
                    }]
                });
            };

            this.init = function () {
                var html;
                if ($(container).length === 0){

                    container = document.createElement('div');
                    $(container).appendTo("body");

                    //load the delete dialog html and setup events
                    $(container).css("display","none");
                    html = $(dialogHtml);
                    Localizer.localizeDom(html);
                    $(container).append(html);

                }

            };
        }
        return new ModalDialogView();

    }());
    return ModalDialogView;
});
