// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/* This is a Resource object for Nodes resource.
 * The resource object created for particular type of resource and association with other resources.
 */
define(['hp/model/Resource',
'hp/services/IndexService',
'hp/core/EventDispatcher',
'hp/services/REST',
'hp/model/Session'
],
function(Resource,indexService,eventDispatcher,restService,session) {"use strict";
	
	var NodeResource = (function(){
		
		function NodeResource() {
			var prefix = '/hpsum';
			var nodeResource;
			//Derive from Resource
			var category= ['windows','linux','hpux','vmware','enclosure','switch','fc_switch','host','rack','unknown'];
			 Resource.call(this, category);
			 var index;
			function hoursAgo(hours) {
                var now = new Date();
                return new Date(now.getTime() - (1000 * 60 * 60 * hours));
            }
			 
			 nodeResource =this;
			 this.category='nodes';
			 // Inits nodes for mockup

			function OnAddNodeSuccess(data,item){
				
				var notDetails={
			 		summary:null,
			 		details:null
			 	};
				var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
				var alert = $.extend({name: 'Added '+item.name,
                uri: '/alert/alert-t1',
                status: 'info', owner: session.getUser(), state: 'active',
                date: hoursAgo(36).toISOString()}, alertTemplate);
                //indexService.addItem('alert', alert);
                item.index = data.hapi.node_id;
                if(item.username && item.password)
                	item.state = 'scouting';
                else {	
                	item.state = 'init';
                	notDetails.summary='Need Credentials';
			 		notDetails.details= '<p><a href="#/node/edit/credentials"> Need Credentials</a>.</p>';
                }  
                item.stateDetails=notDetails,
                item.uri = '/Session/'+session.getToken() + '/Node/' + data.hapi.node_id + '/getdata';
                //indexService.addItem(item.category,item);
                //nodeResource.fire("selectionChange", {uris: item.uri});

				
			}
			
			function OnAddNodeFailed(data,item){
				
				var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
				
				var alert = $.extend({name: 'Add Failed '+item.name,
                uri: '/alert/alert-t1',
                status: 'info', owner: session.getUser(), state: 'active',
                date: hoursAgo(36).toISOString()}, alertTemplate);
                //indexService.addItem('alert', alert);
			}
			 
			 this.addNode = function(item, handlers){

			 	/*
			 	if(!baseline || !username || !password) {
			 		if(!baseline && !username && !password){
			 			notDetails.summary='Need Credentials and Baseline';
			 			notDetails.details= '<p><a href="#/node/edit/baseline"> Need Credentials and Baseline</a>.</p>';
			 		}
			 		else if(!baseline){
			 			notDetails.summary='Need Baseline';
			 			notDetails.details= '<p><a href="#/node/edit/baseline"> Need Baseline</a>.</p>';			 			
			 		}else {
			 			notDetails.summary='Need Credentials';
			 			notDetails.details= '<p><a href="#/node/edit/credentials"> Need Credentials</a>.</p>';
			 		}
			 		
			 		
			 	}*/
			 	/*var item = indexService.addItem(type, {
                        category: type,
                        name: name,
                        uri: '/' + type + '/item' + index,
                        status: status,
                        nodeType:nodeType,
                        baseline: baseline,
                        changing: ((index % 3) === 0),
                        updatedAt: (new Date()).toISOString(),
                        state: 'init',
                        stateDetails: notDetails,
                        index: this.index,
                        attributes: {}
                    });
                var baselineuri = '/baseline/item' + item.baseline;
               indexService.getIndexForResource(baselineuri, {
                	success: function(baselineobj){
                		if(baselineobj)
                			indexService.addAssociation('BASELINE_TO_NODE', baselineobj, item);
                	},
                	error: function (){
                		
                	}
                	
                });*/
                
                    
					var alertTemplate = {
                        category: 'alert',
                        sourceUri: item.uri,
                        sourceName: item.name,
                        notes: []
                    };
                    
                    var object ={
                    	hapi: {
                    		ip: item.name,
							name: item.name,
                    		type: item.category,
                            description:item.description,
                    		node_skip: item.node_skip,
                    		baselines: {
                    		baseline: item.baseline,
                    		},
							use_sudo: item.use_sudo,
                    		su_username: item.su_username,
                    		su_password: item.su_password,
                    		associated_node : item.associated_node,
							auto_add_assoc_nodes: item.auto_add_assoc_nodes,
                    		username: item.username,
                    		password: item.password
            			}
            			};
                    var options = {
                    	encodeResults: false,
                    	encodeErrors: false
                    };
                    var sessionurl = '/session/'+session.getToken();
					restService.postObject( sessionurl + '/node/add', object,{
						success: function(data){						
								OnAddNodeSuccess(data,item);
								handlers.success(data);
                   	},
                   		error: function () {
                   			var alert = $.extend({name: 'Add Failed '+item.name,
                        	uri: '/alert/alert-t1',
                        	status: 'failed', owner: 'Mathews', state: 'active',
                        	date: hoursAgo(36).toISOString()}, alertTemplate);
                   			indexService.addItem('alert', alert);
                   		}
                 }, options);
			 };
			 
			 this.init =function(count){
			 	 var i, status, name, item,description, nodeType,prefix='Node';
			 	index =1001;
                indexService.addCategory('unknown');
                indexService.addCategory('windows');
                indexService.addCategory('linux');
                indexService.addCategory('hpux');
                indexService.addCategory('switch');
                indexService.addCategory('enclosure');
                indexService.addCategory('fc_switch');
                indexService.addCategory('host');
                                
                for (i = 1; i <= count; i += 1) {
                    name = prefix + ' ' + i;
                    // make most 'ok'
                    if (i % 1 === 0) {
                        status = ['all', 'scanning', 'scan-complete', 'scheduled','web','error'][i % 6];
                    } else {
                      //name += ' make it much longer to see what happens'; /// !!!
                        status = 'ok';
                    }
                    description = name;
                    nodeType = 'Windows Server';
                   // this.addNode(name, description, status, nodeType,1);

                }
			 	
			 };
			
		}
		return new NodeResource();
	}());
    return NodeResource;
});
