// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/type/TypePresenter',
    'jquery',],
function(presenter, urlFragment) { "use strict";

    var TypeShowBandwidthView = (function() {
      
        var LIST = '#tour-slots',
            ITEM_TEMPLATE = '#tour-slot-template',
            TABLE = '.tour-slot-ports',
            ROW_TEMPLATE = '#tour-slot-port-template';
      
        /**
         * Constructor
         */
        function TypeShowBandwidthView() {
          
            var slots = ['Embedded', 'Slot 1', 'Slot 2', 'Slot 3', 'Slot 4'];
          
            /**
             * @public
             */
            this.init = function() {
                var slotIndex, li, rowIndex, tr;
                for (slotIndex = 0; slotIndex < slots.length; slotIndex += 1) {
                    li = $(ITEM_TEMPLATE).clone().show();
                    $('h2', li).html(slots[slotIndex]);
                    $('h3', li).html('Long Model Description');
                    
                    for (rowIndex = 0; rowIndex < 4; rowIndex += 1) {
                        tr = $(ROW_TEMPLATE).clone().show();
                        $('.tour-slot-port-name', tr).html('Port ' + (rowIndex + 1));
                        $(TABLE, li).append(tr);
                    }
                    
                    $(LIST).append(li);
                }
            };
        }

        return new TypeShowBandwidthView();
    }());
    
    return TypeShowBandwidthView;
});
