// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router',
        'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ApplianceRoutes = ( function() {

        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view';
        var CONTAINER = '#hp-settings-page';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var AUTH_CATEGORY = 'appliance';
        var CONFIRM_CONTAINER = '#hp-dialog-container';

        function ApplianceRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings show appliance *',
                    '/settings/show/appliance/(general|IPv4|DNS|IPv6|timeandplace|backup)' + urlFragment.viewPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/appliance/more.html',
                                 'fs/view/settings/appliance/ApplianceMoreView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.filter('settings show appliance default redirector',
                    '/settings/show/appliance' + urlFragment.viewPatternTerminal, {
                    check: function(location, result) {
                        result.replaceWith(urlFragment.replaceView(location, 'show/appliance/general'));
                    }
                });

                router.map('settings edit network', '/settings/edit/network(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/network/edit.html',
                            'fs/view/settings/network/NetworkEditView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings update appliance', '/settings/update/appliance$', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/appliance/update.html',
                            'fs/view/settings/appliance/ApplianceUpdateView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });


                router.map('settings update appliance progress', '/settings/update/progress$', {
                    menu: {
                        simpleBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/appliance/result.html',
                            'fs/view/settings/appliance/ApplianceUpdateProgressView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings update eula', '/settings/update/eula$', {
                    menu: {
                        noBanner: true
                    },
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/login/eula.html',
                            'fs/view/settings/appliance/ApplianceUpdateEulaView'],
                        function (page, view) {
                          result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

            };
        }

        return new ApplianceRoutes();
    }());

    return ApplianceRoutes;
});
