// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var ApplianceShutdownRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'appliance';

        function ApplianceShutdownRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings appliance shutdown', '/settings/shutdown/applianceShutdown(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {     
                        require(['text!hpPages/settings/shutdown/applianceShutdown.html',
                            'hp/view/settings/shutdown/ApplianceShutdownView' ],                                                    
                        function (page, view) {                                                       
                            view.setOption({option : 'shutdown' });    
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                
                router.map('settings appliance shutdown', '/settings/shutdown/applianceRestart(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {     
                        require(['text!hpPages/settings/shutdown/applianceShutdown.html',
                            'hp/view/settings/shutdown/ApplianceShutdownView' ],                                                    
                        function (page, view) {                                                       
                            view.setOption({option : 'restart' });    
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });                
            };
        }

        return new ApplianceShutdownRoutes();
    }());

    return ApplianceShutdownRoutes;
});
