// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/EventDispatcher',
        'fs/services/settings/ApplianceUpdateService',
        'hp/model/Session',
        'jquery'],
    function(EventDispatcher, service, session) {"use strict";
    var ApplianceUpgradeResource = ( function() {
        function ApplianceUpgradeResource() {

            var dispatcher = new EventDispatcher();

            /*
                updateState variable - will hold the state of the update process.
                0 - represents the eula is not accepted yet.
                1 - represents eula accepted and get other users logged in.
                2 - represents the update progress state.
            */
            var updateState;
            var rebootRequired=false;
            var otherLoggedInUsersList = [];
            var fileName;
            var estimatedUpgradeTime;

            function getOtherUsersLoggedIn(loggedInUsersData) {
                var currentUser = '';
                var count = 0;
                var userSet = {};

                if (loggedInUsersData.count > 0) {
                    currentUser = session.getUser();
                    currentUser = (currentUser !=null)? currentUser.toLowerCase():currentUser;
                    for ( var i = 0; i < loggedInUsersData.members.length; i++) {
                        var loggedInUser = loggedInUsersData.members[i].username.toLowerCase();
                        // creating a set to avoid duplicate elements.
                        if (!userSet[loggedInUser]) {
                            userSet[loggedInUser] = true;
                            if (loggedInUser !== currentUser) {
                                otherLoggedInUsersList[count] = loggedInUser;
                                count++;
                            }
                        }
                    }
                }
            }

            this.getFileName = function(){
                return fileName;
            };

            this.setFileName = function(data){
                fileName = data;
            };

            this.getEstimatedUpgradeTime = function(){
                return estimatedUpgradeTime;
            };

            this.setEstimatedUpgradeTime = function(data){
                estimatedUpgradeTime = data;
            };

            this.on = function(eventName, callback) {
                dispatcher.on(eventName, callback);
            };

            this.off = function(eventName, callback) {
                dispatcher.off(eventName, callback);
            };

            function onUsersLoggedInListSuccess(data) {
                getOtherUsersLoggedIn(data);
                dispatcher.fire('usersLoggedInSuccess', data);
            }

            function onUsersLoggedInListError(errorInfo) {
                dispatcher.fire('usersLoggedInError', errorInfo);
            }

            this.getRebootRequired = function() {
                return rebootRequired;
            };

            this.setRebootRequired = function(value) {
                rebootRequired = value;
            };

            this.getUpdateState = function() {
                return updateState;
            };

            this.setUpdateState = function(state) {
                updateState = state;
            };

            this.clear = function() {
                otherLoggedInUsersList = [];
                updateState = 0;
            };

            this.usersLoggedIn = function() {
                service.usersLoggedIn({
                    success : onUsersLoggedInListSuccess,
                    error : onUsersLoggedInListError
                });
            };

            this.getOtherUsersLoggedInList = function() {
                return otherLoggedInUsersList;
            };

        }

        return new ApplianceUpgradeResource();

    }());

    return ApplianceUpgradeResource;

});
