// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.

define(['fs/model/activity/ActivityResource',
    'hp/core/EventDispatcher'], 
function(resource, EventDispatcher) {"use strict";

    var ActivityPresenter = ( function() {

        /**
         * @constructor
         * @type {ActivityPresenter}
         */
        function ActivityPresenter() {

            var dispatcher = new EventDispatcher();

            /**
             * @public
             */
            this.init = function () {
            };
            
            this.resource = function () {
                return resource;
            }
            
            /**
             * @public
             * Add a listener for a specified event.
             * @param {string} eventName The name of the event.
             * @param {function(...)}
             */
            this.on = function (eventName, callback) {
                dispatcher.on(eventName, callback);
            };
            
            this.off = function (eventName, callback) {
                dispatcher.off(eventName, callback);
            };
        }

        return new ActivityPresenter();
    }());

    return ActivityPresenter;
});
