// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['fs/services/settings/ApplianceService'],
function(applianceService) { "use strict";
    
    var AppliancePresenter = (function() {
        
        /**
         * @constructor Presentation logic for the Appliance panel on the Settings Overview page.
         */
        function AppliancePresenter() {
            
            /**
             * Retrieve the version information for the appliance.
             * 
             * @param {Object} handlers The success and error handler methods. 
             */
            this.getVersion = function(handlers) {
                applianceService.getVersion({
                    success: handlers.success,
                    error: function(error) {
                        handlers.error(error);
                    }
                });
            };
            
        }
        
        return new AppliancePresenter();
        
    }());
    
    return AppliancePresenter;
    
});