// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.

define(['fs/services/restore/RestoreService',
        'fs/services/settings/SettingsService',
        'hp/model/Session'],
function(restoreService, settingsService, session) { "use strict";

    var RestorePresenter = (function() {

        /**
         * @constructor
         */
        function RestorePresenter() {
        
            // Maximum backup size from DB settings
            var maxBackupSize = null;
            
            // For unit testing, allow a stub of the timers created and cleared.
            var timerHost = window;
            
            // name of setting for the maximum backup size
            var MAX_BACKUP_SIZE_SETTING_NAME = 'max-backup-size';
            
            // polling interval for restore status (in milliseconds)
            var RESTORE_POLL_INTERVAL = 100;
            
            function onGetMaxBackupSizeSuccess(data) {
                maxBackupSize = data.value;
            }
            
            function onGetMaxBackupSizeError(data) {
                maxBackupSize = null;
            }
        
            function checkRestoreStatus(data, handlers) {
                if (data.status == 'FAILED') {
                    handlers.error({message: data.errorMessage , 
                                    recommendedActions: data.resolutionMessage});
                } else if (data.progressStep != 'PREPARING_TO_RESTORE' &&
                    data.progressStep != 'UNKNOWN') {
                    handlers.success();
                } else {
                    timerHost.setTimeout(function() {
                        restoreService.getLastRestoreStatus({
                            success : function(collection) {
                                checkRestoreStatus(collection.members[0], handlers);
                            },
                            error : function(errorInfo) {
                                handlers.error(errorInfo);
                            }
                        });
                    }, RESTORE_POLL_INTERVAL);
                }
            }
            
            /**
             * @private For unit testing only...
             */
            this._setTimerHost = function(th) {
                timerHost = th;
            };
            
            /**
             * Start restore.  Success handler invoked when controller state has
             * changed to restore.
             *
             * @param {{success:function():void, error:function(ErrorInfo):void}
             *     handlers Handler functions for success and error conditions.
             * @param URI of backup to restore
             */
            this.startRestore = function(handlers, backupUri) {
                restoreService.startRestore({
                            success: function(data) {
                                         checkRestoreStatus(data, handlers);
                            },
                            error: function(errorInfo) {
                                          handlers.error(errorInfo);
                            } 
                }, backupUri);
            };
            
            /**
             * Get maximum backup size
             */
            this.getMaxBackupSize = function() {
                return maxBackupSize;
            };
            
            /**
             * Initialize
             */
            this.init = function() {
                // Retrieve the maximum backup size from DB settings
                settingsService.getSetting(MAX_BACKUP_SIZE_SETTING_NAME, 
                    {success: onGetMaxBackupSizeSuccess, error: onGetMaxBackupSizeError});
            };

        }

        return new RestorePresenter();
    }());

    return RestorePresenter;
});
