// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST'],
function(REST) {"use strict";

    var StartingService = ( function() {

        var STARTING_FAILURE_TIMEOUT = 900000; // 15 minutes - observed startup of minimal appliance takes 3m45s.
        var STARTING_PROGRESS_URL = '/startstop/rest/component?fields=status';
        var EXPECTED_ERROR = 'GENERIC_HTTP_503';

        /**
         * @class Service to retrieve the starting progress from the server.
         */
        function StartingService() {

            // Interpret results from webappStatus and return current vs. target status.
            function interpretProgress (webAppStatus) {
                var starting = 0;
                var running = 0;
                var statusCounter = function(index, webApp) {
                    switch (webApp.status) {
                        case 'STARTING':
                            starting += 1;
                            break;
                        case 'RUNNING':
                            running +=1;
                            break;
                        default:
                            // All other status values, especially stopped, count as no progress.
                            break;
                    }
                };
                var numWebApps = webAppStatus.count;
                var progress = {}; // Object to pass progress to Presenter and View
                progress.target = numWebApps * 2;
                jQuery.each(webAppStatus.members, statusCounter);
                progress.current = (running * 2) + starting;
                return (progress);
            }
            
            /**
             * Return the progress of the starting process or the error code if
             * the progress is not yet available.
             *
             * @return {errorCode:string} to the waiting handler for expected 503 (Service note available) errors.
             * @return {target:number, current:number} to the progress handler for current progress.
             * @return {errorCode:string} to the error handler for all other (unexpected) errors.
             */
            this.getProgress = function(presenterHandlers) {
                var modelHandlers = {
                    success : function(webAppStatus) {
                        var progress = interpretProgress(webAppStatus);
                        presenterHandlers.progress(progress);
                    },
                    error : function(webAppStatus) {
                        if (EXPECTED_ERROR === webAppStatus.errorCode) {
                            presenterHandlers.waiting(webAppStatus);
                        } else {
                            presenterHandlers.error(webAppStatus);
                        }
                    }
                };
                REST.getURI(STARTING_PROGRESS_URL, modelHandlers, {timeout: STARTING_FAILURE_TIMEOUT});
            };
        }
        return new StartingService();
    }());
    return StartingService;
});
