// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define([
    'fs/presenter/settings/NetworkSetupPresenter',
    'fs/view/settings/network/NetworkEditViewBase',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'fs/shell/InitialNetworkRoutes',
    'jquery',      
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpToggle',
    'jqueryUI',
    'hp/lib/jquery.hpCollapsible'
], function(presenter, NetworkEditViewBase, router, urlFragment, initialRoutes) {"use strict";
    return ( function() {

        var FORM = '#cic-network-form',
            PANELS = '#cic-appliance-network-panel',
            PANEL_SELECTOR = '#cic-fsnetwork-panel-selector',
            ROUTE_PREFIX = '/settings/initial-network',
            OKBUTTON = '#cic-network-ok',
            LOGOUT_BUTTON = '#fs-settings-logout',
            NOTIFY_BOX = '#cic-network-details-notify',
            NOTIFY_MSG = "#cic-network-details-notify-message-id",
            NOTIFY_DISMISS = "#hp-details-notify-dismiss_link";

        function InitialNetworkView() {

            var base = new NetworkEditViewBase();


            function setControlsDisabled(disabledFlag) {
                 $(LOGOUT_BUTTON).toggleClass('hp-disabled', disabledFlag);
                 $(OKBUTTON).toggleClass('hp-disabled', disabledFlag);
            }
            
            function onSuccessRedirect(redirect) {
                base.resetForm();
                // wait for 15 seconds before redirecting
                if (redirect) {
                        setTimeout( function() {
                           redirect(); base.dismissDialog();}, 15000);
                } else {
                  //wait for 10 seconds for cert to relaod
                    if (presenter.shouldReloadWindow()) {
                            setTimeout( function() {
                                base.dismissDialog();
                                router.go('/', 'initial settings completed');
                                window.location.reload();
                                }, 10000);
                    } else {
                         // wait extra 10 seconds to make sure fts is done
                        setTimeout( function() {
                                base.dismissDialog();
                                router.go('/', 'initial settings completed');
                        }, 15000 );
                    }
                }
            }

            /**
             * @public Handle a click of the OK button by sending a REST request
             *         to set the new configuration
             */
            function onSetInitialNetworkClick() {
                if(!$(FORM).valid()) {
                    base.displayParameterError();
                    return;
                }
                setControlsDisabled(true);

                  if(presenter.hasTaskWarnings() && 
                      (!base.isFieldValueChanged())){ 
                    // if value not changed just proceed to apply network without validation

                      base.applyNetworkWithWarnings({
                           success: onSuccessRedirect ,
                           error: function() {
                               setControlsDisabled(false);
                           }
                       });
                  }else
                  { // proceed normally
                     base.apply({
                          success: onSuccessRedirect,
                          error: function() {
                              setControlsDisabled(false);
                          }
                      });

                  }
            }

            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
               }
            }

            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(PANEL_SELECTOR, selection.uris);
                $(PANELS).hpStackedPanels('setPanelByLocation',
                    '#' + router.location());
            }


            this.pause = function() {
                 presenter.off("selectionChange", onSelectionChange);
                 $(PANELS).hpStackedPanels('pause');
            };


            this.resume = function() {
                 setControlsDisabled(false);
                 presenter.on("selectionChange", onSelectionChange);
                 $(PANELS).hpStackedPanels('resume');
            };
            /**
             * @public Initialization method
             */
            this.init = function() {

                base.setFirstTime(true);
                presenter.on("selectionChange", onSelectionChange);
                base.init(ROUTE_PREFIX, FORM);

               $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });
                base.setNotifyElement($(NOTIFY_BOX));

                var options = {};
                base.addValidatorOptions(options);
                var validator = $(FORM).validate(options);
                base.setValidator(validator);

               $(LOGOUT_BUTTON).on('click', function(ev) {
               if($(LOGOUT_BUTTON).hasClass('hp-disabled') ){                 
                       return false;
                   } else {
                       base.resetForm();
                       return true;
                   }
             
                });
                $(OKBUTTON).on('click', function(ev) {
                    if ( $(OKBUTTON).hasClass('hp-disabled') ){
                        return false;
                    } else {
                        onSetInitialNetworkClick.call(this);
                        ev.preventDefault();
                   }
                });
                $(NOTIFY_BOX).hide();
                $(NOTIFY_DISMISS).click(function (evt) {
                    evt.preventDefault();
                    // TODO provide better mechanism for user to remove messages
                    $(NOTIFY_MSG).html('');
                    $(NOTIFY_BOX).slideUp('fast');
                });


               presenter.getNetworkConfiguration({
                    success: function(config) {
                        base.setFormLayout(config);
                        base.fillFields(config);
                    },
                    error: base.onError
                });

               router.watch('appliance network section', ROUTE_PREFIX + '.*',
                   {parent: ROUTE_PREFIX, change: changeLocation});

            };

        }
        return new InitialNetworkView();
    }());
});
