// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.
define(['hp/core/Localizer',
    'hp/core/Router' ],

    function(localizer, router) { "use strict";

        var LicenseWrittenofferView  = (function() {

        var EULA_CONTENT_BODY = "#hp-form-contents-body";
        var CLOSE_BUTTON = "#hp-eulawrittenoffer-close-button";

        function LicenseWrittenofferView  () {

            function onLoadSupportSuccess(data, status, xhr) {
                var writtenOfferHtml = $(data).filter('#hp-eula-partner-content');
                localizer.localizeDom(writtenOfferHtml);
                $(EULA_CONTENT_BODY).empty().append(writtenOfferHtml);
            }
            
            function onLoadSupportError(jqXHR, textStats, errorThrown) {
            }

            function loadEulaWrittenOfferHtml() {
               $.ajax({
                   url: '/ui-js/pages/fs/license/support_access_and_written_offer.html',
                   type: 'GET',
                   async: true,
                   dataType: "html",
                   success: onLoadSupportSuccess,
                   error: onLoadSupportError
               });
            }

            function onCloseButtonClick() {
                router.go('/settings/show/license/general', 'on Written Offer Agreement close');
            }

            this.resume = function() {
                loadEulaWrittenOfferHtml();
            };
            
            this.init = function() {
                $(CLOSE_BUTTON).click(function(ev) {
                    onCloseButtonClick();
                    ev.preventDefault();
                });
                this.resume();
            };
        }

        return new LicenseWrittenofferView ();

    }());

    return LicenseWrittenofferView ;

});