// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.

define([
    'fs/presenter/settings/PublicKeyPresenter',
    'hp/core/Router',
    'hp/core/Notifications',
    'hp/core/Localizer',
    'hp/core/UrlFragment',
    'hp/view/FormStateView',
    'fs/presenter/settings/AuthNPresenter',
    'text!fsPages/settings/authentication/remove_confirm.html',
    'hp/model/Session',
    'hp/view/DialogView',
    'jquery',
    'lib/jquery.selectBox',
    'lib/jquery.validate',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpStackedPanels'],
function(presenter, router, notifications, Localizer,urlFragment, FormStateView,authnPresenter,removeConfirmHtml,session,DialogView) { "use strict";

    var SecurityEditView = (function() {

        var validator;
        var DEFAULT_PROVIDER_SELECT = '#fs-settings-authn-edit-default-provider',
        LOCAL_LOGIN_CHECK = '#fs-settings-authn-edit-allow-local',
        DEFAULT_DIRECTORY_ERROR = "#fs-settings-authn-edit-default-provider-error",
        NO_DIRECTORIES = "#fs-settings-security-authn-no-directories",
        DIRECTORIES_TEMPLATE = "#security-authn-directories",
        DIRECTORIES_TABLE = '#security-directories-table',
        REMOVE_DIRECTORY_TITLE = '#fs-security-remove-directory-confirm-title',
        REMOVE_DIRECTORY_PROMPT_MESSAGE = '#fs-security-remove-directory-prompt';
       /**
        * Constructor
        */
        function SecurityEditView() {

            var OK = '#hp-settings-edit-ok',
                CANCEL = '#hp-settings-edit-cancel',
                ROUTE_PREFIX = '/settings/edit/security',
                PANELS = '#hp-appliance-security-panel',
                PANEL_SELECTOR = '#hp-setting-security-panel-selector',  
                FORM = '#hp-settings-security-form',
                KEY = '#hp-public-key',
                KEY_LOCATION = '#hp-security-key-location-msg';
            var cancelAfterApply = false;
            var allowLocalLoginDto = null;
            var defaultProvider = null;
            var formStateView = new FormStateView(),
                isSubmitted;
            var directoriesTable = null;
            var associations = [];
            var removeInProgress = false;
            var deleteDialog = null;
            function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } 
                else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }

            function onSelectionChange(selection) {
                urlFragment.replaceHrefUris(PANEL_SELECTOR, selection.uris);
                urlFragment.replaceHrefUris(CANCEL, selection.uris);                          
                $(PANELS).hpStackedPanels('setPanelByLocation',
                    '#' + router.location());
           }
            
            
            function setDefaultProviderDisplayValue() {
                if (defaultProvider !== null) {
                    $(DEFAULT_PROVIDER_SELECT).val(defaultProvider.loginDomain);
                    $("#fs-settings-authn-edit-default-provider-not-set").hide();
                    $(DEFAULT_PROVIDER_SELECT).selectBox('control').show();
                   
                }
                $(DEFAULT_PROVIDER_SELECT).selectBox('reset');
            }
      
             function getGlobalSettingsSuccess() {
 
                allowLocalLoginDto = authnPresenter.getAllowLocalLogin();

                if (allowLocalLoginDto !== null) {

                    $(LOCAL_LOGIN_CHECK).show();
                    $("#fs-settings-authn-label-allow-local-explain").show();
                    $(LOCAL_LOGIN_CHECK).prop("checked", allowLocalLoginDto.allowLocalLogin);
                    if (session.getAuthService() === 'LOCAL') {
                        $(LOCAL_LOGIN_CHECK).attr("disabled", true);
                    }
                    if (allowLocalLoginDto.allowLocalLogin) {
                        if (session.getAuthService() !== "LOCAL") {
                            $("#fs-settings-authn-label-allow-local-explain").hide();
                        }
                        $(DEFAULT_PROVIDER_SELECT).append($("<option>", {value : "0"})
                                .text(Localizer.getString('login.LocalUser')));
                        $("#fs-settings-authn-edit-default-provider-not-set").hide();
                        try {
                            $(DEFAULT_PROVIDER_SELECT).selectBox('control').show();
                        } catch (error) {
                            // nothing
                        }
                    }
                }

                var providerInfos = authnPresenter.getProviderInfos();
                defaultProvider = authnPresenter.getDefaultProvider();
                if (providerInfos !== null && providerInfos.length > 0) {
                    $.each(providerInfos, function(index, providerInfo) {
                        $(DEFAULT_PROVIDER_SELECT).append($("<option>", {
                            value : providerInfo.loginDomain
                        }).text(providerInfo.name));
                    });
                }
                if (providerInfos !== null && providerInfos.length === 0) {
                     $(NO_DIRECTORIES).show();
                     $(DIRECTORIES_TEMPLATE).hide();
                     }else{
                    $(DIRECTORIES_TEMPLATE).show();
                    $(NO_DIRECTORIES).hide(); 
                    }
                setDefaultProviderDisplayValue();
            }
           function toggleLocalLoginCheckbox() {
                var exists = false;

                if ($(LOCAL_LOGIN_CHECK).is(':checked')) {
                    if ($(DEFAULT_PROVIDER_SELECT + ' option[value="0"]').text() ===
                        Localizer.getString('login.LocalUser')) {
                        exists = true;
                    }
                    if (!exists) {
                        $(DEFAULT_PROVIDER_SELECT).append(
                                $("<option>", {value : "0"}).text(Localizer.getString('login.LocalUser')));
                        $(DEFAULT_PROVIDER_SELECT).selectBox('reset');
                    }
                }
            }
           /**
            *  Reset the form
            */
           function reset() {
        	   $(DEFAULT_DIRECTORY_ERROR).text('');
               $(DEFAULT_DIRECTORY_ERROR).hide();
               $(KEY).val("");
               formStateView.reset();
               validator.resetForm();
               isSubmitted = false;
           }

           function settingsPage(){
               router.go('/settings');
           }
           function onDeleteDirSuccess(directoryName) {
      
               var alertMsg =  Localizer.getString('fs.settings.security.edit_authn.delete_title', [directoryName]);
               var notif = {
                       summary : alertMsg,
                       status : 'ok'
                   };
                   notifications.add(notif, true);
                   removeInProgress = false;
                   reset();
                   settingsPage();
               }

           function onDeleteDirError(error) {
               var failureMessage = Localizer.getString('fs.settings.authn.failed_get_provider_info');
               formStateView.setMessage({
                   summary :failureMessage,
                   status : "error",
                   errorMessage : error
               });
               removeInProgress = false;
           }
           //validate the delete default directory
           function validateIfDefaultDirectory(directoryName) {
        	   removeInProgress = false;
               if ($(DEFAULT_PROVIDER_SELECT).val() === directoryName) {
                   return true;
               } else {
                   return false;
               }
           }
           //Delete the directory from server
           function onDeleteDirectory(event){
               $(DEFAULT_DIRECTORY_ERROR).text('');
               $(DEFAULT_DIRECTORY_ERROR).hide();
               if( !event.isPropagationStopped()){
               if (! removeInProgress ) {
            
                   removeInProgress = true;

                   var contents = $(removeConfirmHtml);
                   Localizer.localizeDom(contents);
                   var row = $(this).parents('tr')[0];
                   var association = directoriesTable.fnGetData(row);
                   var directoryName = association.name;
                   var id = association.id;
                   var config = authnPresenter.getProviderConfigByIndex(id);
                   if( !validateIfDefaultDirectory(config.loginDomain) ){
                      $(REMOVE_DIRECTORY_TITLE, contents).text(
                       Localizer.getString('fs.settings.security.edit_authn.delete_title', [directoryName]));
                   $(REMOVE_DIRECTORY_PROMPT_MESSAGE,contents).html(Localizer.getString('fs.settings.security.edit_authn.delete_message', [directoryName]));
                   deleteDialog = new DialogView({contents: contents,
                       ok: function () {
                                authnPresenter.deleteProviderConfig(config.uri, {
                                success : onDeleteDirSuccess(directoryName),
                                error : onDeleteDirError
                            });
                        },
                         cancel: function () {
                           removeInProgress = false;
                        }
                   });
                  } else {
                	  
                	  $(DEFAULT_DIRECTORY_ERROR).text(Localizer.getString('fs.settings.authn.edit.default_dir_delete_error'));
                      $(DEFAULT_DIRECTORY_ERROR).addClass('hp-error');
                      $(DEFAULT_DIRECTORY_ERROR).show();
                  }
                   
               }  
               }
               event.stopPropagation();
               event.preventDefault();
           }
           //Edit the directory 
           function onEditDirectory(event){
              if( !event.isPropagationStopped()){
               var row = $(this).parents('tr')[0];
               var association = directoriesTable.fnGetData(row);
               var id = association.id;
               var config = authnPresenter.getProviderConfigByIndex(id);
               if (config !== null){
               require(['fs/view/settings/authentication/AuthnEditDirectoryView'],
                       function (view) {view.initialize(event,config);}
                   );
               }
              }
               event.stopPropagation();
               event.preventDefault();
           }
            //Retrieve directories data from server success
            function getDirectoriesData(){
                var authConfigs = authnPresenter.getProviderConfigs();
                associations =[];
                for (var i=0; i<authConfigs.length; i+=1) {
                    associations.push({
                        id: i,
                        name: authConfigs[i].name
                    });
                }
             if(authConfigs !== null){
                directoriesTable = $(DIRECTORIES_TABLE).dataTable({
                    bPaginate : false,
                    bFilter : false,
                    bInfo : false,
                    sScrollY : 400,
                    sScrollX : 200,
                    sScrollXInner : "100%",
                    bScrollCollapse: true,
                    bDestroy : true,
                    aaData: associations,
                    aoColumns : [{
                          sTitle : "id",
                          mDataProp : 'id',
                          bVisible : false},
                         {
                         sTitle : "Name",
                         mDataProp : 'name',
                         sWidth : 5 },
                         { fnRender : function(oObj) {
                                return '<div class="hp-edit"></div>';
                            },
                            sDefaultContent : '',
                            sClass : 'hp-icon',
                            sWidth : 5,
                            bSortable : false }, 
                         { fnRender : function(oObj) {
                                return '<div class="hp-close"></div>';
                            },
                            sDefaultContent : '',
                            sClass : 'hp-icon',
                            sWidth : 5,
                            bSortable : false
                        }
                    ]
                });
             }
             $(DIRECTORIES_TABLE).on('click', '.hp-close', onDeleteDirectory);
             $(DIRECTORIES_TABLE).one('click', '.hp-edit', onEditDirectory);
             }
        
            function validateForm() {
                var errorCount = 0;

                $(DEFAULT_DIRECTORY_ERROR).text('');
                $(DEFAULT_DIRECTORY_ERROR).hide();

                //check to see if user has not allowed local login and still has LOCAL selected
                //as default provider
                if (!$(LOCAL_LOGIN_CHECK).prop("checked") && $(DEFAULT_PROVIDER_SELECT).val() === '0') {
                    errorCount++;
                    $(DEFAULT_DIRECTORY_ERROR).text(Localizer.getString('fs.settings.authn.edit.default_dir_error'));
                    $(DEFAULT_DIRECTORY_ERROR).addClass('hp-error');
                    $(DEFAULT_DIRECTORY_ERROR).show();
                }
                if (errorCount > 0) {
                    return false;
                } else {
                    return true;
                }
            }
            function onApplySuccess() {
            
                var alertMsg = Localizer.getString('fs.settings.authn.edit.success');
                var notif = {
                        summary : alertMsg,
                        status : 'ok'
                    };
                    notifications.add(notif, true);

                if (cancelAfterApply) {
                    $(CANCEL).trigger('click');
                }
             
            }

            function onApplyError(error) {
      
                formStateView.setMessage({
                    summary : error.failureMessage,
                    status : "error",
                    errorMessage : error.errorInfo
                });
              
            }

            function apply(cancelOnSuccess) {
            
                cancelAfterApply = cancelOnSuccess;
                if (validateForm()) {
                    
                    authnPresenter.setAllowLocalLogin($(LOCAL_LOGIN_CHECK).prop("checked"));
                    authnPresenter.setDefaultProviderById($(DEFAULT_PROVIDER_SELECT).val());
                    authnPresenter.saveSettings({
                        success : onApplySuccess,
                        error : onApplyError
                    });
                } else {
                    var error = {
                        "failureMessage" : Localizer.getString('fs.settings.authn.edit.save_failure'),
                        "errorInfo" : {
                            "errorMessage" : "",
                            "resolution" : Localizer.getString('fs.settings.authn.edit.failure_resolution')
                        }
                    };
                    onApplyError(error);
                }
            }
           

            function initForm() { 
                validator = $(FORM).validate();
                isSubmitted = false;
            }

            function onUpdatePublicKeyError(errorMessage) {
                var addMsg = Localizer.getString('fs.settings.security.panel.hp_public_key');
                formStateView.setMessage({summary: addMsg, status: 'error',
                    errorMessage: errorMessage});
                $(KEY).val("");
                isSubmitted = false;
            }


            function onUpdatePublicKeySuccess(data) {
                var publicKeyUpdated = {
                    summary : Localizer.getString('fs.settings.security.publickey.uploaded'),
                    status : "ok"
                };
                notifications.add(publicKeyUpdated, true, true, true);
                reset();
                settingsPage();
            }

            function updatePublicKey(){
       
                if ($(FORM).valid() && isSubmitted == false) {
                    isSubmitted = true;
                    var publicKey= $(KEY).val();
                    presenter.updatePublicKey(publicKey);
                }
            }
            function onError(error) {
                formStateView.setMessage({
                    summary : error.failureMessage,
                    status : "error",
                    errorMessage : error.errorInfo
                });
               
            }
            /**
             *  Register events with presenter layer
             */
            function registerEvents() {
             
                presenter.on('updatePublicKeySuccess', onUpdatePublicKeySuccess);
                presenter.on('updatePublicKeyError', onUpdatePublicKeyError);
                presenter.on("selectionChange", onSelectionChange);
                authnPresenter.on("getGlobalSettingsComplete", getGlobalSettingsSuccess);
                authnPresenter.on("getGlobalSettingsError", onError);
                authnPresenter.on("onGetAllProvidersComplete", getDirectoriesData);
            }

            /**
             *  Un-register events
             */
            function removeEvents() {
                presenter.off('updatePublicKeySuccess', onUpdatePublicKeySuccess);
                presenter.off('updatePublicKeyError', onUpdatePublicKeyError);
                presenter.off("selectionChange", onSelectionChange);  
                authnPresenter.off("getGlobalSettingsComplete", getGlobalSettingsSuccess);
                authnPresenter.off("getGlobalSettingsError", onError);
                authnPresenter.off("onGetAllProvidersComplete", getDirectoriesData);

            }
            function loadData() {
                  authnPresenter.loadSettingsEdit();
            }
            this.pause = function() {
                reset();
                removeEvents();
                cancelAfterApply = false;
                formStateView.reset();
                $(PANELS).hpStackedPanels('pause'); 
            };

            this.resume = function() {
               $(DEFAULT_PROVIDER_SELECT).empty();
                formStateView.reset();
                loadData();
                reset();
                registerEvents();
                $(PANELS).hpStackedPanels('resume'); 
              
            };
            function submitForm(){
              if($(KEY).val() !== ""){
                 updatePublicKey();
                 apply(true);
                 }else{
                  apply(true);
            }
            
            }
            
            /**
             *  Initialization function 
             */
            this.init = function() {
        
                $(KEY).attr('placeholder', Localizer.getString('fs.settings.security.publickey.paste_message'));
                var keyLink = '<a href="https://h20392.www2.hp.com/portal/swdepot/displayProductInfo.do?productNumber=HPLinuxCodeSigning" target="_blank">'+"hp.com"+'</a>',
                publicKeyLinkMsg = Localizer.getString('fs.settings.security.publickey.download_location_msg',[keyLink]);
                $(KEY_LOCATION).html(publicKeyLinkMsg);

                $(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                }); 

                router.watch('appliance security edit section', ROUTE_PREFIX + '.*',
                   {parent: ROUTE_PREFIX, change: changeLocation});

                formStateView.init({form: FORM,
                    autoTrack: true});
                registerEvents();
                initForm();

                //Reset the formStateView when (re-)entering the key in case of error scenario
                $(KEY).focus(function() {
                formStateView.reset();
                });
              
                $("#fs-settings-authn-edit-allow-local-not-set").show();
                $(LOCAL_LOGIN_CHECK).hide();
                $("#fs-settings-authn-label-allow-local").hide();
                $("#fs-settings-authn-edit-default-provider-not-set").show();
                $(DEFAULT_PROVIDER_SELECT).selectBox({
                    autoWidth : false
                });
                $(DEFAULT_PROVIDER_SELECT).selectBox('control').hide();
                /*
                 * In IE8, maxlength attribute is not supported
                 * This function will make sure entered text in textarea has upper bound as 'maxlength'
                 */ 
                $(KEY).on(" keyup mouseup",function(){  
                    var keyUpperBound = parseInt($(this).attr('maxlength')),  
                        key = $(this).val(),
                        keyLength = key.length;
                    if(keyLength > keyUpperBound){
                        key = key.substr(0, keyUpperBound);
                        $(this).val(key);
                    }
                });

                $(OK).click(submitForm);
               
             
                $(CANCEL).click(reset);
                loadData();
                $(LOCAL_LOGIN_CHECK).bind('click', toggleLocalLoginCheckbox);
              
            };
        }

        return new SecurityEditView();

    }());

    return SecurityEditView;

});