//(C) Copyright 2011 Hewlett-Packard Development Company, L.P.
define(
        [ 'hp/core/Router', 'fs/presenter/users/UsersPresenter',
                'fs/presenter/settings/AuthNPresenter', 'hp/core/Localizer',
                'hp/model/Session', 'hp/view/FormStateView',
                'hp/view/DialogView', 'hp/core/Notifications',
                'lib/jquery.selectBox', 'hp/lib/jquery.hpToggle',
                'lib/jquery.validate','hp/lib/jquery.hpSearchCombo' ],
        function(router, usersPresenter, authnPresenter, Localizer, session,
                FormStateView, DialogView, notifications) {
            "use strict";

            var AddDirectoryUserGroupView = (function() {

                function AddDirectoryUserGroupView() {

                    var HEADER = '#fs-user-group-header';
                    var AUTHN_SERVICES_SELECT = "#fs-usersGroup-authn-services";
                    var AUTHN_SERVICES_TEXT = '#fs-usersGroup-authn-services-text';
                    var ROLE_VALIDATOR = '#fs-user-role-validator';
                    var ROLES_LIST = '#fs-user-roles-list';
                    var ROLES = ROLES_LIST + ' input[type="checkbox"]';
                    var ROLE = '#fs-user-role';
                    var ROLE_OPTION = 'input:radio[name=' + ROLE + ']';
                    var ROLE_SET = '#fs-user-role-set';
                    var READ_ONLY_ACCESS = '#fs-user-role-readonly-access';
                    var FULL_ACCESS = '#fs-user-role-full-access';
                    var FORM = '#fs-user-group-add-form';
                    var ADD = '#fs-add-user-group';
                    var ADD_AGAIN = '#fs-addAgain-user-group';
                    var CANCEL = '#fs-cancel-user-group';
                    var TITLE = '#fs-dir-credentials-title';
                    var USER_NAME = '#fs-dir-credentials-username';
                    var PASSWORD = '#fs-dir-credentials-password', MAX_NAME_LENGTH = 39;

                    var CRED_FORM_DLG = '#fs-dir-credentials-form-dlg';
                    var CRED_FORM = '#fs-dir-credentials-form';
                    var NO_DIR_CONFIGURED_FORM = '#fs-no-dir-configured';
                    var SPECIALIZED_RADIO = '#fs-user-role-specialized';
                    var READONLY_RADIO = '#fs-user-role-readonly';
                    var FULL_RADIO = '#fs-user-role-full';
                    var ADD_DIR_CONFIG_DIV = '#fs-user-group-add-div';
                    var GROUP_SELECT = '#fs-group-name-hp-select-combo';
                    var GROUP_SELECT_TEXT = '#fs-group-name-hp-select-combo-input';
                    var firstRoleTemplate = null, roleTemplate = null;
                    var isSpecialized, isReadOnly, isFull;
                    var credentialDialogTemplate;

                    var validator, usersGroupValidator;
                    // prevent double click
                    var isSubmitted;
                    var isCredentialsSubmitted = false, addAgain = false;
                    var confDomains, selectedLoginDomain;

                    var formStateView;

                    var userNameValue, passwordValue, authServiceValue;
                    
                    var groupsList = [];

                    /**
                     * @private
                     */
                    function showAuthnServices() {
                        if ((confDomains === null) || (confDomains.length === 0)) {
                            // show the 'add a directory' hyperlink page
                            selectedLoginDomain = "";
                            $(NO_DIR_CONFIGURED_FORM).show();
                            $(HEADER).hide();
                            $(FORM).show();
                            $(ADD_DIR_CONFIG_DIV).hide();
                            $(ADD).hide();
                            $(ADD_AGAIN).hide();
                        } else if (confDomains.length === 1) {
                            $(NO_DIR_CONFIGURED_FORM).hide();
                            $(AUTHN_SERVICES_SELECT).hide();
                            $(HEADER).show();
                            $(FORM).show();
                            $(ADD_DIR_CONFIG_DIV).show();
                            $(ADD).show();
                            $(ADD_AGAIN).show();
                            $(AUTHN_SERVICES_TEXT).val(confDomains[0].name);
                            selectedLoginDomain = confDomains[0].name;
                        } else {
                            $(NO_DIR_CONFIGURED_FORM).hide();
                            $(AUTHN_SERVICES_TEXT).hide();
                            $(HEADER).show();
                            $(FORM).show();
                            $(AUTHN_SERVICES_SELECT).empty();
                            $(AUTHN_SERVICES_SELECT).selectBox('destroy');
                            $.each(confDomains, function(index, domain) {
                                $(AUTHN_SERVICES_SELECT).append($('<option>', {
                                    value : domain.loginDomain
                                }).text(domain.name));
                            });
                            $(AUTHN_SERVICES_SELECT).selectBox({
                                autoWidth : false
                            });
                            $(AUTHN_SERVICES_SELECT).val(
                                    confDomains[0].loginDomain);
                            $(AUTHN_SERVICES_SELECT).selectBox('reset');
                            selectedLoginDomain = confDomains[0].name;
                        }
                    }

                    /**
                     * @private
                     */
                    function onGetGlobalSettingsSuccess(configuredDomains) {
                        confDomains = configuredDomains;
                        showAuthnServices();
                    }

                    /**
                     * @private
                     */
                    function formatNotificationDetails(serverError) {

                        var resolutionList = serverError.recommendedActions;
                        var resolutionMessage = "";
                        $.each(resolutionList, function(index, resolution) {
                            resolutionMessage = resolutionMessage + resolution + " <br> ";
                        });

                        var failureNotificationDetails = {
                            summary : serverError.message + " " + resolutionMessage,
                            details : serverError.details,
                            status : "error"
                        };
                        return failureNotificationDetails;
                    }

                    /**
                     * @private
                     */
                    function onError(errorInfo) {
                        var details = '';
                        var resolutions = '';
                        var failureNotificationDetails = '';
                        var serverErrorList = errorInfo.nestedErrors;
                        if(serverErrorList.length === 0) {
                            details = errorInfo.details;
                            resolutions = errorInfo.resolution;
                        } else {
                        $.each(
                            serverErrorList,
                            function(index, serverError) {
                                details = details + " " +serverError.details;
                                var resolutionList = serverError.recommendedActions;
                                failureNotificationDetails = formatNotificationDetails(serverError);
                                $.each(
                                    resolutionList,
                                    function(index,
                                        resolution) {
                                        resolutions = resolutions + " " + resolution;
                                    });
                            });
                         }
                        formStateView.setMessage({
                            summary : details,
                            status : 'error',
                            details : resolutions
                        });

                        notifications.add(failureNotificationDetails, true,
                                true, true);

                        isSubmitted = false;
                    }

                    /**
                     * @private
                     */
                    function onSpecializedUserClick() {
                        $(SPECIALIZED_RADIO).attr("checked", true);
                        isSpecialized = true;
                        isReadOnly = false;
                        isFull = false;
                        $(READ_ONLY_ACCESS).hide();
                        $(FULL_ACCESS).hide();
                        $(ROLES_LIST).show();
                    }

                    /**
                     * @private
                     */
                    function onReadOnlyUserClick() {
                        $(READONLY_RADIO).attr("checked", true);
                        isSpecialized = false;
                        isReadOnly = true;
                        isFull = false;
                        $(READ_ONLY_ACCESS).show();
                        $(FULL_ACCESS).hide();
                        $(ROLES_LIST).hide();
                    }

                    /**
                     * @private
                     */
                    function onFullUserClick() {
                        $(FULL_RADIO).attr("checked", true);
                        isSpecialized = false;
                        isReadOnly = false;
                        isFull = true;
                        $(READ_ONLY_ACCESS).hide();
                        $(FULL_ACCESS).show();
                        $(ROLES_LIST).hide();
                    }

                    /**
                     * @private
                     */
                    function onRoleTypeChange() {
                        if ($(
                                'input[type="radio"][name=' + "fs-user-role" + ']:checked').attr('id') === $(
                                SPECIALIZED_RADIO).attr('id')) {
                            usersGroupValidator.resetForm();
                            onSpecializedUserClick();
                        } else if ($(
                                'input[type="radio"][name=' + "fs-user-role" + ']:checked').attr('id') === $(
                                READONLY_RADIO).attr('id')) {
                            usersGroupValidator.resetForm();
                            onReadOnlyUserClick();
                        } else if ($(
                                'input[type="radio"][name=' + "fs-user-role" + ']:checked').attr('id') === $(
                                FULL_RADIO).attr('id')) {
                            usersGroupValidator.resetForm();
                            onFullUserClick();
                        }
                    }

                    /**
                     * @private
                     */
                    function onAuthnServiceChange() {
                        selectedLoginDomain = $(
                                AUTHN_SERVICES_SELECT + " :selected").text();
                        isCredentialsSubmitted = false;
                        setDefaultGroupSelect();
                    }

                    /**
                     * @private
                     */
                    function reset() {
                        // Initialize the combo box and clears it
                        showAuthnServices();
                        $(ROLES).each(function(index, role) {
                            if (isSpecialized) {
                                role.checked = false;
                            }
                        });

                        onSpecializedUserClick();

                        isCredentialsSubmitted = false;
                        isSubmitted = false;
                        formStateView.reset();
                        validator.resetForm();
                        usersGroupValidator.resetForm();
                    }

                    /**
                     * @private
                     */
                    function onAddSuccess() {
                        var alertMsg = Localizer.getString(
                                'fs.users.userGroup.success',
                                [ selectedLoginDomain ]);
                        formStateView.setMessage({
                            summary : alertMsg,
                            status : 'ok',
                            alertMsg : alertMsg
                        });

                        var grpAddedSuccess = {
                            summary : alertMsg,
                            status : "ok"
                        };
                        notifications.add(grpAddedSuccess, true, true, true);
                        reset();
                        if (!addAgain) {
                            router.go('/user/show', 'user show');
                        }
                    }

                    /**
                     * @private
                     */
                    function onAddGroupToRoleMappings() {
                        if (isCredentialsSubmitted === true) {
                            if ($(FORM).valid()) {
                                var roles = [];
                                if (isSpecialized) {
                                    $(ROLES).each(function(index, role) {
                                        if ($(role).is(':checked')) {
                                            roles.push($(role).val());
                                        }
                                    });
                                } else if (isReadOnly) {
                                    roles
                                            .push(Localizer
                                                    .getString('fs.users.userGroup.readonly'));
                                } else if (isFull) {
                                    roles
                                            .push(Localizer
                                                    .getString('fs.users.userGroup.infrastructureAdministrator'));
                                }

                                if (roles !== null) {
                                    var group = $(GROUP_SELECT_TEXT).val();
                                    var userName = userNameValue;
                                    var password = passwordValue;
                                    if (confDomains.length === 1) {
                                        selectedLoginDomain = $(
                                                AUTHN_SERVICES_TEXT).val();
                                    }

                                    authnPresenter.addGroupToRoleMappings(
                                            selectedLoginDomain, group, roles,
                                            userName, password, {
                                                success : onAddSuccess,
                                                error : onError
                                            });
                                }
                                return true;
                            }
                        } else {
                            var alertMsg = Localizer
                                    .getString('fs.users.credentials.error2');
                            formStateView.setMessage({
                                summary : alertMsg,
                                status : 'error',
                                alertMsg : alertMsg
                            });
                        }
                        return false;
                    }

                    /**
                     * @private
                     */
                    function updateRoles() {
                        var roles = usersPresenter.getRoles();

                        $(ROLES_LIST).empty();

                        $.each(roles, function(index, role) {
                            if (role.roleName !== 'No_Privileges' && role.roleName !== Localizer.getString('fs.users.common.infrastructure_administrator') 
                                && role.roleName !== Localizer.getString('fs.users.common.read_only')) {
                                var item = null;
                                if (index === 0) {
                                    item = firstRoleTemplate.clone();
                                } else {
                                    item = roleTemplate.clone();
                                }
                                var id = 'fs-user-role-' + index;
                                var label = role.roleName.replace(/_/, ' ');

                                item.attr('id', '');
                                item.show();
                                $('input[type="checkbox"]', item)
                                        .attr('id', id).val(role.roleName)
                                        .attr('name', role.roleName);
                                $('label:eq(1)', item).text(label).attr('for',
                                        id);

                                $(ROLES_LIST).append(item);
                                if (index === 0) {
                                    $(ROLE_VALIDATOR).rules("add", {
                                        roleValidation : ROLE_VALIDATOR
                                    });
                                }

                            }
                        });
                        formStateView.reset();

                    }

                    /**
                     * @private
                     */
                    function checkRoles() {
                        var result = false;
                        $(ROLES).each(function(index, role) {
                            if (isSpecialized) {
                                if ($(role).is(':checked')) {
                                    result = true;
                                }
                            } else {
                                result = true;
                            }
                        });
                        return result;
                    }

                    /**
                     * @private
                     */
                    function registerEvents() {
                        usersPresenter.on("onCompleteGlobalSettings",
                                onGetGlobalSettingsSuccess);
                        usersPresenter.on("getGlobalSettingsError", onError);
                        usersPresenter.on('rolesChanged', updateRoles);
                    }

                    /**
                     * @private
                     */
                    function removeEvents() {
                        usersPresenter.off("onCompleteGlobalSettings",
                                onGetGlobalSettingsSuccess);
                        usersPresenter.off("getGlobalSettingsError", onError);
                        usersPresenter.off('rolesChanged', updateRoles);
                    }

                    /**
                     * @private
                     */
                    function cancel() {
                        reset();
                    }

                    function onGetGroupsSuccess(groupsList) {
                        var itemList = [];
                        $.each(groupsList, function(index, group) {
                            var item = {id: index, name: group};
                            itemList.push(item);
                        });
                        $(GROUP_SELECT).hpSearchCombo({results: itemList,
                            searchingMessage: Localizer.getString('search.searching'),
                            noMatchesMessage: Localizer.getString('search.noMatches'),
                            matchesMessage: Localizer.getString('search.matches')});
                            $(GROUP_SELECT_TEXT).focus();
                    }
                    
                    function onGetGroupsFailure(errorMessage) {
                        isCredentialsSubmitted = false;
                        formStateView.setMessage({
                            summary : errorMessage.details,
                            status : 'error',
                            details : errorMessage.resolution
                        });
                    }
                    
                    function getGroupList() {
                        var uname = userNameValue;
                        var password = passwordValue;
                        var authDomain = authServiceValue;
                        usersPresenter.getGroupList(uname,
                                password,
                                authDomain,
                                {
                            success : onGetGroupsSuccess,
                            error: onGetGroupsFailure
                        });
                    }
                    
                    function setGroupSelectData() {
                        groupsList = getGroupList();
                    }
                    
                    /**
                     * @private
                     */
                    function onOK() {
                        userNameValue = $(USER_NAME).val();
                        passwordValue = $(PASSWORD).val();
                        authServiceValue = $(AUTHN_SERVICES_SELECT + " :selected").text();
                        if ($(CRED_FORM).valid() && isCredentialsSubmitted === false) {
                            isCredentialsSubmitted = true;
                            formStateView.reset();
                            $(USER_NAME).val("");
                            $(PASSWORD).val("");
                            $(GROUP_SELECT_TEXT).val("");
                            setGroupSelectData();
                        } else {
                            var errMsg = Localizer
                                    .getString('fs.users.credentials.error');
                            formStateView.setMessage({
                                summary : errMsg,
                                status : 'error',
                                errMsg : errMsg
                            });
                            isCredentialsSubmitted = false;
                            
                        }
                        return isCredentialsSubmitted;
                    }
                    
                    
                    /**
                     * @private
                     */
                    function onCancel() {
                        isCredentialsSubmitted = false;
                        formStateView.reset();
                        $(USER_NAME).val("");
                        $(PASSWORD).val("");
                        $(GROUP_SELECT_TEXT).val("");
                        validator.resetForm();
                    }

                    /**
                     * @private
                     */
                    function showCredentialsDlg() {
                        var alertMsg = Localizer
                                .getString('fs.users.credentials.open');
                        formStateView.setMessage({
                            summary : alertMsg,
                            status : 'unknown',
                            alertMsg : alertMsg
                        });

                        var title = Localizer.getString(
                                'fs.users.credentials.title',
                                [ selectedLoginDomain ]);

                        $(TITLE, credentialDialogTemplate).text(title);

                        var dialog = new DialogView({
                            contents : credentialDialogTemplate,
                            ok : onOK,
                            cancel : onCancel
                        });
                        dialog = dialog;
                        $(GROUP_SELECT_TEXT).val("");
                        return isCredentialsSubmitted;
                    }

                    /**
                     * @private
                     */
                    function popupCredentialsDlg() {
                        if (isCredentialsSubmitted === false) {
                            showCredentialsDlg();
                            $(USER_NAME).focus();
                        } else {
                            var alertMsg = Localizer
                                    .getString('fs.users.credentials.success2');
                            formStateView.setMessage({
                                summary : alertMsg,
                                status : 'unknown',
                                alertMsg : alertMsg
                            });
                        }
                    }

                    /**
                     * @private
                     */
                    function validateUsersGroupForm() {

                        var validRoleValidation = Localizer
                                .getString('fs.users.validations.roleValidation');
                        var validGroupNameAlphanum = Localizer
                                .getString('fs.users.userGroup.groupnameValidation');
                        var validGroupNameFirstletter = Localizer
                                .getString('fs.users.userGroup.groupnameValidation2');

                        usersGroupValidator = $(FORM).validate({
                            rules : {
                                groups : {
                                    required : true,
                                    maxlength : MAX_NAME_LENGTH,
                                    fsDirGroupsStartsWithLetterCheck : GROUP_SELECT_TEXT,
                                    fsDirGroupsAlphaNumCheck : GROUP_SELECT_TEXT
                                },
                                roleValidation : ROLE_VALIDATOR
                            }
                        });

                        // role validation
                        $.validator.addMethod("DirGroupRoleValidation", function(value,
                                element, param) {
                            return checkRoles();
                        }, validRoleValidation);

                        // alphanumeric and - . _
                        $.validator.addMethod("fsDirGroupsAlphaNumCheck",
                                function(value, element, param) {
                                    return (/^[0-9-_.a-zA-Z]+$/.test(value));
                                }, validGroupNameAlphanum);

                        // should start with a letter only
                        $.validator.addMethod(
                                "fsDirGroupsStartsWithLetterCheck", function(
                                        value, element, param) {
                                    return (/^[a-zA-Z]+.*$/.test(value));
                                }, validGroupNameFirstletter);

                    }

                    /**
                     * @private
                     */
                    function validateCredentialsForm() {
                        var validUserNameAlphanum = Localizer
                                .getString('fs.users.validations.usernameValidation');
                        var validUserNameFirstletter = Localizer
                                .getString('fs.users.validations.usernameValidation2');
                        var validPassword = Localizer
                                .getString('fs.users.validations.passwordValidation');

                        validator = $(CRED_FORM_DLG + ' form')
                                .validate(
                                        {
                                            rules : {
                                                username : {
                                                    required : true,
                                                    maxlength : MAX_NAME_LENGTH,
                                                    fsDirUsersStartsWithLetterCheck : USER_NAME,
                                                    fsDirUsersAlphaNumCheck : USER_NAME
                                                },
                                                password : {
                                                    required : true,
                                                    fsDirUsersCheckPasswdString : PASSWORD
                                                }
                                            }
                                        });

                        // alphanumeric and - . _
                        $.validator.addMethod("fsDirUsersAlphaNumCheck",
                                function(value, element, param) {
                                    return (/^[0-9-_.a-zA-Z]+$/.test(value));
                                }, validUserNameAlphanum);

                        // No special characters allowed <>;,"'&\/|+.:=
                        $.validator.addMethod("fsDirUsersCheckPasswdString",
                                function(value, element, param) {
                                    return (/^[^<>;,"'&\\\/|+:= ]+$/
                                            .test(value));
                                }, validPassword);

                        // should start with a letter only
                        $.validator.addMethod(
                                "fsDirUsersStartsWithLetterCheck", function(
                                        value, element, param) {
                                    return (/^[a-zA-Z]+.*$/.test(value));
                                }, validUserNameFirstletter);
                    }
                    
                    function setDefaultGroupSelect() {
                        $(GROUP_SELECT_TEXT).val("");
                        $(GROUP_SELECT).hpSearchCombo({results: {count:0,total:0,start:0,members:[]}});
                        $(GROUP_SELECT).hpSearchCombo('set');
                        $(GROUP_SELECT_TEXT).focus();
                    }

                    /**
                     * @private
                     */
                    function initForm() {
                        isSubmitted = false;
                        isCredentialsSubmitted = false;
                        validateUsersGroupForm();
                        validateCredentialsForm();
                        $(USER_NAME).focus();
                        credentialDialogTemplate = $(CRED_FORM_DLG).detach()
                                .show();
                        Localizer.localizeDom(credentialDialogTemplate);
                        setDefaultGroupSelect();
                    }
                    
                    
                    /**
                     * @public Initialize the view. Makes required REST calls
                     *         and sets up event handlers.
                     */
                    this.init = function() {
                        firstRoleTemplate = $('#fs-user-first-role-template')
                                .detach();
                        roleTemplate = $('#fs-user-role-template').detach();
                        $(ROLE_SET).buttonset();
                        initForm();

                        formStateView = new FormStateView();
                        formStateView.init({
                            form : FORM,
                            autoTrack : true
                        });

                        isSpecialized = true;
                        isReadOnly = false;
                        isFull = false;
                        $(READ_ONLY_ACCESS).hide();
                        $(FULL_ACCESS).hide();
                        $(ROLES_LIST).show();
                        $(NO_DIR_CONFIGURED_FORM).css({
                            position : "absolute",
                            zIndex : "2",
                            width : "2.5em",
                            height : "1.2em",
                            cursor : "default",
                            top : "10px",
                            left : "50px",
                            bottom : "10px",
                            right : "10px",
                            marginLeft : "0.6em",
                            background : "#e6e6e6",
                            fontWeight : "normal",
                            color : "#555555",
                            textDecoration : "none"
                        });
                        $(NO_DIR_CONFIGURED_FORM).hide();

                        $(ROLE_OPTION).change(function(e) {
                            onRoleTypeChange();
                        });

                        $(ROLE_SET).change(function(e) {
                            onRoleTypeChange();
                        });

                        $(AUTHN_SERVICES_SELECT).change(function() {
                            onAuthnServiceChange();
                        });

                        $(ADD).on('click', function(ev) {
                            addAgain = false;
                            onAddGroupToRoleMappings.call(this);
                            ev.preventDefault();
                        });

                        $(ADD_AGAIN).on('click', function(ev) {
                            addAgain = true;
                            onAddGroupToRoleMappings.call(this);
                            ev.preventDefault();
                        });

                        $(CANCEL).click(function() {
                            cancel();
                        });
                        
                        $(GROUP_SELECT_TEXT).click(function(evt) {
                            $(USER_NAME).focus();
                            popupCredentialsDlg();
                            evt.preventDefault();
                        });
                        
                        $(GROUP_SELECT).change(function(evt) {
                            $(USER_NAME).focus();
                            popupCredentialsDlg();
                        });
                        
                        registerEvents();
                        usersPresenter.getAuthnServices();
                    };

                    /**
                     * @public
                     */
                    this.pause = function() {
                        removeEvents();
                        formStateView.reset();
                    };

                    /**
                     * @public
                     */
                    this.resume = function() {
                        registerEvents();
                        onAuthnServiceChange();
                        usersPresenter.getAuthnServices();
                        updateRoles();
                        setDefaultGroupSelect();
                    };

                }

                return new AddDirectoryUserGroupView();

            }());

            return AddDirectoryUserGroupView;

        });
