// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['fs/presenter/users/UsersPresenter',
    'fs/model/users/UserResource',
    'hp/core/Notifications',
    'hp/view/MasterPaneView',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStatus' ],
function(presenter, resource, notifications, MasterPaneView, localizer) { "use strict";

    var UsersView = (function() {

        var TYPE = 'user',
            PAGE = '#fs-users-page',
            ROLE_LIST = '#user-role-list',
            ROLE_LIST_ITEMS = '#user-role-list li';

        /**
         * Constructor
         */
        function UsersView() {

            var masterPaneView = new MasterPaneView();

            function updateRoles(){
                var roles = presenter.getRoles();
                $(ROLE_LIST_ITEMS).remove();
                var topLabel = localizer.getString('fs.users.common.all_roles');
                var topListitem = $('<li/>');
                topListitem.attr("data-id","all")
                    .text(topLabel)
                    .addClass("hp-selected");
                $(ROLE_LIST).append(topListitem);
                $.each(roles, function(index, role) {
                    if (role.roleName !== 'No_Privileges') {
                        var label = role.roleName ? role.roleName.replace(/_/, ' ') : 'noname';
                        var correctCaseRole = '';
                        var splitRole = role.roleName.replace(/_/, ' ').split(' ');
                        $.each(splitRole, function(key, word) {
                            if(key !=0){
                                correctCaseRole = correctCaseRole +' '+ word.toLowerCase();
                            }else{
                                correctCaseRole = correctCaseRole + word;
                            }
                        });
                        var listitem = $('<li/>');
                        listitem.attr("data-id",label.toLowerCase())
                            .text( correctCaseRole);
                        $(ROLE_LIST).append(listitem);
                    }
                });
            }



            /**
             * @public
             */
            this.init = function() {
                presenter.init();
                masterPaneView.init({
                    routePrefix: '/' + TYPE,
                    resource: resource,
                    page: $(PAGE),
                    addLink: presenter.getAddLink(),
                    dataTableOptions : {
                        aaSorting : [ [ 0, "asc" ] ],
                        aoColumns : [
                                     {
                                         "sDefaultContent": "",
                                         "mDataProp" : "attributes.user_group_name",
                                         "sWidth" : "100px"
                                     },
                                     {
                                         "sDefaultContent": "",
                                         "mDataProp" : "attributes.directory_name",
                                         "sWidth" : "100px"
                                     },
                                     {
                                         "sDefaultContent": "",
                                         "mDataProp" : "attributes.directory_type",
                                         "sWidth" : "100px"
                                     },
                                     {
                                         "sDefaultContent": "",
                                         "bSortable": false,
                                         "mDataProp" : "multiAttributes.roles",
                                         "sWidth" : "200px"
                                     } ]
                    }
                });
                presenter.on('notification', function(msg) {
                    notifications.show(msg.text, msg.type);
                });
                presenter.on('rolesChanged', updateRoles);
            };

            // public
            this.pause = function() {
                presenter.off('rolesChanged', updateRoles);
                masterPaneView.pause();
            };

            // public
            this.resume = function() {
                masterPaneView.resume();
                presenter.on('rolesChanged', updateRoles);
            };
        }

        return new UsersView();
    }());

    return UsersView;
});
