// (C) Copyright 2012-2013 Hewlett-Packard Development Company, L.P.

define(['hp/core/Localizer', 'jquery'], function(localizer) {
    (function($) {
        // jQuery plugin definition
        $.fn.hpGridPanels = function(options) {
          
            var instance;

            function hpGridPanels(elem) {
              
                var container;
                var layoutTimer;
                
                function removeScrolling() {
                    $('.hp-grid-panel', container).each(function (index, panel) {
                        if ($('.hp-panel-contents', $(panel)).
                            parent('.hp-panel-contents-container').length > 0) {
                            $('.hp-panel-contents', $(panel)).unwrap();
                        }
                    });
                }
                
                function addScrolling() {
                    var contentContainer;
                    $('.hp-grid-panel', container).each(function (index, panel) {
                        var contents = $('.hp-panel-contents', panel);
                        var header, heightOffset;
                        if (contents.length > 0) {
                            header = $('> header', panel);
                            heightOffset = contents.position().top;
                            if (header.length > 0) {
                                heightOffset -= header.position().top;
                            }
                            contentContainer = $('<div></div>').
                                addClass('hp-panel-contents-container').
                                css({width: $(panel).width(),
                                    height: $(panel).height() - heightOffset});
                            contents.wrap(contentContainer);
                        }
                    });
                }
                
                function layout() {

                    removeScrolling();

                    // get width of details area 
                    var width = $(container).innerWidth();

                    if (width < 460) {
                        $(container).addClass('hp-grid-narrow');
                        $('.hp-grid-panel, .hp-grid-row, .hp-grid-column',
                              container).css({'width': '100%', 'height': ''});
                        $('.hp-panel-contents', container).css('position', 'static');
                    } else {
                        $(container).removeClass('hp-grid-narrow');

                        $('.hp-panel-contents', container).css('position', '');
                        $('.hp-grid-panel, .hp-grid-row, .hp-grid-column',
                              container).css({'width': '', 'display': ''});

                        // calculate our unit width 
                        var unitWidth = width / 12;

                        // update the css width property
                        for (var index = 1; index <= 12; index += 1) {
                            $(".hp-grid-span-" + index, container).
                                css('width', Math.floor(unitWidth * index));
                        }

                        // get height of details area 
                        var height = $(container).innerHeight();

                        // calculate our unit height 
                        var unitHeight = height / 12;

                        // update the css height property 
                        for (var index = 1; index <= 12; index += 1) {
                            $(".hp-grid-height-" + index, container).
                                css('height', Math.floor(unitHeight * index));
                        }

                        addScrolling();
                    }

                }
                
                function onResize(event) {
                    if (event.target == window) {
                        clearTimeout(layoutTimer);
                        layoutTimer = setTimeout(layout, 50);
                    }
                }
              
                this.initialize = function(elem) {
                    container = $(elem);
                    $('.hp-panel-edit', container).
                        text(localizer.getString('core.details.edit'));
                    // rely on this event to trigger layout
                    container.parents('.hp-page').on('relayout', layout);
                    $(window).on('resize', onResize);
                    layout();
                };
                
                this.reset = function() {
                    layout();
                };
            }
            
            if ( typeof options === 'string' ) { 
                // call method
                var args = Array.prototype.slice.call( arguments, 1 );

                this.each(function() {
                    instance = $.data( this, 'hpGridPanels' );
                    if ( !instance ) {
                        if (window.console) {
                            window.console.error(
                                "cannot call methods on hpGridPanels prior to initialization; " +
                                "attempted to call method '" + options + "'" );
                        }
                        return;
                    }
                    if ( !$.isFunction( instance[options] ) || options.charAt(0) === "_" ) {
                        if (window.console) {
                            window.console.error(
                                "no such method '" + options + "' for hpGridPanels instance" );
                        }
                        return;
                    }
                    // apply method
                    instance[ options ].apply( instance, args );
                });  
            } else {
                // pluginify
                var ret;
                this.each(function() {
                    var $elem = $(this);
                    instance = new hpGridPanels($elem[0]);
                    $.data(this, 'hpGridPanels', instance);
                    instance.initialize($elem[0]);
                    ret = ret ? ret.add($elem) : $elem;
                });
                return ret;
            }
        };
    }(jQuery));
});
