// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {MapLink}
 */
define(['hp/core/Localizer'],
function (localizer) { "use strict";

    var MapLink = ( function() {

        function MapLink() {

            var self = this;
            var map;
            var parentNode;
            var childNode;
            var highlighted = false;
            var selectionRelated = false;
            
            this.parentNode = function () {
                return parentNode;
            };
            
            this.childNode = function () {
                return childNode;
            };
            
            this.hasNodeById = function (id) {
                return (parentNode.id() === id || childNode.id() === id);
            };
            
            this.relinkNode = function (originalNode, newNode) {
                if (parentNode === originalNode) {
                    if (childNode.linkedTo(newNode)) {
                        // already linked to, remove this one
                        map.removeLink(self);
                    } else {
                        parentNode = newNode;
                    }
                } else if (childNode === originalNode) {
                    if (parentNode.linkedTo(newNode)) {
                        // already linked to, remove this one
                        map.removeLink(self);
                    } else {
                        childNode = newNode;
                    }
                }
            }
            
            this.isSelectionRelated = function () {
                return selectionRelated;
            };
            
            this.setSelectionRelated = function (selectionRelatedArg) {
                selectionRelated = selectionRelatedArg;
                if (parentNode.isSelected()) {
                    childNode.setSelectionRelated(selectionRelatedArg);
                } else {
                    parentNode.setSelectionRelated(selectionRelatedArg);
                }
            };
            
            this.isHighlighted = function () {
                return highlighted;
            };
            
            this.setHighlighted = function (highlightedArg) {
                highlighted = highlightedArg;
            };
            
            this.isDrawable = function (haveHighlight) {
                return (highlighted || (!haveHighlight && selectionRelated));
            };
            
            this.toString = function () {
                return parentNode.toString() + ' -> ' + childNode.toString();
            };
            
            this.init = function(mapArg, parentNodeArg, childNodeArg) {
                map = mapArg;
                parentNode = parentNodeArg;
                childNode = childNodeArg;
                parentNode.addLink(self);
                childNode.addLink(self);
            };
            
            this.destroy = function() {
                parentNode.removeLink(self);
                childNode.removeLink(self);
                parentNode = null;
                childNode = null;
                map = null;
            };
        }

        return MapLink;
    }());

    return MapLink;
});
