// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST'],
function(REST) {"use strict";
    var LUMService = ( function() {
        /**
         * @class Singleton class that handles communication with the
         * server-side Local User Management service.
         *
         * @type {LUMService}
         */
        function LUMService() {
            /**
             * Changes a user's password.
             *
             * @param {string} username The name of the user.
             * @param {string} oldPassword The user's old password.
             * @param {string} newPassword The user's new password.
             * @param {{success:function():void, error:function(ErrorInfo):void}}
             *     handlers The error and success handler functions.
             */
            this.changePassword = function(username, oldPassword, newPassword, handlers) {
                REST.postObject('/rest/users/changePassword', {
                   userName: username,
                   oldPassword: oldPassword,
                   newPassword: newPassword
                }, handlers);
            };
        }
        return new LUMService();
    }());
    return LUMService;
});
