// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.

define(['hpsum/presenter/baseline/BaselinePresenter',
    'hp/view/DialogView',
    'text!hpsumpages/baseline/add_baseline.html',
    'hp/core/Localizer',
    'jquery',
    'lib/jquery.selectBox',
	'hp/lib/jquery.hpSearchCombo'],
function(presenter, DialogView, addBaselineHtml, localizer) { "use strict";

    var BaselineCBLAddBaselineView = (function() {
      
        var OK = '#tour-server-edit-ok';
        var CANCEL = '#tour-server-edit-cancel';
        var FORM = '#tour-server-edit-bios-form';
		var SEARCH_COMBO = '#hpsum-custom-baseline-search';
		var CHECKBOX_HEADER = '#chkboxheader';
		var CHECKBOX_COMP = '#chkboxcomp';
        
        /**
         * Constructor
         */
        function BaselineCBLAddBaselineView() {
            
            var html;
            
            function onRowClick(event) {
                var row = $(this);
                var nextRow;
                
                // can't handle selectBox when changing details visibility
                if (! $(event.target).hasClass('selectBox') &&
                    $(event.target).parents('.selectBox').length === 0 &&
                    ! row.hasClass('hp-header') && ! row.hasClass('hp-details')) {
                    $('tr.hp-details', html).hide();
                    $('tr.hp-active', html).removeClass('hp-active');
                    row.toggleClass('hp-active');
                    nextRow = row.next();
                    if (nextRow.hasClass('hp-details')) {
                        nextRow.show();
                    }
                }
            }
          
            function onSelectionChange(selection) {
            }
            
            function onOk() {
            }
			
			function selectComponents() {
				if($(CHECKBOX_HEADER).attr('checked')) 
				{
					$(CHECKBOX_COMP).attr('checked', true);
                }
                else {
					$(CHECKBOX_COMP).attr('checked', false);
                }
			}
            
            this.resume = function () {
                html = $(addBaselineHtml);
                localizer.localizeDom(html);
            
                $('.hp-select', html).selectBox({autoWidth: false});
                $('.hp-details', html).hide();
                $('#tour-server-bios-settings', html).
                    on('click', 'tr', onRowClick);
                new DialogView({contents: html, ok: onOk});
            };
            
            this.pause = function () {
            };
          
            /**
             * @public
             */
            this.init = function () {
				
				var searchResults = [                    
					{id: 1, name: "Service Pack for Proliant 2012"},
					{id: 2, name: "Service Pack for Proliant 2010"},
					{id: 3, name: "Service Pack for Proliant 2011"}
				];
	
				$(SEARCH_COMBO).hpSearchCombo({results: searchResults});
				
				$(CHECKBOX_HEADER).bind('mousedown', selectComponents);
            };
        }

        return new BaselineCBLAddBaselineView();
    }());
    
    return BaselineCBLAddBaselineView;
});
