// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (BaselineCustomView)
 * This is a view class for Custom Baseline Add menu option.
 */
define(['hpsum/presenter/baseline/BaselinePresenter',
	'hp/core/Router',
    'hp/core/Notifications',
	'hp/core/HelpMenu',
    'hp/core/Localizer',
    'hp/view/DialogView',
    'hpsum/presenter/baseline/BaselinePresenter',
    'hp/view/FormStateView',
    'hp/model/Session',
    'hp/view/DialogView',
    'text!hpsumpages/common/confirm_dialog.html',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpToggle',
	'hp/lib/jquery.hpSearchCombo',
	'lib/jquery.jstree',
	'lib/jquery-ui-timepicker-addon'],
function(presenter, router, notifications, helpMenu, localizer, DialogView, BaselinePresenter, FormStateView, session, dialogview, dialogContent) { "use strict";

    var BaselineCustomView = (function() {
      
        var FORM = '#hpsum-custom-baselines-add-form',
        	SAVEAS = '#hpsum-custom-baselines-saveas',
        	CREATE = '#hpsum-custom-baselines-create',
        	RESET = '#hpsum-baselines-reset',
            CANCEL = '#hpsum-custon-baselines-close',
			ADDBASELINE = '#hpsum-cbl-add-baseline-button',
			REMOVEBASELINE = '#hpsum-cbl-remove-baseline-button',
			PANEL_SELECTOR = '#hpsum-cbl-panel-selector',
            FIRST_ANCHOR = PANEL_SELECTOR + ' a[href]:first',
            PANELS = '#hpsum-custom-baselines-panels',
			COLLAPSE = '#hpsum-custom-baseline-collapsible',
			COLLAPSE_SYSTEM = '#hpsum-custom-baseline-collapsible-system',
			COLLAPSE_STORAGE = '#hpsum-custom-baseline-collapsible-storage',
			COLLAPSE_NIC = '#hpsum-custom-baseline-collapsible-nic',
			COLLAPSE_FCHBA = '#hpsum-custom-baseline-collapsible-fchba',
			COLLAPSE_ADVFILTERS = '#hpsum-custom-baseline-collapsible-advfilters',
			COLLAPSE_ARCH = '#hpsum-custom-baseline-collapsible-arch',
			COLLAPSE_DEVTYPE = '#hpsum-custom-baseline-collapsible-devtype',
			COLLAPSE_OSTYPE = '#hpsum-custom-baseline-collapsible-ostype',
			//COLLAPSE_SERVER = '#hpsum-custom-baseline-collapsible-server',
			SEARCH_COMBO = '#hpsum-custom-baseline-search',
			DESCR = '#hpsum-custom-baselines-descr',
			VERSION = '#hpsum-custom-baselines-version',
			VERSION1 = '#hpsum-custom-baselines-version1',
			DATE_VERSION = '#hpsum-custom-baselines-datepicker-version',
			DATE_VERSION2 = '#hpsum-custom-baselines-version',
			VERSION2 = '#hpsum-custom-baselines-version2',
			ROUTE_PREFIX = '/baseline/custom';
            
     	var TARGET_LOCATION = '#hpsum-custom-baselines-targetloc',
     		ISO_LOCATION = '#hpsum-custom-baselines-isoloc',
     		CREATEISO_CHKBOX = '#chkbox-createiso',
     		BOOTABLEISO_CHKBOX = '#chkbox-bootableiso',
     		SELECT_COMPTYPE = '#select-comptype',
     		SOURCES_TABLE = '#baseline-sources-table',
     		BASELINE_NAME_LABEL = '#hpsum-custom-baselines-id',
     		TARGET_BROWSE_BUTTON = '#hpsum-cbl-browse-target',
     		ISO_BROWSE_BUTTON = '#hpsum-cbl-browse-iso',
            BROWSE_TREE = '#browse',
            BROWSE_DIALOG = '#hpsum-browse-dialog',
	    	NO_COMP_SELECTED = true,
	    	MAX_DESCR_LENGTH = 50,
	    	MAX_VER_LENGTH = 10;
        /**
         * Constructor
         */
        function BaselineCustomView() {
            var berror = false;
			var errorDetails = '';
            var addInProgress = false;
            var addbaselineDialogContents, browseDialogContents;
            var selectedTablesID = [];
            var CreateCustomBaselinehandlers =	{
                    			success : function(data) {
                        			createCustomBaselineSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			createCustomBaselineError(errorInfo);
                    			}
                		};
            var cblGetStatushandlers =	{
                    			success : function(data) {
                        			cblGetStatusSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                        			cblGetStatusError(errorInfo);
                    			}
                		};
            var formStateView = new FormStateView();
            var oTableBaselines;
          
            function onItemAddSuccess(item) {
                
            }

            /**
             * @private
             */
            function onItemAddError(errorMessage) {
                notifications.show(errorMessage, 'error');
                addInProgress = false;
                $(CANCEL).trigger('click');
            }

            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onSaveAs() {
				//Validate the input before proceeding with adding new custom baseline
				var berror = false;
				var descr = $(DESCR).val(); 
				if (descr.length <= 0 )
				{
					$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionRequired")) 	
					berror = true;
				}
				if (descr.length > MAX_DESCR_LENGTH) { 
		 			$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
		 			berror = true;
				}
				
				if($(DATE_VERSION).val().length <= 0)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionRequired"))
					berror = true;
				}
				
				if($(VERSION2).val().length > MAX_VER_LENGTH)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH);
					berror = true;
				}
				
				var descrcheck = /^[\w\-\s]+$/;   
					
			    if ( !descrcheck.test(descr) )
			    {       				
			    	$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionValidationMsg"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.descriptionError") + localizer.getString("hpsum.baseline.custom.descriptionValidationMsg") + '</p>';
		 		}
				
				//var versioncheck = /^[\d]+$/;   
					
			   // if ( !versioncheck.test($(VERSION2).val()) )
			    if ($(VERSION2).val() == '')
			    {       				
			    	$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionIdentifierError"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionError") + localizer.getString("hpsum.baseline.custom.versionIdentifierError") + '</p>';
		 		}
				
				if(berror)
					return false;
				
				var verstr = $(DATE_VERSION).val();
				verstr = verstr.replace(/\-/g, '.');
				verstr = verstr + '.' + $(VERSION2).val();
				
                if(! addInProgress) {
                    addInProgress = true;
                    $("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
                    presenter.addItem({
                    	category: 'baseline',
                    	name: descr, 
                        uri: '/baseline/item-' + (new Date()).getTime(), 
                        status: localizer.getString("core.details.ok"),
                        attributes: {version:verstr, size: localizer.getString("hpsum.baseline.custom.unknown")}}, {
                        success : onItemAddSuccess,
                        error : onItemAddError
                    });
                    
                    $(CANCEL).trigger('click');
                }

                return false;
            }
            
            /**
             * @private
             * Call presenter's addItem() to add a new baseline item into Indexservice
             */
            function onCreate(bsaveas) {
				//Validate the input before proceeding with adding new custom baseline
				var berror = false;
				var errorDetails = '';
				var descr = $(DESCR).val(); 
				if (descr.length <= 0 )
				{
					$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionRequired")) 	
					berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.descriptionRequired") + '</p>';
				}
				
				if (descr.length > MAX_DESCR_LENGTH) { 
		 			$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
		 			berror = true;
					errorDetails = '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH + '</p>';
				}
				
				if($(VERSION2).val().length <= 0)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionRequired"))
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionRequired") + '</p>';
				}
				
				if($(VERSION2).val().length > MAX_VER_LENGTH)
				{
					$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH);
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH + '</p>';
				}
				
				if($(TARGET_LOCATION).val().length <= 0)
				{
					$('#hpsum-cbl-targetloc-error').html(localizer.getString("hpsum.baseline.custom.targetlocRequired"))
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.targetlocRequired") + '</p>';
				}

				var descrcheck = /^[\w\-\s]+$/;   
					
			    if ( !descrcheck.test(descr) )
			    {       				
			    	$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.descriptionValidationMsg"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.descriptionError") + localizer.getString("hpsum.baseline.custom.descriptionValidationMsg") + '</p>';
		 		}
				
				//var versioncheck = /^[\d]+$/;   
					
			   // if ( !versioncheck.test($(VERSION2).val()) )
			    if ($(VERSION2).val() == '')
			    {       				
			    	$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.versionIdentifierError"));
		 			berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.versionError") + localizer.getString("hpsum.baseline.custom.versionIdentifierError") + '</p>';
		 		}
				
				if($(BOOTABLEISO_CHKBOX)[0].checked && $(ISO_LOCATION).val().length <= 0)
				{
					$('#hpsum-cbl-isoloc-error').html(localizer.getString("hpsum.baseline.custom.isolocRequired"))
					berror = true;
					errorDetails += '<p>' + localizer.getString("hpsum.baseline.custom.isolocRequired") + '</p>';
				}
				
				if(berror)
				{
					formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.validationErrorMsg"),
                                status: 'error',
                                details: errorDetails});
                                
					return false;
				}
					
				var verstr = $(DATE_VERSION).val();
				verstr = verstr.replace(/\-/g, '.');
				verstr = verstr + '.' + $(VERSION2).val();
				
				var bundlename = $(BASELINE_NAME_LABEL).html();
				
				var criticalityopt = '';
				if($('#chkbox-critical')[0].checked)
				{
					criticalityopt = "critical";
				}
				
				if($('#chkbox-recommended')[0].checked){
					if(criticalityopt.length > 0)
						criticalityopt += "|" + "recommended";
					else
						criticalityopt = "recommended";
				}
				
				if($('#chkbox-optional')[0].checked){
					if(criticalityopt.length > 0)
						criticalityopt += "|" + "optional";
					else
						criticalityopt = "optional";
				}
				
				var oslist = [], devicelist = [];
				//if($('#chkbox-os-win2k3r2')[0].checked) {
				//	oslist.push('Window2003');
				//}
				
				var updatetype='';
				
				if($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i))
                {
                	updatetype = 'software|firmware';	
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
                {
                	updatetype = "software";
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
                {
                	updatetype = "firmware";
                }
				
				var isolocation = $(ISO_LOCATION).val();
				var targetlocation = $('#hpsum-custom-baselines-targetloc').val();
				
				var bcreateiso = false, bbootableiso = false;
				if($('#chkbox-createiso')[0].checked)
					bcreateiso = true;
					
				if($('#chkbox-bootableiso')[0].checked)
					bbootableiso = true;
				
					
				var archopt='';
				if($('#chkbox-arch-x86')[0].checked)
				{
					archopt = "x86";
				}
				
				if($('#chkbox-arch-x64')[0].checked){
					if(archopt.length > 0)
						archopt += "|" + "x64";
					else
						archopt = "x64";
				}
				
				var serverlist = [];
				/*if($('#chkbox-server-dl380')[0].checked) {
					serverlist.push('Window2003')
				}*/
				
				var selBaselines = [];
				
				for(var i=0; i < selectedTablesID.length; i++)
				{
					var oTable = $(selectedTablesID[i].table_id).dataTable();
					if(oTable == undefined)
						continue;
					
					var selectedRows = $(selectedTablesID[i].table_id + ' tbody tr');
					
					var comps = oTable.fnGetData();
					var components = [];
					
					for(var tmp=0; tmp < selectedRows.length; tmp++){
		 				var compData = oTable.fnGetData(selectedRows[tmp].rowIndex-1);
		 				var bselected = false, bforce = false;
		 				
		 				if(selectedRows[tmp].className.indexOf('hp-selected') != -1)
		 					bselected = true;
		 				else
		 					bselected = false;
		 					
		 				if(bselected)
		 					components.push(compData.component_file_name);
		 			}
					
					var baselineinfo = {
					          baseline_name : selectedTablesID[i].baseline,
					          component: components
					       };
					
					selBaselines.push(baselineinfo);	
				}
				
				if(bsaveas) {
					bcreateiso = false;
					bbootableiso = false;
				}
								
				var item = {
					  hapi: {
					    bundle_name: bundlename,
					    bundle_header: descr,
					    criticality: criticalityopt,
					    os_type_list: {
					      os_type: oslist
					    },
					    device_type_list: {
					      device_type: devicelist
					    },
					    update_type: updatetype,
					    target_location: targetlocation,
					    iso_location: isolocation,
					    create_ISO: bcreateiso,
					    bootable_ISO: bbootableiso,
					    version: verstr,
					    architecture: archopt,
					    server_type_list: {
					      server_name: serverlist
					    },
					    baseline_list: {
					      baseline: selBaselines
					    }
					  }
					}; 
				
				if(! addInProgress) {
                    addInProgress = true;
                    $("#hpsum-custom-baselines-add-form :input").prop("disabled", true);
                    
                    formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.createCBLMsg"),
                        status: 'unknown', changing: true});
                    
                    presenter.createCustomBaseline(item, CreateCustomBaselinehandlers);
                    
                    formStateView.reset();
                    
                    if($('#chkbox-runinback')[0].checked){
                    	$(CANCEL).trigger('click');
                    }
                    
                }
				
				return false;
            }
            
            function createCustomBaselineSuccess(data) {
            	
            	formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.createCBLMsgSuccess"),
                                status: 'ok',
                                details: ''});
                
                
                if($('#chkbox-runinback')[0].checked == false)
                	cblCreateStatusUpdate(data);
                	
            }
            
            function cblCreateStatusUpdate(data){
            	
            	var bStopTimer = false;
            	
            	var timer = setInterval(function () {
            		BaselinePresenter.getCustomBaselineStatus(data, {
            					success : function(data) {
                    				formStateView.setMessage({
		                                summary: data.hapi.location_state.replace(/_/g, ' '),
		                                status: 'ok',
		                                changing: true,
		                                details: data.hapi.location_info}
		                            );
                    				if(data.hapi.location_state === "custom_baseline_creation_completed") {
                    					formStateView.setMessage({
			                                summary: data.hapi.location_state.replace(/_/g, ' '),
			                                status: 'ok',
			                                changing: false,
			                                details: data.hapi.location_info
			                                }
		                              	);
		                              	
		                              	clearInterval(timer);
	                					timer = null;
	                					addInProgress = false;
	                					$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
	                					reset(false);
	                				}
                    			},
                    			error : function(errorInfo) {
                        			formStateView.setMessage({
		                                summary: data.hapi.location_info,
		                                status: 'error',
		                                changing: false,
		                                details: data.hapi.location_state
		                                }
		                            );
		                            
		                            clearInterval(timer);
	                				timer = null;
                    			}
                			});
                }, 3000);
            }
            
            function createCustomBaselineError(errorinfo) {
            	addInProgress = false;
            	
            	formStateView.setMessage({
                                summary: localizer.getString("hpsum.baseline.custom.createCBLMsgError"),
                                status: 'error',
                                details: errorinfo});
                
                $("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
            }
            
            function cblGetStatusSuccess(data) {
            	//show current status
            }
            
            function cblGetStatusError(error) {
            	
            }
			
			function changeLocation(location) {
                if (location.length > ROUTE_PREFIX.length) {
                    $(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
                } else {
                    $(PANELS).hpStackedPanels('setFirstPanel');
                }
            }
			
			function onAddBaseline() {
                
                if(addInProgress)
                	return;
                
                selectedTablesID = [];
                
                var bfirmware, bsoftware;
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/both/i))
                {
                	bfirmware = true;
                	bsoftware = true;
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/software/i))
                {
                	bfirmware = false;
                	bsoftware = true;
                }
                
                if($(SELECT_COMPTYPE).val().toLowerCase().match(/firmware/i))
                {
                	bfirmware = true;
                	bsoftware = false;
                }
            		
                var val;
                //filters list
                var filters = {
                	firmware: bfirmware,
                	software: bsoftware,
                	critical: val = $('#chkbox-critical')[0].checked ? true : false,
                	recommended: val = $('#chkbox-recommended')[0].checked ? true : false,
                	optional: val = $('#chkbox-optional')[0].checked ? true : false,
                	arch_x86: val = $('#chkbox-arch-x86')[0].checked ? true : false,
                	arch_x64: val = $('#chkbox-arch-x64')[0].checked ? true : false,
                	//os_win2003r2: val = $('#chkbox-os-win2k3r2')[0].checked ? true : false,
                	os_win2008: val = $('#chkbox-os-win2k8')[0].checked ? true : false,
                	os_win2008r2: val = $('#chkbox-os-win2k8r2')[0].checked ? true : false,
                	os_win2012: val = $('#chkbox-os-win2012')[0].checked ? true : false,
                	os_rhel5: val = $('#chkbox-os-rhel5')[0].checked ? true : false,
                	os_rhel6: val = $('#chkbox-os-rhel6')[0].checked ? true : false,
                	os_sles10: val = $('#chkbox-os-sles10')[0].checked ? true : false,
                	os_sles11: val = $('#chkbox-os-sles11')[0].checked ? true : false,
                	os_vmware50: val = $('#chkbox-os-vmware50')[0].checked ? true : false,
                	os_vmware51: val = $('#chkbox-os-vmware51')[0].checked ? true : false,
                	os_vmware55: val = $('#chkbox-os-vmware55')[0].checked ? true : false,
                	//device_server: val = $('#chkbox-dev-server')[0].checked ? true : false,
                	device_oa: val = $('#chkbox-dev-oa')[0].checked ? true : false,
                	device_ilo: val = $('#chkbox-dev-ilo')[0].checked ? true : false,
                	device_nic: val = $('#chkbox-dev-nic')[0].checked ? true : false,
                	device_fchba: val = $('#chkbox-dev-fchbacna')[0].checked ? true : false,
                	device_arrayctrl: val = $('#chkbox-dev-arrayctrl')[0].checked ? true : false,
                	device_vc: val = $('#chkbox-dev-vc')[0].checked ? true : false,
                	device_sasswitches: val = $('#chkbox-dev-sasswitches')[0].checked ? true : false,
                	device_systemrom: val = $('#chkbox-dev-systemrom')[0].checked ? true : false,
                	device_tape: val = $('#chkbox-dev-tape')[0].checked ? true : false,
                	device_fcswitches: val = $('#chkbox-dev-fcswitches')[0].checked ? true : false,
                	device_harddrive: val = $('#chkbox-dev-harddrive')[0].checked ? true : false
                	
                	//server_dl380: val = $('#chkbox-server-dl380')[0].checked ? true : false,
                	//server_dl360: val = $('#chkbox-server-dl360')[0].checked ? true : false
                };
                
                populateComponents(filters);
                
                enableActionButtons();
            }
            
            function populateBaselines() {
            	
            	
            	formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateSourcesMsg"), status: 'ok', changing: true});
            	
            	if(oTableBaselines)
				{
					oTableBaselines.fnClearTable();
				}
				
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getBaselineSuccess(data);
                    		 	},
                    			error : function(errorInfo) {
                    				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateSourcesErrorMsg") + errorInfo, status: 'error', changing: true});
                        			getBaselineError(errorInfo);
                    			}
                		};
                
                BaselinePresenter.getBaselinesAll(handlers);
            }
            
            function getBaselineSuccess(baselines) {
            	
            	if(oTableBaselines)
            	{
            		for(var i=0; i < baselines.length; i++)
            		{
            			if( baselines[i].baseline_state === "inventory_in_progress" || 
	                   		baselines[i].baseline_state === "comp_download_in_progress" ||
			   				baselines[i].baseline_state === "reading_web_catalog" ||
			   				baselines[i].baseline_state === "reading_manifest_xml" ||
			   				baselines[i].baseline_state === "manifest_component_processing") {

            				//We shall show the warning and close this dialog
            			 var dialog = new dialogview({
                       				 contents: dialogContent,
                        				ok: function(elem) {
                            					$(CANCEL).trigger('click');
                        				}	
                    				});
            			    $('#'+'hpsum-confirmation-dialog-title').html("Information");
            			    $('#'+'hpsum-confirm-text').html(" Cannot create custom baseline when some of the baselines are still being inventoried");

            				return;
            			}
	                	
	                	

            			var item = [{
            				name: baselines[i].baseline_name,
            				version: baselines[i].baseline_version,
            				location: baselines[i].baseline_url,
            				baselineid: baselines[i].baseline_id,
            				uri: baselines[i].baseline_uri,
            				osdata: null
            			}];

            			
            			oTableBaselines.fnAddData(item);
            			
            			//get os data for the baseline
            			getOSData(baselines[i].baseline_uri);
            		}
            		
            		$(SOURCES_TABLE + ' tbody tr').last().addClass('hp-selected');
            		
            		//enable selection and deselection of row
					$(SOURCES_TABLE + " tbody tr").click( function( e ) {
						//toggle row selection	
						$(this).toggleClass('hp-selected');
					});	
            	}
            }
            
            function getBaselineError(error) {
                
            } 
            
            function getOSData(uri) {
            	
            	formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateComponentOsMsg"), status: 'ok', changing: true});
            	
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getOsDataSuccess(data, uri);
                    		 	},
                    			error : function(errorInfo) {
                    				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.populateComponentOsErrorMsg") + errorInfo, status: 'error', changing: true});
                        			getOsDataError(errorInfo);
                    			}
                		};
                
                BaselinePresenter.getosname(uri, handlers);
            }
            
            function  getOsDataSuccess(data, uri) {
            	
            	var sourceTable = $(SOURCES_TABLE).dataTable();
	            
	            var sources;
	            
	        	if(sourceTable)
	        		sources = sourceTable.fnGetData();
	        	
	        	if(sources.length > 0)
	        	{
	        		for(var i=0; i < sources.length; i++)
        			{
        				if(sources[i].uri == uri)
        				{
        					sourceTable.fnUpdate(data, i, 5);
        					break;
        				}
        			}
        		}
        		
        		formStateView.reset();
            }
            
            function  getOsDataError(data) {
            }
            
            function populateComponents(filters) {
            	
            	$('#all-cbl-baselines').empty();
            	
            	//var oTableBaselines = $(SOURCES_TABLE).dataTable();
            	var baselines = [], selectedRows;
            	if(oTableBaselines)
            	{
					baselines = oTableBaselines.fnGetData();
					
					selectedRows = $(SOURCES_TABLE + ' tbody tr.hp-selected');
			 	} 
			 	
			 	var tableid = '#hpsum-cbl-table-review'; //+ nodeData.baselineid;
            	    
            	for(var tmp=0; tmp < selectedRows.length; tmp++){
	 				var nodeData = oTableBaselines.fnGetData(selectedRows[tmp].rowIndex-1);
	 				
	 				selectedTablesID.push({table_id : tableid, baseline: nodeData.baselineid});
                    
                    $('#all-cbl-baselines').append('<table class="hp-selectable" id="hpsum-cbl-table-review"><thead><tr><td><b>' + 
                            localizer.getString("hpsum.baseline.addBaseline.id") + '</b></td><td><b>' +
                            localizer.getString("hpsum.baseline.addBaseline.description") + '</b></td><td><b>' + 
                            localizer.getString("hpsum.baseline.version") + '</b></td>' + //<td><b>' + 
                            //localizer.getString("hpsum.baseline.addBaseline.configured") + '</b></td>
                            '</tr></thead></table>');
					
					//initialize table
					initBaselineTable(tableid);
					
					//populate table rows 
					populateTable(tableid, nodeData.uri, filters, nodeData.osdata);	 					
	 			}
		 	}
            
            function populateTable(tableid, uri, filters, osdata){
            	
            	//get all the baselines based on filter condition
            	var handlers =	{
                    			success : function(data) {
                        			getBundleDataSuccess(data, tableid, filters, osdata);
                        			formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsgDone"), status: 'ok', changing: false});
                    		 	},
                    			error : function(errorInfo) {
                        			getBundleDataError(errorInfo);
                        			formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsgError"), status: 'error', changing: false});
                    			}
                			}
                
                var list = uri.split("/");
				var locid = list[5];
				var baselineid = list[7];
					
                var item = 	{
                				location_id: locid,
				        		baseline_id: baselineid
				        	};
				
				formStateView.setMessage({summary: localizer.getString("hpsum.baseline.custom.retrieveCompMsg"), status: 'unknown', changing: true});
                        
            	//add component rows into table based on the filters
            	BaselinePresenter.getBundleIndexData(item, handlers);
            	
            }
            
            //Function to find a substring in an array
            //return true if substring found
            //return false if substring is not found in the array
            function isExists(arr, str) {
            	
            	var bFound = false;
            	
            	var result = $.grep(arr, function (value) {
                      var search = new RegExp(str, "gi");
                      if(value.match(search)) return true;
                      return false;
                    }
                 );
            	
            	if(result.length > 0)
            		bFound = true;
            	
            	return bFound;
            }
            
            function getBundleDataSuccess(data, tableid, filters, osdata) {
            	
            	var oTable = $(tableid).dataTable();
            	
            	if(!oTable)
            		return;
            	
            	var comps_matched = $.grep(data.hapi.components.component, function(comp, index) {
						                            return (
						                            	(filters.software === true && (comp.product_typeInString === 'Driver' || comp.product_typeInString === 'Software')) ||
						                            	(filters.firmware === true && comp.product_typeInString === 'Firmware')
						                            	);
				});
				
				if(filters.critical || filters.recommended || filters.optional) {
					comps_matched = $.grep(comps_matched, function(comp, index) {
							                            return (
							                            	(filters.critical === true && comp.criticality === 'Critical') ||
							                            	(filters.recommended === true && comp.criticality === 'Recommended') ||
							                            	(filters.optional === true && comp.criticality === 'Optional')
							                            	);
					});
				}
				
				if(filters.arch_x86 || filters.arch_x64) {
					comps_matched = $.grep(comps_matched, function(comp, index) {
							                            return (
							                            	(filters.arch_x86 === true && (comp.platform.match(/x86$/i) || comp.platform.match(/nt$/i))) ||
						                            		(filters.arch_x64 === true && (comp.platform.match(/x86_64$/i) || comp.platform.match(/ia64$/i) || comp.platform.match(/x86-64$/i) || comp.platform.match(/nt64$/i) || comp.platform.match(/amd64$/i)))
							                            	); 
					});
				}
				
				if(filters.device_oa || filters.device_nic || filters.device_ilo || filters.device_vc || filters.device_arrayctrl || 
					filters.device_sasswitches || filters.device_tape || filters.device_systemrom || filters.device_harddrive || 
					filters.device_fcswitches || filters.device_fchba) {
					comps_matched = $.grep(comps_matched, function(comp, index) {
							                            return (
							                            	(filters.device_oa === true && comp.product_subtypeInString === 'OA') ||
							                            	(filters.device_nic === true && (comp.product_subtypeInString == 'NIC' || comp.product_subtypeInString == 'Intel NIC' || comp.product_subtypeInString == 'NetXEN NIC')) ||
							                            	(filters.device_ilo === true && comp.product_subtypeInString.indexOf('Management Processor') != -1) ||
							                            	(filters.device_vc === true && comp.product_subtypeInString === 'VC') ||
							                            	(filters.device_arrayctrl === true && comp.product_subtypeInString === 'Array Controller') ||
							                            	(filters.device_sasswitches === true && comp.product_subtypeInString === 'Solex') ||
							                            	(filters.device_tape === true && comp.product_subtypeInString == 'Tape') ||
							                            	(filters.device_systemrom === true && comp.product_subtypeInString === 'BIOS') ||
							                            	(filters.device_harddrive === true && comp.product_subtypeInString.indexOf('Hard Drive') != -1) ||
							                            	(filters.device_fcswitches === true && (comp.product_subtypeInString == 'Brocade' || comp.product_subtypeInString == 'Cisco' || comp.product_subtypeInString == 'QLogic')) ||
							                            	(filters.device_fchba === true && (comp.product_subtypeInString == 'Brocade' || comp.product_subtypeInString == 'Emulex' || comp.product_subtypeInString == 'QLogic')) 
							                            	);
					});
				}
				
				//filter components based on OS filter 
				if(filters.os_win2008 || filters.os_win2008r2 || filters.os_win2012 ||
					filters.os_rhel5 || filters.os_rhel6 || filters.os_sles10 || filters.os_sles11 || filters.os_vmware50 || 
					filters.os_vmware51 || filters.os_vmware55) 
				{
					//filter osdata components first as per the matching os filter list
					var os_comps = osdata.hapi.components.component;
					var os_comps_matched = $.grep(os_comps, function(comp, index) {
							var oslist = comp.operating_systems.Operating_system_name;
							return (
								(filters.os_win2008 == true && isExists(oslist, 'Microsoft Windows Server 2008') == true)  ||
								(filters.os_win2008r2 == true && isExists(oslist, 'Microsoft Windows Server 2008 R2') == true)  ||
								(filters.os_win2012 == true && isExists(oslist, 'Microsoft Windows 8') == true)  ||
								(filters.os_rhel5 == true && isExists(oslist, 'Red Hat Enterprise Linux 5 Server') == true)  ||
								(filters.os_rhel6 == true && isExists(oslist, 'Red Hat Enterprise Linux 6 Server') == true)  ||
								(filters.os_sles10 == true && isExists(oslist, 'SUSE LINUX Enterprise Server 10') == true)  ||
								(filters.os_sles11 == true && isExists(oslist, 'SUSE LINUX Enterprise Server 11') == true)  ||
								(filters.os_sles10 == true && isExists(oslist, 'SUSE LINUX Enterprise Server 10') == true) || 
								(filters.os_vmware50 == true && (isExists(oslist, 'VMware ESXi 5.0') == true || isExists(oslist, 'VMware vSphere 5.0') == true)) || 
								(filters.os_vmware51 == true && (isExists(oslist, 'VMware ESXi 5.1') == true || isExists(oslist, 'VMware vSphere 5.1') == true)) ||
								(filters.os_vmware55 == true && (isExists(oslist, 'VMware ESXi 5.5') == true || isExists(oslist, 'VMware vSphere 5.5') == true))
								
							); 
					});
					
					//then filter comps_matched based on os_comps_matched list.. include the matching components from both the list
					comps_matched = $.grep(comps_matched, function(comp, index) {
										
									if ($.grep(os_comps_matched, function(comp2, index2) {
			                            return (comp2.component_file_name === comp.component_file_name);
			                        }).length > 0) {
			                            return true;
			                        }
			                        
			                        return false;					
					});
					
				}
				
				if(comps_matched.length > 0)
            	{
            		oTable.fnAddData(comps_matched);
            		
            		$(tableid + ' tbody tr').addClass('hp-selected');
            		NO_COMP_SELECTED = false;
            		enableActionButtons();
            			
            	}
            	
            	$(tableid + " tbody tr").click( function( e ) {
            		//toggle row selection	
					$(this).toggleClass('hp-selected');	
					var selectedRows = $(tableid + ' tbody tr');
 					    var count = 0;
 					    for (var tmp = 0; tmp < selectedRows.length; tmp++) 
 					    {
 					       	if (selectedRows[tmp].className.indexOf('hp-selected') != -1)
 					    	count++;
 					    }
 					    	
						if(count > 0)
						{
							NO_COMP_SELECTED = false;
							enableActionButtons();							
						}
						else
						{
							NO_COMP_SELECTED = true;	
							disableActionButtons();							
						}				
											
										
				});
            	
            }
            
            function getBundleDataError(error) {
            }
            
            //Initialize install review table to add all the components
            function initBaselineTable(tableid) {
            	
            	var data = [{
            				component_file_name: 'cp0000.exe',
            				package_name: 'HP Package',
            				component_version: '2012.10.10', 
                			Configured: 'Yes'}];
				    
				var oTab = $(tableid).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.baseline.custom.noMatchingComponents")
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : true,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'component_file_name'},
				        {mDataProp: 'package_name'},
				        {mDataProp: 'component_version'}/*,
				        {mDataProp: 'configured'}*/],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        
				        return nRow;
				    }
				    });
			 
				$(tableid + ' tbody tr').first().addClass('hp-selected');
			}
			
			//Initialize Baseline sources table to list all the available baselines
            function initSourcesTable() {
            	
            	var data = [{
            				name: 'HP Proliant SPP',
            				version: '2013.04.23',
            				location: 'C:/SPP',
            				baselineid: 'bp0001',
            				uri: 'baseline/location..../bp00001',
            				osdata: 'obj'
            				}];
				    
				var oTab = $(SOURCES_TABLE).dataTable({
					oLanguage: {
								sEmptyTable: localizer.getString("hpsum.baseline.custom.noBaselinesAvailable")
							   },
				    bPaginate : false,
				    bProcessing : true,
				    bFilter : false,
				    bSort : false,
				    bAutoWidth : false,
				    bInfo : false,
				    bRetrieve : true,
				    bDestroy : true,
				    aoColumns : [
				    	{mDataProp: 'name'},
				    	{mDataProp: 'version'},
				        {mDataProp: 'location'},
				        {mDataProp: 'baselineid', "bVisible": false},
				        {mDataProp: 'uri', "bVisible": false},
				        {mDataProp: 'osdata', "bVisible": false}
				        ],
				    aaSorting: [],
				    fnRowCallback : function( nRow, aData, iDisplayIndex, iDisplayIndexFull ) {
				        //$(nRow).attr('id', aData.component_file_name);
				        return nRow;
				    }
				    });
			 
				$(SOURCES_TABLE + ' tbody tr').first().addClass('hp-selected');
				
				oTableBaselines = $(SOURCES_TABLE).dataTable();
			}
            
            function enableActionButtons()
			{
				if(addInProgress)
					return;
					
				var descr = $(DESCR).val(); 
				if (descr.length <= 0 )
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
				
				if($(DATE_VERSION).val().length <= 0)
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
				
				if($(TARGET_LOCATION).val().length <= 0)
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
		
				if (NO_COMP_SELECTED)
				{
					$(CREATE).attr("disabled", true);
					$(SAVEAS).attr("disabled", true);
					return false;
				}
				
				if(!berror)
				{
					cleanErrorMessage();
				}
				
				if($('#chkbox-bootableiso')[0].checked)
					if($(ISO_LOCATION).val().length <= 0)
					{
						$(CREATE).attr("disabled", true);
						$(SAVEAS).attr("disabled", true);
						return false;
					}
				
				$(CREATE).attr("disabled", false);
          		$(SAVEAS).attr("disabled", false);
			}
			
			function disableActionButtons()
			{
				$(CREATE).attr("disabled", true);
          		$(SAVEAS).attr("disabled", true);
			}
			
			function cleanErrorMessage()
			{
				
				$('#hpsum-cbl-descr-error').empty();
				$('#hpsum-cbl-version-error').empty();
				$('#hpsum-cbl-targetloc-error').empty();
				berror = false;
			}
			
			/**
             * * Reset all the fields such as descr, versions, target location etc
            */
			function reset(bResetFormState)
          	{
          		NO_COMP_SELECTED = true;
          		addInProgress = false;
          		
          		$(CREATE).attr("disabled", true);
          		$(SAVEAS).attr("disabled", true);
          		
          		//empty all text boxes and checkboxes
          		$(':text').val('');
          		$(':checkbox').attr('checked', false);
          		$(DESCR).val('');
          		$(BASELINE_NAME_LABEL).html('');
          		
          		//This will create a custom baseline name with current values
            	var descr = $(DESCR).val(), name, curDateVersion, monthValue;
				descr = descr.replace(/\s+/g, '-').toLowerCase();
				curDateVersion = new Date();
				
				//Avoid adding an unnecessary '-' to the name when description is emppty
	          	if (descr != '') {
	          		//getMonth() returns month from 0 - 11 range, hence adding 1 to the getMonth() result
	          		monthValue = curDateVersion.getMonth() + 1;
					name = 'bp-' + descr + '-' + curDateVersion.getFullYear() + '-' + monthValue + '-' + curDateVersion.getDate();
				} else {
					//getMonth() returns month from 0 - 11 range, hence adding 1 to the getMonth() result
					monthValue = curDateVersion.getMonth() + 1;
					name = 'bp' + descr + '-' + curDateVersion.getFullYear() + '-' + monthValue + '-' + curDateVersion.getDate();
				}
	          	$(BASELINE_NAME_LABEL).html(name);
	          	
	          	//This will initialize date picker with current date version
				$(DATE_VERSION).datepicker('setDate', new Date());

				$('#chkbox-createiso').attr('checked',true); 
				$('#chkbox-bootableiso').attr('checked',false);
				
				//clear tables
				$('#all-cbl-baselines').empty();
							
				cleanErrorMessage();
				
				if(bResetFormState) {
					formStateView.reset();
					populateBaselines();
				}
          	}
          	
          	/**
             * * Initialize event functions for fields such as descr, target location, version etc
            */
          	function initialize() {
	          		
          		$(DATE_VERSION).change(function(ev) {
          			var descr = $(DESCR).val(), name;
					//replacing spaces with dashes
					descr = descr.replace(/\s+/g, '-').toLowerCase();
					
					//Avoid adding an unnecessary '-' to the name when description is emppty
					if (descr != '') {
	          	 		name = 'bp-' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	}
	          	 	else {
	          	 		name = 'bp' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	}
	          		$(BASELINE_NAME_LABEL).html(name);
	          	});
	          			
          		$(VERSION2).blur(function(){
					var descr = $(DESCR).val(), name;
					//replacing spaces with dashes
					descr = descr.replace(/\s+/g, '-').toLowerCase();
					
					//Avoid adding an unnecessary '-' to the name when description is emppty
	          		if (descr != '') {
	          	 		name = 'bp-' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	}
	          	 	else {
	          	 		name = 'bp' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
	          	 	}
	          		$(BASELINE_NAME_LABEL).html(name);
	          		
	          		enableActionButtons();
          		});
          	
          		$(DESCR).bind('keypress', function (event) {
          			
          			var theEvent = event || window.event;
					var key = theEvent.keyCode || theEvent.which;
					
					var keychar = String.fromCharCode(key);
					
					var keycheck = /^[\w\-\s]+$/;   
					
					if (!(key == 8  ||  key == 27  || key == 46  || key == 37 || key == 39)) // backspace delete  escape arrows
					{
					    if ( !keycheck.test(keychar) )
					    {       
					        theEvent.returnValue = false;//for IE
							
							if (theEvent.preventDefault) 
								theEvent.preventDefault();//Firefox
						}
						else
							return true;
					}
					
					return theEvent.returnValue;
  				});
          		   
          				
          		$(DESCR).blur(function(){
          			if($(DESCR).val().length <= MAX_DESCR_LENGTH)
          			{
          				$('#hpsum-cbl-descr-error').empty();
          				
          				var descr = $(DESCR).val(), name;
						//replacing spaces with dashes
						descr = descr.replace(/\s+/g, '-').toLowerCase();
		          		
		          		//Avoid adding an unnecessary '-' to the name when description is emppty
						if (descr != '') {
							name = 'bp-' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
						} else {
							name = 'bp' + descr + '-' + $(DATE_VERSION).val() + '-' + $(VERSION2).val();
						}

		          		$(BASELINE_NAME_LABEL).html(name);
          			}
          			enableActionButtons();
          		});
          		
          		$(TARGET_LOCATION).blur(function(){
					enableActionButtons();
          		});
          		
          		$(ISO_LOCATION).blur(function(){
					enableActionButtons();
          		});
          		
          		$(VERSION).keydown(function(e){
			    	e.preventDefault();
				});
				
				$(VERSION1).keydown(function(e){
					e.preventDefault();
				});
				
				$(VERSION2).bind('keypress', function (event) {
					
					var theEvent = event || window.event;
					var key = theEvent.keyCode || theEvent.which;
					
					var keychar = String.fromCharCode(key);
					
					var keycheck = /^[a-zA-Z0-9]+$/;
					
					if (!(key == 8  ||  key == 27  || key == 46  || key == 37 || key == 39)) // backspace delete  escape arrows
					{
					    if ( !keycheck.test(keychar) )
					    {       
					        theEvent.returnValue = false;//for IE
							
							if (theEvent.preventDefault) 
								theEvent.preventDefault();//Firefox
						}
						else
							return true;
					}
					
					return theEvent.returnValue;
				});
				
				$(VERSION2).keydown(function(e){
					var key = e.which || e.keyCode;
					
					if (!e.shiftKey && !e.altKey && !e.ctrlKey &&
                     // comma, period and minus, . on keypad
                        key == 190 || key == 188 || key == 109 || key == 110 ||
                     // Backspace and Tab and Enter
                        key == 8 || key == 9 || key == 13 ||
                     // Home and End
                        key == 35 || key == 36 ||
                     // left and right arrows
                        key == 37 || key == 39 ||
                     // Del and Ins
                        key == 46 || key == 45)
                    {
                    	if($(VERSION2).val().length <= MAX_VER_LENGTH)
                    		$('#hpsum-cbl-version-error').empty();
                    	
                        return true;
                    }
					
					
					if ($(VERSION2).val().length < 2) {
						return true;
					} else {
						$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + 2);
					}

                    	
                    /*if (
                     // numbers   
                        key >= 48 && key <= 57 ||
                     // Numeric keypad
                        key >= 96 && key <= 105 )
                    {
                    	if($(VERSION2).val().length <= MAX_VER_LENGTH)
                    	{
                    		return true;
                    	}
                    	else
                    	{
                    		$('#hpsum-cbl-version-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_VER_LENGTH);
                    	}
                    }*/

                    e.preventDefault();
				});
				
				
				$(DESCR).keydown(function(event) {
					
					var currentLen = $(DESCR).val().length;
			        
					if (currentLen > MAX_DESCR_LENGTH) { 
			 			// Trim the field current length over the maxlength.
						$(DESCR).val($(DESCR).val().slice(0, MAX_DESCR_LENGTH));
						$('#hpsum-cbl-descr-error').html(localizer.getString("hpsum.baseline.custom.maxlen") + MAX_DESCR_LENGTH);
			 			event.preventDefault();
			 			return false;
					}
					else
					{
						return true;
					}
			  	});	
          		
          	}
          	
          	/**
             * * Initialize and display browse dialog.
             * * User can navigate to any folder and choose a valid baseline location 
             */
            function initBrowseDialog(inputType){
            	var id = '';
            	
            	if(inputType === 'target')
            		id = TARGET_LOCATION;
            		
        		if(inputType === 'iso')
        			id = ISO_LOCATION;
            	
            	new DialogView({contents: browseDialogContents,
                	position : "center",
                    ok: function (elem) {
                    	
                    	var node = $(BROWSE_TREE).jstree('get_selected');
                    	if(node[0] == null)
                    	{
                    		return false;
                    	}
                    	$(id).val(node[0].id);
                    	//$(CREATE).attr("disabled", false);
                    },
                    cancel: function () {
                    	$(id).val('');
                    }
                });
            }
            
            /**
             * * Create a JsTree inside the browse dialog.
             * * This includes operations such as JSON data load through AJAX call, configuration of tree etc.
             */
            function createTree(inputType){
            	
            	var id = '';
            	
            	if(inputType === 'target')
            		id = TARGET_LOCATION;
            		
        		if(inputType === 'iso')
        			id = ISO_LOCATION;
            	
            	var uri = "Session/" + session.getToken()  + "/Baseline/browse";
				var initial_folder = $(id).val();
				
				$(BROWSE_TREE).empty();
                $(BROWSE_TREE).jstree({
                        "json_data" : {
                        		   "ajax" : {
						           		"url" : function (node) {
	                                        var url;
	                                        if (node == -1) {
	                                            url = "Session/" + session.getToken()  + "/Baseline/browse";
	                                        } else {
	                                            url = null;
	                                        }
	                                        return url;
	                                    },
										"type" : "POST",
					                    "dataType" : "json",
					                    "data" : function (n) { 
												var object = {
														"hapi": {
    														"uri": $(id).val().length > 0 ? $(id).val() : ".."
														}
													}; 
												
												return JSON.stringify(object); 
										},
										"success" : function (output) {
											
											var data = [], children = [], index, node, bAddParent = false;
											
											//hcode has string value in the response payload. This need to be changed later when it is 
											//changed to integer value
											if(output.hapi.hcode != "0")
											{
												//add a node to navigate to parent directory 
												node = {
											        		"data" : "..",
											        		"attr" : { "id" : "..", "rel" : "parent"},
											                "state" : "open",
											               }
											               
											    data.push( node );
												return data;
											}
											
											//iterate through folders and create child nodes
											for(var i=0; i < output.hapi.folders.folder.length; i++ ){
												var folder = output.hapi.folders.folder[i];
												var child, rel;
												
												if(i === 0) 
												{
													var str = $(id).val();
													if(str === '/')
													{
														bAddParent = false;
													}
													else if(i == 0) // && (str.length > 0 && str.indexOf('/') === -1)) 
													{
														bAddParent = true;
														continue;
													}
												}	
												
												//if it is root folder and drive, add the first item as a sibling node instead of parent node
												//change icon if folder is a valid package
												if(folder.possible_package)
													rel = "package";
												else
													rel = "folder";
												
												//take only last folder name from complete path
												//var str = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
												var strfolder, idfolder;
												if(str === '/') {
													strfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/')-1);//folder.folder_name;
													idfolder = folder.folder_name.substring(0, folder.folder_name.indexOf('/'));
												}
												else {
													strfolder = folder.folder_name.substring(folder.folder_name.lastIndexOf('/')+1);
													idfolder = folder.folder_name;
												}
												
												//create children nodes
									        	child = {
									        		"data" : strfolder,
									        		 "attr" : {"id" : idfolder, "rel" : rel}
									        		}
										        children.push( child );
										    }
											
											//add a node to navigate to parent directory 
											node = {
										        		"data" : "..",
										        		"attr" : { "id" : "..", "rel" : "parent"},
										                "state" : "open",
										               }
										               
										    data.push( node );
										    
										    if(bAddParent) {
										    	var rel, val;
										    	if(output.hapi.folders.folder[0].possible_package)
													rel = "package";
												else
													rel = "folder";
													
												if($(id).val() === '')
													val = output.hapi.folders.folder[0].folder_name
												else
													val = $(id).val();
											    //add parent folder to folder list
												node = {
											        		"data" : val,//output.hapi.folders.folder[0].folder_name,
											        		"attr" : { "id" : val, "rel" : rel}, //{ "id" : output.hapi.folders.folder[0].folder_name, "rel" : rel},
											                "metadata" :  output.hapi.folders.folder[0],
											                "state" : "open",
											                "children" : children
											               }
											               
											    data.push( node );
											}
											else
											{
												data.push(children);
											}
											
										                
											return data;
										}
						           }
						},
                        "themes" : {
                                "theme" : "default",
                                "url" : "/css/style.css",
                                "dots" : true,
                                "icons" : true
                        },
                        "plugins" : [ "themes", "json_data", "ui" , "crrm", "types" ],
                        "types" : {
                                "max_depth" : -2,
                                "max_children" : -2,
                                "valid_children" : [ "drive" ],
                                "types" : {
                                        "default" : {
                                                "valid_children" : "none",
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "folder" : {
                                                "valid_children" : [ "default", "folder", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/collapse-closed.png"
                                                }
                                        },
                                        "package" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/status-ok.png"
                                                }
                                        },
                                        "drive" : {
                                                "valid_children" : [ "default", "folder" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/down-arrow.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        },
                                        "parent" : {
                                                "valid_children" : [ "default", "folder", "drive", "package" ],
                                                "icon" : {
                                                        "image" : "/img/hp-piano/grid-collapse.png"
                                                },
                                                "start_drag" : false,
                                                "move_node" : false,
                                                "delete_node" : false,
                                                "remove" : false
                                        }
                                        
                                }
                        }
                })
                .bind("dblclick.jstree", function (event, data) {
                		var node = $(BROWSE_TREE).jstree('get_selected');
                		if(node[0].id === "..")
                		{
                			if(node[0].nextSibling)
                			{
                				var str = $(id).val(); 
                				if(str === '')
                				{
                					$(id).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
                				}
                				else if(str === '/')
                				{
                					
                				}
                				else
                				{
	                				if(str.indexOf('/') != -1)
	                					$(id).val(node[0].nextSibling.id.substring(0, node[0].nextSibling.id.lastIndexOf("/")));
	                				else
	                					$(id).val("/");
	                			}
                			}
                			else
                			{
                				$(id).val("/");
                			}
                		}
                		else 
                		{	
                    		$(id).val(node[0].id);
                    	}
                		
                		$(BROWSE_TREE).jstree("refresh");
                });
            }
            
            function onBootableIsoClick()
            {
            	if($(BOOTABLEISO_CHKBOX)[0].checked)
            		$('#hpsum-bootableiso-opt').show();
            	else
            		$('#hpsum-bootableiso-opt').hide();
            }
          	
          	/**
             * @public
             */
            this.resume = function () {
            	selectedTablesID = [];
            	$(COLLAPSE_ADVFILTERS).hpCollapsible('collapse');
            	$(BASELINE_NAME_LABEL).empty();
				NO_COMP_SELECTED = true;
				$("#hpsum-custom-baselines-add-form :input").prop("disabled", false);
            	reset(true);
            };
            
            this.pause = function () {
            };
            
            /**
             * @public
             * Initialization funtion for the object
             * All the controls actions are initialized in this function.
             */
            this.init = function() {
				
				$('#createiso-chkbox-item').hide(); 
				
				//Let's add date picker to allow user to pick a date
				$(DATE_VERSION).datepicker({dateFormat: 'yy-mm-dd'});
				       	
            	initialize();
            	
            	selectedTablesID = [];
                
                $('#hpsum-cbl-title').text(localizer.getString("hpsum.baseline.custom.createBaseline"));
                
                formStateView.init({form: FORM, routePattern: ROUTE_PREFIX + '.*', autoTrack: true});
                
                
                $(SAVEAS).live('click', function(ev) {
                	disableActionButtons();
                    onCreate(true);
                    ev.preventDefault();
                });
                
                $(CREATE).live('click', function(ev) {
                	disableActionButtons();
                    onCreate(false);
                    ev.preventDefault();
                });
                
                $(RESET).live('click', function(ev) {
                    reset(true);
                    ev.preventDefault();
                });
                
               	$(PANELS).hpStackedPanels({
                    panelSelector : PANEL_SELECTOR
                });

				$(COLLAPSE).hpCollapsible();
				$(COLLAPSE_SYSTEM).hpCollapsible();
				$(COLLAPSE_STORAGE).hpCollapsible();
				$(COLLAPSE_NIC).hpCollapsible();
				$(COLLAPSE_FCHBA).hpCollapsible();
				$(COLLAPSE_ADVFILTERS).hpCollapsible();
				$(COLLAPSE_ARCH).hpCollapsible();
				$(COLLAPSE_OSTYPE).hpCollapsible();
				$(COLLAPSE_DEVTYPE).hpCollapsible();
				//$(COLLAPSE_SERVER).hpCollapsible();

				$(ADDBASELINE).on('click', onAddBaseline);
				
				$(SELECT_COMPTYPE).selectBox({autoWidth: false});
				
				$(BOOTABLEISO_CHKBOX).on('click', onBootableIsoClick);
				
				initSourcesTable();
				
				browseDialogContents = $(BROWSE_DIALOG).detach().show();
                
                $(TARGET_BROWSE_BUTTON).on('click', function () {
                  
                  	initBrowseDialog('target');
                  	
                    createTree('target');
	            });
	            
	            
	            $(ISO_BROWSE_BUTTON).on('click', function () {
                  
                  	initBrowseDialog('iso');
                  	
                    createTree('iso');
	            });
				
				//addbaselineDialogContents = $('#hpsum-cbl-add-baseline-dialog').detach().show();
				
				router.watch('baseline custom section', ROUTE_PREFIX + '.*',
                    {parent: ROUTE_PREFIX, change: changeLocation});
					
                this.resume();
            };
        }

        return BaselineCustomView;
    }());
    
    return new BaselineCustomView();
});
