// (C) Copyright 2013 Hewlett-Packard Development Company, L.P.
/**
 * @type (GroupAddView)
 * This is a view class for adding a new Group.
 */
define(['hpsum/presenter/group/GroupPresenter',
    'hp/core/Router',
    'hp/core/UrlFragment',
    'hp/core/Validator',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
    'hp/core/Localizer',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'lib/jquery.selectBox',
    'lib/jquery.dataTables',
    'hp/lib/jquery.hpCollapsible',
    'hp/lib/jquery.hpSearchCombo',
    'hp/lib/jquery.hpToggle'],
function(presenter, router, urlFragment, validator, FormStateView, helpMenu, localizer) { "use strict";
    	

	var AddView = ( function() {
			// consts can go here
			var ADD = '#hpsum-group-add',
			    CANCEL = '#hpsum-group-add-close',
			    RESET = "#hpsum-group-reset",
			    PANEL_SELECTOR = '#hpsum-group-add-panel-selector',
			    PANELS = '#hpsum-group-add-panels',
			    NAME = '#hpsum-group-name',
			    NAMEERR = '#hpsum-group-name-error',
			    DESC = '#hpsum-group-description',
			    NODES_TABLE = '#hpsum-group-add-nodes-table',
			    ROUTE_PREFIX = '/group/add';

			/**
			 * @constructor
			 */
			function AddView() {

				var formStateView = new FormStateView(),
				    nodes = [],
				    addInProgress = false,
				    selectedAddNodes = [];

				function changeLocation(location) {

					if (location.length > ROUTE_PREFIX.length) {
						$(PANELS).hpStackedPanels('setPanelByLocation', '#' + location);
					} else {
						$(PANELS).hpStackedPanels('setFirstPanel');
					}
				}

				function onItemAddSuccess(data) {
					if (data.hapi.hmessage.match(/Group name already exists/i)) {
						$(NAMEERR).text(localizer.getString('hpsum.group.groupAlreadyExists'));
						$(NAME).addClass("hp-error");
						$(NAMEERR).show();
						$(NAME).keyup(onNameEdit);
						addInProgress = false;
					} else {
						reset();
						addInProgress = false;
						$(CANCEL).trigger('click');

					}
				}

				function onNameEdit() {
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
					$(NAME).unbind('keyup', onNameEdit);
				}

				function onItemAddError(msg) {
					addInProgress = false;
					$(NAMEERR).text(msg);
					$(NAME).addClass("hp-error");
					$(NAMEERR).show();
				}

				function reset() {
					formStateView.reset();
					addInProgress = false;
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");
				}

				function validate() {
					return validateName();
				}

				function validateName() {
					var success = true;
					if ($(NAME).val() == '') {
						$(NAMEERR).text(localizer.getString('hpsum.group.enterGroupName'));
						$(NAME).addClass("hp-error");
						$(NAMEERR).show();
						$(NAME).keyup(onNameEdit);
						success = false;
					}

					return success;
				}

				function getSelectedNodes() {					
					return selectedAddNodes;
				}

				function onAddItem() {
					if (validate()) {
						if (!addInProgress) {
							addInProgress = true;
							var selectedNodes = getSelectedNodes();
							presenter.addItem({
								name : $(NAME).val(),
								description : $(DESC).val(),
								nodes : selectedNodes
							}, true, {
								success : onItemAddSuccess,
								error : onItemAddError
							});
						}
					}

				}

				function getNodesSuccess(results) {
					nodes = presenter.getNodeArray();
					var tableNodes = [];

					for (var idx = 0; idx < nodes.length; ++idx) {
						tableNodes.push({
							node_id: nodes[idx].id,
							name : nodes[idx].name,
							type : nodes[idx].type,
							node_status : nodes[idx].node_status
						});
					}

					$(NODES_TABLE).dataTable().fnClearTable();
					$(NODES_TABLE).dataTable().fnAddData(tableNodes);
					
					selectedAddNodes = [];
					
					$(NODES_TABLE + " tbody tr").click(function(e) {
						var aData = $(NODES_TABLE).dataTable().fnGetData(this),
							selectdNodesLenght = selectedAddNodes.length,
						    idx;
						if ($(this).hasClass('hp-selected')) {
							$(this).removeClass('hp-selected');
							for (idx = 0; idx < selectdNodesLenght; idx += 1) {
								if (selectedAddNodes[idx] === aData.node_id) {
									selectedAddNodes.splice(idx, 1);
									break;
								}
							}
						} else {
							$(this).addClass('hp-selected');
							selectedAddNodes = selectedAddNodes.concat(aData.node_id);
						}
					});

				}

				function getNodesError(msg) {
				}

				/**
				 * @public
				 * Intialize the group edit view.
				 */
				this.init = function() {

					$(PANELS).hpStackedPanels({
						panelSelector : PANEL_SELECTOR
					});

					$(CANCEL).click(function() {
						router.go(urlFragment.replaceView(router.location(), 'show'));
					});

					var dummyNodeData = [];

					$(NODES_TABLE).dataTable({
						oLanguage : {
							sEmptyTable : localizer.getString("hpsum.group.noMoreNodesAvailable")
						},
						bPaginate : false,
						bFilter : true,
						bInfo : false,
						bAutoWidth : false,
						bRetrieve : true,
						aaData : dummyNodeData,
						aoColumns : [{
							mDataProp : 'name'
						}, {
							mDataProp : 'type'
						}, {
							mDataProp : 'node_status'
						}],
						aaSorting : [[1, "asc"]],
						bScrollCollapse : true
					});

					presenter.getAllNodes({
						success : getNodesSuccess,
						error : getNodesError
					});

					$(ADD).live('click', function(ev) {
						onAddItem.call(this);
						ev.preventDefault();
					});

					$(RESET).live('click', function() {
						reset.call();
					});

					router.watch('group add section', ROUTE_PREFIX + '.*', {
						parent : ROUTE_PREFIX,
						change : changeLocation
					});

					this.resume();
				};

				/**
				 * @public
				 * Resume the group edit view.
				 */
				this.resume = function() {
					$(RESET).trigger('click');
					$(NAMEERR).hide();
					$(NAME).removeClass("hp-error");

					presenter.getAllNodes({
						success : getNodesSuccess,
						error : getNodesError
					});
				};

				/**
				 * @public
				 * Pause the group edit view.
				 */
				this.pause = function() {

				};
			}

			return AddView;
		}());

	return new AddView();

	});


