//OM
//Srikanth Bemineni
define([ 'hpsum/presenter/node/NodePresenter',
         'hp/services/REST',
         'hp/core/Localizer',
         'hp/model/Session',
         'hp/core/Router',
         'hp/core/UrlFragment',
         'jquery',
         'hpsum/view/node/jquery.hpsumInstallResults',
         'hp/lib/jquery.hpGridPanels'
        ],
        function( presenter, rest , localizer , session , router , urlfragmentor ){ "use strict";

        //IIFE
        var NodeDeployResults = (function() {

            var CLOSE = '#hpsum-node-install-results-close';
            var INSTALL_RESULTS = '#hpsum-node-install-results';
            var PANELS = '#hpsum-node-install-results-panel';
            var LOG_DETAILS = '#log-details';
            var NODE_TITLE = '#hpsum-node-details-title';
            var COMPONENT_ID = '#hpsum-component-id';


            function NodeDeployResults()
            {

                var node_id;
                function onItemChange(data)
                {
                    var item = data.hapi;
                    //Getting multiple change request.
                    if(node_id === item.node_id)
                        return;
                    
                    node_id = item.node_id;

                    $(INSTALL_RESULTS).hpsumInstallResults("setNodeId",item.node_id);
                    $(INSTALL_RESULTS).hpsumInstallResults("populateTable");
                    $(NODE_TITLE).text(item.name);

                }

                function showLoginTextArea(data)
                {
                    if(data.hapi.components.component[0].component_log.length > 0) {
                        $(LOG_DETAILS).val(data.hapi.components.component[0].component_log);
                    } else {
                        $(LOG_DETAILS).val('ERROR: Unable to retrieve installation logs at this time.');
                    }
                    
                    $(COMPONENT_ID).text(data.hapi.components.component[0].component_id.toUpperCase());
                }

                function showLogError(data)
                {
                    //For now dumping the http error log
                    if(data) {
                        $(LOG_DETAILS).val(data);
                    } else {
                        $(LOG_DETAILS).val('ERROR: Unable to retrieve installation logs at this time.');
                    }
                }

                this.pause = function(){
                    //For now nothing to pause
                    presenter.off('itemChange', onItemChange);
                    node_id = "";
                    $(LOG_DETAILS).val("");
                    $(COMPONENT_ID).text('')
                };

                this.resume = function(){
                    //For now nothing to resume
                    presenter.on('itemChange', onItemChange);
                    $(PANELS).hpGridPanels('reset');
                };

                this.init = function(){

                    
                    $(CLOSE).click(function () {
                        router.go(urlfragmentor.replaceView(router.location(), 'show'));
                    });
                    
                    $(INSTALL_RESULTS).hpsumInstallResults();
                    $(INSTALL_RESULTS).hpsumInstallResults('viewLogHandler', { success:function(data){ 
                                                                                        showLoginTextArea(data); 
                                                                                    },
                                                                                error:function(data){ 
                                                                                        showLogError(data); 
                                                                                    } 
                                                                             } );
                    $(PANELS).hpGridPanels();
                    presenter.on('itemChange', onItemChange);

                    //We will get the current selected item from the presenter.


                };
            }

            return new NodeDeployResults();
        })();

        return NodeDeployResults;
});