// (C) Copyright 2011 Hewlett-Packard Development Company, L.P.
/**
 * @type (NodeShowSchedule)
 * This is a view class for Node Reports menu option.
 */

define(['hpsum/presenter/node/NodePresenter',
    'hp/core/Router',
    'hp/view/FormStateView',
    'hp/core/HelpMenu',
    'jquery',
    'hp/lib/jquery.hpStackedPanels',
    'hp/lib/jquery.hpToggle',
    'lib/jquery.selectBox',
    'hp/lib/jquery.hpPanels'],
function(presenter, router, FormStateView, helpMenu) { "use strict";
    	
    	var ScheduleShowView = (function() {
    		var	FORM = '#hpsum-nodes-schedule-form',
    			RESET = '#hpsum-nodes-reset',
    			FREQPANELS = '#hpsum-nodes-frequency-panels',
    			DAILYPANEL ='#hpsum-node-schedule-daily-panel',
    			WEEKLYPANEL ='#hpsum-node-schedule-weekly-panel',
    			MONTHLYPANEL ='#hpsum-node-schedule-monthly-panel',
    			DAILYRECUR ='#hpsum-node-schedule-recur-daily',
    			WEEKLYRECUR ='#hpsum-node-schedule-recur-weekly',
    			MONTHLYRECUR ='#hpsum-node-schedule-recur-monthly',
    			DATETIMESECTION ='#hpsum-node-schedule-datetimepick',
    			SCHEDULETOGGLE ='#hpsum-node-schedule-enable',
    			FREQOPTION ="hpsum-node-schedule-frequency",
            	ROUTE_PREFIX = '/node/schedule';
           		
    		function ScheduleShowView(){
    			
    		var addInProgress = false;
          
            function reset() {
                $(NAME).val("");
                $(NAME).focus();
                addInProgress = false;
            }
            
            function resetCancel() {
                reset();
            }
            
            function toggleSchedule(cb)
            {
            	if(cb.target.checked){
            		$(DATETIMESECTION).show();
            		$('input[name="hpsum-node-schedule-frequency"]').attr('disabled',false);
            		showFrequencyPanels($("input[name='hpsum-node-schedule-frequency']:checked").val());
            	}
            	else{
            		$(DATETIMESECTION).hide();
            		$('input[name="hpsum-node-schedule-frequency"]').attr('disabled',true);
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).hide();
            	}
            }
            function populateDailyOptions(){
            	$(DAILYRECUR).selectBox('control').unbind('mousedown', populateDailyOptions);
            	for(var i=1; i<20; i++)
            		$(DAILYRECUR).append('<option>' + i + '</option>')
            	$(DAILYRECUR).selectBox('reset');
            }
            
            function showFrequencyPanels(value) {
            	if(value.target)
            		value = value.target.value;
            	if(value == "daily"){
            		$(DAILYPANEL).show();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).hide();
            	}
            	else if(value == "weekly"){
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).show();
    				$(MONTHLYPANEL).hide();
            	}
            	else if(value == "monthly"){
            		$(DAILYPANEL).hide();
            		$(WEEKLYPANEL).hide();
    				$(MONTHLYPANEL).show();
            	}
            }
    			
    		this.init = function() {

    			$(DATETIMESECTION).hide(); 
    			$('input[name="hpsum-node-schedule-frequency"]').attr('disabled','disabled');
    			$('input[name="hpsum-node-schedule-frequency"]').click(showFrequencyPanels);
    			$(DAILYPANEL).hide();
    			$(WEEKLYPANEL).hide();
    			$(MONTHLYPANEL).hide();
    			$(FREQPANELS).hpPanels();
    			$(DAILYRECUR).selectBox({autowidth:false});
    			$(DAILYRECUR).selectBox('control').bind('mousedown', populateDailyOptions);
    			$(WEEKLYRECUR).selectBox({autowidth:false});
    			$(WEEKLYRECUR).selectBox('control').bind('mousedown', populateDailyOptions);
    			$(MONTHLYRECUR).selectBox({autowidth:false});
    			$(MONTHLYRECUR).selectBox('control').bind('mousedown', populateDailyOptions);
    			$(SCHEDULETOGGLE).hpToggle({checked: 'On', unchecked: 'Off'});
    			$(SCHEDULETOGGLE).bind('change',toggleSchedule);           
                $(RESET).live('click', function() {
                    reset.call();
                });
                
                this.resume();
            };
            
            this.resume = function () {
            	$(FREQPANELS).hpPanels('reset');
            };
            
            this.pause = function () {
            };
    		
    	}	
    	return ScheduleShowView;
    }());
    	
    return new ScheduleShowView();	
    		
    });

