#!/bin/sh

pause_exit ()
{
  if [ $skip -eq 0 ]; then
    echo Press Enter to continue
    read foo
  fi
  exit 0
}

rm_temp_file ()
{
  if [ -f /tmp/HPSUM/$1 ]; then
    echo Removing /tmp/HPSUM/$1
    rm -rf /tmp/HPSUM/$1
  else 
    echo /tmp/HPSUM/$1 already deleted
  fi
}


if [ "x$1" = "x-h" ]; then
  echo syntax: $0 [-y] [-h]
  echo         -y = continue without pausing for prompts
  exit 0
fi
if [ "x$1" = "x-y" ]; then
  skip=1
else 
  skip=0
fi

echo HP Smart Update Manager Repository cache delete script
echo                       -
echo Removing HP SUM cache files will require re-entering
echo all baseline locations, nodes and credentials.
echo                       -
echo This script should not be run while HP SUM is running.
echo                       -
if [ $skip -eq 0 ]; then
  echo -n Are you sure you want to delete HP SUM cache files? [y or n] : 
  read ok

  if [ "x$ok" != "xy" ]; then
    echo Exiting without deleting any files.
    pause_exit
  fi
fi

if [ -d /tmp/HPSUM ]; then
  rm_temp_file baseline
  rm_temp_file hpsum.pdb
  rm_temp_file hpsum.pdb-wal
  rm_temp_file hpsum.pdb-shm
  rm_temp_file hpsum_remote.pdb
else
  echo No HP SUM temp directory found to delete at /tmp/HPSUM.
fi
pause_exit

