// (C) Copyright 2012 Hewlett-Packard Development Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var RestoreRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'appliance';

        function RestoreRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;
                
                router.map('settings restore appliance', '/settings/restore/appliance$', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/restore/restore.html',
                            'fs/view/settings/restore/RestoreUploadView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new RestoreRoutes();
    }());

    return RestoreRoutes;
});
