// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
define(['hp/services/REST', 'jquery'], function(REST) {"use strict";

    return {

        removeFile : function(handlers){
            REST.deleteURI('/rest/appliance/firmware/pending', handlers);
        },

        releaseNotes : function(fileName, docType, handlers, options){
            var uri = '/rest/appliance/firmware/document-content/' + fileName + '/' + docType;
            REST.getURI(uri, handlers, options);
        },

        apply : function(fileName, handlers){
            var uri = '/rest/appliance/firmware/pending?file=' + fileName;
            REST.putObject(uri, null, null, handlers);
        },

        currentStatus : function(handlers){
            REST.getURI('/cgi-bin/status/update-status.cgi', handlers);
        },

        usersLoggedIn : function(handlers){
            REST.getURI('/rest/active-user-sessions', handlers);
        }
    };
});
