// (C) Copyright 2011-2013 Hewlett-Packard Development Company, L.P.
/**
 * @type {Map}
 */
define(['hp/model/map/MapRow', 'hp/model/map/MapLink', 'hp/core/Localizer'],
function (MapRow, MapLink, localizer) { "use strict";

    var Map = ( function() {

        function Map() {

            var self = this;
            var rows = [];
            var rowIndex = {};
            var numColumns = 0;
            var nodeIndex = {};
            var selectedNode;
            var highlightedNodes = [];
            var links = [];
            var highlightedLinks = [];
            
            function addLink(parentNode, childNode) {
                var link = new MapLink();
                link.init(self, parentNode, childNode);
                links.push(link);
            }
            
            // reserved for MapLink's use
            this.removeLink = function (link) {
                var index = links.indexOf(link);
                links.splice(index, 1);
                link.destroy();
            }
            
            function getOrCreateRow(category, prepend) {
                var row = rowIndex[category];
                if (! row) {
                    row = new MapRow();
                    row.init(self, category);
                    if (prepend) {
                        rows.unshift(row);
                    } else {
                        rows.push(row);
                    }
                    rowIndex[category] = row;
                }
                return row;
            }
            
            function processTreeNode(treeNode, prepend, associationParams,
                primaryAssociation) {
                var resource = treeNode.resource;
                var row = getOrCreateRow(resource.category, prepend);
                var node = row.getOrCreateNode(treeNode, associationParams,
                    primaryAssociation);
                var parentNode, childNode, params;

                nodeIndex[resource.uri] = node;
                nodeIndex[node.id()] = node; // for summary nodes
                
                // add parents
                $.each(treeNode.parents, function (assocName, parents) {
                    params = ['f_an=' + assocName, 'f_euri=' + resource.uri];
                    $.each(parents, function (index, parentNode) {
                        parentNode = processTreeNode(parentNode, true, params,
                            (!associationParams));
                        addLink(parentNode, node);
                    });
                });
                
                // add children
                $.each(treeNode.children, function (assocName, children) {
                    params = ['f_an=' + assocName, 'f_suri=' + resource.uri];
                    $.each(children, function (index, childNode) {
                        childNode = processTreeNode(childNode, false, params,
                            (!associationParams));
                        addLink(node, childNode);
                    });
                });
                
                return node;
            }
            
            function setRowIndexes() {
                var length, i;
                length = rows.length;
                for (i=0; i<length; i++) {
                    rows[i].setIndex(i);
                }
            }
            
            function selectNode(uri) {
                var length, i, row, selectedRow;
                var ancestorColumn = 0;
                var ancestorPositive = false;
                var ancestorCount = 0;
                var descendantColumn = 0;
                var descendantPositive = false;
                var descendantCount = 0;
                
                selectedNode = nodeIndex[uri];
                selectedNode.setSelected(true);
                selectedRow = selectedNode.row();
                selectedRow.setColumn(0);
                
                // Assign single node ancestor and descendent rows
                // alternating column offsets. First will be +1, next -1,
                // then +2, then -2, and so on.
                
                // ancestors, center to top
                for (i=(selectedRow.index()-1); i>=0; i--) {
                    row = rows[i];
                    if (row.singleNode()) {
                        row.setColumn(ancestorColumn);
                        if (ancestorPositive) {
                            ancestorColumn = -ancestorColumn;
                        } else {
                            ancestorColumn = Math.abs(ancestorColumn) + 1;
                        }
                        ancestorPositive = (! ancestorPositive);
                        ancestorCount += 1;
                    }
                }
                
                // descendents, center to bottom
                length = rows.length;
                for (i=(selectedRow.index()+1); i<length; i++) {
                    row = rows[i];
                    if (row.singleNode()) {
                        row.setColumn(descendantColumn);
                        if (ancestorPositive) {
                            descendantColumn = -descendantColumn;
                        } else {
                            descendantColumn = Math.abs(descendantColumn) + 1;
                        }
                        descendantPositive = (! descendantPositive);
                        descendantCount += 1;
                    }
                }
                
                numColumns = Math.max(1, ancestorCount, descendantCount);
            }
            
            function clearHighlight() {
                var length, i, node, link;
                
                length = highlightedNodes.length
                for (i=0; i<length; i++) {
                    node = highlightedNodes[i];
                    node.setHighlighted(false);
                }
                highlightedNodes = [];
                
                length = highlightedLinks.length
                for (i=0; i<length; i++) {
                    link = highlightedLinks[i];
                    link.setHighlighted(false);
                }
                highlightedLinks = [];
            }
            
            this.rows = function () {
                return rows;
            };
            
            this.links = function () {
                return links;
            };
            
            this.numColumns = function () {
                return numColumns;
            };
            
            this.selectedNode = function () {
                return selectedNode;
            };
            
            this.hasHighlight = function () {
                return highlightedNodes.length > 0;
            };
            
            this.highlightedNodes = function () {
                return highlightedNodes;
            };
            
            this.highlightedLinks = function () {
                return highlightedLinks;
            };
            
            /*this.linksToNodeById = function (id) {
                var result = [];
                var length, i, link;
                for (i=0; i<length; i++) {
                    link = links[i];
                    if (link.hasNodeById(id)) {
                        result.push(link);
                    }
                }
                return result;
            };*///
            
            this.highlightNode = function (id) {
                var length, i, node, link;
                
                clearHighlight();
                
                node = nodeIndex[id];
                highlightedLinks = node.links();
                
                length = highlightedLinks.length;
                for (i=0; i<length; i++) {
                    link = highlightedLinks[i];
                    link.setHighlighted(true);
                    
                    link.parentNode().setHighlighted(true);
                    link.childNode().setHighlighted(true);
                    highlightedNodes.push(link.parentNode());
                    highlightedNodes.push(link.childNode());
                }
            };
            
            this.removeHighlight = function () {
                clearHighlight();
            };
            
            this.init = function(treeData) {
                // start from the root of the tree
                processTreeNode(treeData);
                setRowIndexes();
                selectNode(treeData.resource.uri);
            };
            
            this.destroy = function() {
                var length, i;
                
                rowIndex = null;
                nodeIndex = null;
                selectedNode = null;
                highlightedNodes = null;
                highlightedLinks = null;
                
                length = links.length;
                for (i=0; i<length; i++) {
                    links[i].destroy();
                }
                links = null;
                
                length = rows.length;
                for (i=0; i<length; i++) {
                    rows[i].destroy();
                }
                rows = null;
            };
        }

        return Map;
    }());

    return Map;
});
