// (C) Copyright 2011-2012 Hewlett-Packard Development Company, L.P.
/**
 * @type {FlyoutView}
 */
define(['hp/core/Localizer',
    'jquery'],
function(localizer) {"use strict";

    var FlyoutView = (function() {
      
        var BODY = '#hp-body-div';
        var PAD = 10;

        function FlyoutView(component, contents, view) {
          
            var flyout = null;
            var anchor = null;
            var timer = null;
            
            function within(comp, x, y) {
                return ((x > (comp.offset().left - PAD) &&
                    (x < (comp.offset().left + comp.outerWidth() + PAD))) &&
                    (y > (comp.offset().top - PAD) &&
                    (y < (comp.offset().top + comp.outerHeight() + PAD))));
            }
            
            function onMouseMove(ev) {
                if (flyout && ! within(flyout, ev.pageX, ev.pageY) &&
                    ! within(anchor, ev.pageX, ev.pageY)) {
                    $(BODY).unbind('mousemove', onMouseMove);
                    $(BODY).unbind('click', onMouseMove);
                    if (view) {
                        view.stop($(ev.target), flyout);
                    }
                    flyout.remove();
                    flyout = null;
                } 
            }
            
            function onMouseLeave(ev) {
                if (timer) {
                    clearTimeout(timer);
                    timer = null;
                }
            }
          
            function onMouseEnter(ev) {
                anchor = $(ev.delegateTarget);
                timer = setTimeout(function () {
                    timer = null;
                    if (! flyout) {
                        flyout = $(contents).filter('.hp-flyout');
                        $(BODY).append(flyout);
                        if (view) {
                            view.start(anchor, flyout);
                        }
                        $(BODY).bind('mousemove', onMouseMove);
                        $(BODY).bind('click', onMouseMove);
                    }
                    var reference = anchor.offset();
                    // ideally, put it above the anchor, if there's room
                    var top = reference.top - flyout.outerHeight() - 8;
                    var left = reference.left;
                    var className = '';
                    if (top < 0) {
                        // not enough room above, try below
                        if ((reference.top + anchor.outerHeight() +
                            flyout.outerHeight() + 8) < $(window).height()) {
                            top = reference.top + anchor.outerHeight() + 8;
                            className = 'hp-flyout-below';
                        } else {
                            top = 0;
                            className = 'hp-flyout-overlap';
                        }
                    }
                    if ((left + flyout.outerWidth()) > $(window).width()) {
                        if ((reference.left - flyout.outerWidth() - 8) > 0) {
                            left = reference.left - flyout.outerWidth() - 8;
                        } else {
                            left = Math.max(0, $(window).width() - flyout.outerWidth());
                        }
                        className += ' hp-flyout-shifted';
                    }
                    flyout.css({'top': top, 'left': left});
                    if (className) {
                        flyout.addClass(className);
                    }
              }, 300);
            }
            
            /**
             * @public
             */
            function initialize() {
                localizer.localizeDom(contents);
                $(component).on('mouseenter', onMouseEnter);
                $(component).on('mouseleave', onMouseLeave);
            }
            
            initialize();
        }

        return FlyoutView;
    }());

    return FlyoutView;
});
